/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest 2.3.0
 *
 * The version of the OpenAPI document: 0.11.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.symbol.sdk.openapi.vertx.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.nem.symbol.sdk.openapi.vertx.model.EmbeddedTransactionDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NetworkTypeEnum;
import io.nem.symbol.sdk.openapi.vertx.model.TransferTransactionBodyDTO;
import io.nem.symbol.sdk.openapi.vertx.model.UnresolvedMosaic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * EmbeddedTransferTransactionDTO
 */
@JsonPropertyOrder({
  EmbeddedTransferTransactionDTO.JSON_PROPERTY_SIGNER_PUBLIC_KEY,
  EmbeddedTransferTransactionDTO.JSON_PROPERTY_VERSION,
  EmbeddedTransferTransactionDTO.JSON_PROPERTY_NETWORK,
  EmbeddedTransferTransactionDTO.JSON_PROPERTY_TYPE,
  EmbeddedTransferTransactionDTO.JSON_PROPERTY_RECIPIENT_ADDRESS,
  EmbeddedTransferTransactionDTO.JSON_PROPERTY_MOSAICS,
  EmbeddedTransferTransactionDTO.JSON_PROPERTY_MESSAGE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2021-01-14T22:22:33.231Z[UTC]")
public class EmbeddedTransferTransactionDTO {
  public static final String JSON_PROPERTY_SIGNER_PUBLIC_KEY = "signerPublicKey";
  private String signerPublicKey;

  public static final String JSON_PROPERTY_VERSION = "version";
  private Integer version;

  public static final String JSON_PROPERTY_NETWORK = "network";
  private NetworkTypeEnum network;

  public static final String JSON_PROPERTY_TYPE = "type";
  private Integer type;

  public static final String JSON_PROPERTY_RECIPIENT_ADDRESS = "recipientAddress";
  private String recipientAddress;

  public static final String JSON_PROPERTY_MOSAICS = "mosaics";
  private List<UnresolvedMosaic> mosaics = new ArrayList<>();

  public static final String JSON_PROPERTY_MESSAGE = "message";
  private String message;


  public EmbeddedTransferTransactionDTO signerPublicKey(String signerPublicKey) {
    
    this.signerPublicKey = signerPublicKey;
    return this;
  }

   /**
   * Public key.
   * @return signerPublicKey
  **/
  @ApiModelProperty(example = "AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required = true, value = "Public key.")
  @JsonProperty(JSON_PROPERTY_SIGNER_PUBLIC_KEY)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSignerPublicKey() {
    return signerPublicKey;
  }


  public void setSignerPublicKey(String signerPublicKey) {
    this.signerPublicKey = signerPublicKey;
  }


  public EmbeddedTransferTransactionDTO version(Integer version) {
    
    this.version = version;
    return this;
  }

   /**
   * Entity version.
   * @return version
  **/
  @ApiModelProperty(required = true, value = "Entity version.")
  @JsonProperty(JSON_PROPERTY_VERSION)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getVersion() {
    return version;
  }


  public void setVersion(Integer version) {
    this.version = version;
  }


  public EmbeddedTransferTransactionDTO network(NetworkTypeEnum network) {
    
    this.network = network;
    return this;
  }

   /**
   * Get network
   * @return network
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_NETWORK)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public NetworkTypeEnum getNetwork() {
    return network;
  }


  public void setNetwork(NetworkTypeEnum network) {
    this.network = network;
  }


  public EmbeddedTransferTransactionDTO type(Integer type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TYPE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getType() {
    return type;
  }


  public void setType(Integer type) {
    this.type = type;
  }


  public EmbeddedTransferTransactionDTO recipientAddress(String recipientAddress) {
    
    this.recipientAddress = recipientAddress;
    return this;
  }

   /**
   * Address expressed in hexadecimal base. If the bit 0 of byte 0 is not set (like in 0x90), then it is a regular address. Else (e.g. 0x91) it represents a namespace id which starts at byte 1. 
   * @return recipientAddress
  **/
  @ApiModelProperty(example = "90340017CFF3DD2BCF3B2670CDCB9FC8C75754E2325F297C", required = true, value = "Address expressed in hexadecimal base. If the bit 0 of byte 0 is not set (like in 0x90), then it is a regular address. Else (e.g. 0x91) it represents a namespace id which starts at byte 1. ")
  @JsonProperty(JSON_PROPERTY_RECIPIENT_ADDRESS)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRecipientAddress() {
    return recipientAddress;
  }


  public void setRecipientAddress(String recipientAddress) {
    this.recipientAddress = recipientAddress;
  }


  public EmbeddedTransferTransactionDTO mosaics(List<UnresolvedMosaic> mosaics) {
    
    this.mosaics = mosaics;
    return this;
  }

  public EmbeddedTransferTransactionDTO addMosaicsItem(UnresolvedMosaic mosaicsItem) {
    this.mosaics.add(mosaicsItem);
    return this;
  }

   /**
   * Array of mosaics sent to the recipient. 
   * @return mosaics
  **/
  @ApiModelProperty(required = true, value = "Array of mosaics sent to the recipient. ")
  @JsonProperty(JSON_PROPERTY_MOSAICS)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<UnresolvedMosaic> getMosaics() {
    return mosaics;
  }


  public void setMosaics(List<UnresolvedMosaic> mosaics) {
    this.mosaics = mosaics;
  }


  public EmbeddedTransferTransactionDTO message(String message) {
    
    this.message = message;
    return this;
  }

   /**
   * Transfer transaction message
   * @return message
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Transfer transaction message")
  @JsonProperty(JSON_PROPERTY_MESSAGE)
  // @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMessage() {
    return message;
  }


  public void setMessage(String message) {
    this.message = message;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EmbeddedTransferTransactionDTO embeddedTransferTransactionDTO = (EmbeddedTransferTransactionDTO) o;
    return Objects.equals(this.signerPublicKey, embeddedTransferTransactionDTO.signerPublicKey) &&
        Objects.equals(this.version, embeddedTransferTransactionDTO.version) &&
        Objects.equals(this.network, embeddedTransferTransactionDTO.network) &&
        Objects.equals(this.type, embeddedTransferTransactionDTO.type) &&
        Objects.equals(this.recipientAddress, embeddedTransferTransactionDTO.recipientAddress) &&
        Objects.equals(this.mosaics, embeddedTransferTransactionDTO.mosaics) &&
        Objects.equals(this.message, embeddedTransferTransactionDTO.message);
  }

  @Override
  public int hashCode() {
    return Objects.hash(signerPublicKey, version, network, type, recipientAddress, mosaics, message);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EmbeddedTransferTransactionDTO {\n");
    sb.append("    signerPublicKey: ").append(toIndentedString(signerPublicKey)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    network: ").append(toIndentedString(network)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    recipientAddress: ").append(toIndentedString(recipientAddress)).append("\n");
    sb.append("    mosaics: ").append(toIndentedString(mosaics)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

