/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest 2.3.0
 *
 * The version of the OpenAPI document: 0.11.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.symbol.sdk.openapi.vertx.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Chain related configuration properties.
 */
@ApiModel(description = "Chain related configuration properties.")
@JsonPropertyOrder({
  ChainPropertiesDTO.JSON_PROPERTY_ENABLE_VERIFIABLE_STATE,
  ChainPropertiesDTO.JSON_PROPERTY_ENABLE_VERIFIABLE_RECEIPTS,
  ChainPropertiesDTO.JSON_PROPERTY_CURRENCY_MOSAIC_ID,
  ChainPropertiesDTO.JSON_PROPERTY_HARVESTING_MOSAIC_ID,
  ChainPropertiesDTO.JSON_PROPERTY_BLOCK_GENERATION_TARGET_TIME,
  ChainPropertiesDTO.JSON_PROPERTY_BLOCK_TIME_SMOOTHING_FACTOR,
  ChainPropertiesDTO.JSON_PROPERTY_BLOCK_FINALIZATION_INTERVAL,
  ChainPropertiesDTO.JSON_PROPERTY_IMPORTANCE_GROUPING,
  ChainPropertiesDTO.JSON_PROPERTY_IMPORTANCE_ACTIVITY_PERCENTAGE,
  ChainPropertiesDTO.JSON_PROPERTY_MAX_ROLLBACK_BLOCKS,
  ChainPropertiesDTO.JSON_PROPERTY_MAX_DIFFICULTY_BLOCKS,
  ChainPropertiesDTO.JSON_PROPERTY_DEFAULT_DYNAMIC_FEE_MULTIPLIER,
  ChainPropertiesDTO.JSON_PROPERTY_MAX_TRANSACTION_LIFETIME,
  ChainPropertiesDTO.JSON_PROPERTY_MAX_BLOCK_FUTURE_TIME,
  ChainPropertiesDTO.JSON_PROPERTY_INITIAL_CURRENCY_ATOMIC_UNITS,
  ChainPropertiesDTO.JSON_PROPERTY_MAX_MOSAIC_ATOMIC_UNITS,
  ChainPropertiesDTO.JSON_PROPERTY_TOTAL_CHAIN_IMPORTANCE,
  ChainPropertiesDTO.JSON_PROPERTY_MIN_HARVESTER_BALANCE,
  ChainPropertiesDTO.JSON_PROPERTY_MAX_HARVESTER_BALANCE,
  ChainPropertiesDTO.JSON_PROPERTY_MIN_VOTER_BALANCE,
  ChainPropertiesDTO.JSON_PROPERTY_MAX_VOTING_KEYS_PER_ACCOUNT,
  ChainPropertiesDTO.JSON_PROPERTY_MIN_VOTING_KEY_LIFETIME,
  ChainPropertiesDTO.JSON_PROPERTY_MAX_VOTING_KEY_LIFETIME,
  ChainPropertiesDTO.JSON_PROPERTY_HARVEST_BENEFICIARY_PERCENTAGE,
  ChainPropertiesDTO.JSON_PROPERTY_HARVEST_NETWORK_PERCENTAGE,
  ChainPropertiesDTO.JSON_PROPERTY_HARVEST_NETWORK_FEE_SINK_ADDRESS,
  ChainPropertiesDTO.JSON_PROPERTY_BLOCK_PRUNE_INTERVAL,
  ChainPropertiesDTO.JSON_PROPERTY_MAX_TRANSACTIONS_PER_BLOCK
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2021-01-14T22:22:33.231Z[UTC]")
public class ChainPropertiesDTO {
  public static final String JSON_PROPERTY_ENABLE_VERIFIABLE_STATE = "enableVerifiableState";
  private Boolean enableVerifiableState;

  public static final String JSON_PROPERTY_ENABLE_VERIFIABLE_RECEIPTS = "enableVerifiableReceipts";
  private Boolean enableVerifiableReceipts;

  public static final String JSON_PROPERTY_CURRENCY_MOSAIC_ID = "currencyMosaicId";
  private String currencyMosaicId;

  public static final String JSON_PROPERTY_HARVESTING_MOSAIC_ID = "harvestingMosaicId";
  private String harvestingMosaicId;

  public static final String JSON_PROPERTY_BLOCK_GENERATION_TARGET_TIME = "blockGenerationTargetTime";
  private String blockGenerationTargetTime;

  public static final String JSON_PROPERTY_BLOCK_TIME_SMOOTHING_FACTOR = "blockTimeSmoothingFactor";
  private String blockTimeSmoothingFactor;

  public static final String JSON_PROPERTY_BLOCK_FINALIZATION_INTERVAL = "blockFinalizationInterval";
  private String blockFinalizationInterval;

  public static final String JSON_PROPERTY_IMPORTANCE_GROUPING = "importanceGrouping";
  private String importanceGrouping;

  public static final String JSON_PROPERTY_IMPORTANCE_ACTIVITY_PERCENTAGE = "importanceActivityPercentage";
  private String importanceActivityPercentage;

  public static final String JSON_PROPERTY_MAX_ROLLBACK_BLOCKS = "maxRollbackBlocks";
  private String maxRollbackBlocks;

  public static final String JSON_PROPERTY_MAX_DIFFICULTY_BLOCKS = "maxDifficultyBlocks";
  private String maxDifficultyBlocks;

  public static final String JSON_PROPERTY_DEFAULT_DYNAMIC_FEE_MULTIPLIER = "defaultDynamicFeeMultiplier";
  private String defaultDynamicFeeMultiplier;

  public static final String JSON_PROPERTY_MAX_TRANSACTION_LIFETIME = "maxTransactionLifetime";
  private String maxTransactionLifetime;

  public static final String JSON_PROPERTY_MAX_BLOCK_FUTURE_TIME = "maxBlockFutureTime";
  private String maxBlockFutureTime;

  public static final String JSON_PROPERTY_INITIAL_CURRENCY_ATOMIC_UNITS = "initialCurrencyAtomicUnits";
  private String initialCurrencyAtomicUnits;

  public static final String JSON_PROPERTY_MAX_MOSAIC_ATOMIC_UNITS = "maxMosaicAtomicUnits";
  private String maxMosaicAtomicUnits;

  public static final String JSON_PROPERTY_TOTAL_CHAIN_IMPORTANCE = "totalChainImportance";
  private String totalChainImportance;

  public static final String JSON_PROPERTY_MIN_HARVESTER_BALANCE = "minHarvesterBalance";
  private String minHarvesterBalance;

  public static final String JSON_PROPERTY_MAX_HARVESTER_BALANCE = "maxHarvesterBalance";
  private String maxHarvesterBalance;

  public static final String JSON_PROPERTY_MIN_VOTER_BALANCE = "minVoterBalance";
  private String minVoterBalance;

  public static final String JSON_PROPERTY_MAX_VOTING_KEYS_PER_ACCOUNT = "maxVotingKeysPerAccount";
  private String maxVotingKeysPerAccount;

  public static final String JSON_PROPERTY_MIN_VOTING_KEY_LIFETIME = "minVotingKeyLifetime";
  private String minVotingKeyLifetime;

  public static final String JSON_PROPERTY_MAX_VOTING_KEY_LIFETIME = "maxVotingKeyLifetime";
  private String maxVotingKeyLifetime;

  public static final String JSON_PROPERTY_HARVEST_BENEFICIARY_PERCENTAGE = "harvestBeneficiaryPercentage";
  private String harvestBeneficiaryPercentage;

  public static final String JSON_PROPERTY_HARVEST_NETWORK_PERCENTAGE = "harvestNetworkPercentage";
  private String harvestNetworkPercentage;

  public static final String JSON_PROPERTY_HARVEST_NETWORK_FEE_SINK_ADDRESS = "harvestNetworkFeeSinkAddress";
  private String harvestNetworkFeeSinkAddress;

  public static final String JSON_PROPERTY_BLOCK_PRUNE_INTERVAL = "blockPruneInterval";
  private String blockPruneInterval;

  public static final String JSON_PROPERTY_MAX_TRANSACTIONS_PER_BLOCK = "maxTransactionsPerBlock";
  private String maxTransactionsPerBlock;


  public ChainPropertiesDTO enableVerifiableState(Boolean enableVerifiableState) {
    
    this.enableVerifiableState = enableVerifiableState;
    return this;
  }

   /**
   * Set to true if block chain should calculate state hashes so that state is fully verifiable at each block.
   * @return enableVerifiableState
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Set to true if block chain should calculate state hashes so that state is fully verifiable at each block.")
  @JsonProperty(JSON_PROPERTY_ENABLE_VERIFIABLE_STATE)
  // @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEnableVerifiableState() {
    return enableVerifiableState;
  }


  public void setEnableVerifiableState(Boolean enableVerifiableState) {
    this.enableVerifiableState = enableVerifiableState;
  }


  public ChainPropertiesDTO enableVerifiableReceipts(Boolean enableVerifiableReceipts) {
    
    this.enableVerifiableReceipts = enableVerifiableReceipts;
    return this;
  }

   /**
   * Set to true if block chain should calculate receipts so that state changes are fully verifiable at each block.
   * @return enableVerifiableReceipts
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Set to true if block chain should calculate receipts so that state changes are fully verifiable at each block.")
  @JsonProperty(JSON_PROPERTY_ENABLE_VERIFIABLE_RECEIPTS)
  // @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEnableVerifiableReceipts() {
    return enableVerifiableReceipts;
  }


  public void setEnableVerifiableReceipts(Boolean enableVerifiableReceipts) {
    this.enableVerifiableReceipts = enableVerifiableReceipts;
  }


  public ChainPropertiesDTO currencyMosaicId(String currencyMosaicId) {
    
    this.currencyMosaicId = currencyMosaicId;
    return this;
  }

   /**
   * Mosaic id used as primary chain currency.
   * @return currencyMosaicId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "0x24F4'26B8'D549'3D4B", value = "Mosaic id used as primary chain currency.")
  @JsonProperty(JSON_PROPERTY_CURRENCY_MOSAIC_ID)
  // @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrencyMosaicId() {
    return currencyMosaicId;
  }


  public void setCurrencyMosaicId(String currencyMosaicId) {
    this.currencyMosaicId = currencyMosaicId;
  }


  public ChainPropertiesDTO harvestingMosaicId(String harvestingMosaicId) {
    
    this.harvestingMosaicId = harvestingMosaicId;
    return this;
  }

   /**
   * Mosaic id used to provide harvesting ability.
   * @return harvestingMosaicId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "0x1D9C'DC7E'218C'A88D", value = "Mosaic id used to provide harvesting ability.")
  @JsonProperty(JSON_PROPERTY_HARVESTING_MOSAIC_ID)
  // @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHarvestingMosaicId() {
    return harvestingMosaicId;
  }


  public void setHarvestingMosaicId(String harvestingMosaicId) {
    this.harvestingMosaicId = harvestingMosaicId;
  }


  public ChainPropertiesDTO blockGenerationTargetTime(String blockGenerationTargetTime) {
    
    this.blockGenerationTargetTime = blockGenerationTargetTime;
    return this;
  }

   /**
   * Targeted time between blocks.
   * @return blockGenerationTargetTime
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "30s", value = "Targeted time between blocks.")
  @JsonProperty(JSON_PROPERTY_BLOCK_GENERATION_TARGET_TIME)
  // @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBlockGenerationTargetTime() {
    return blockGenerationTargetTime;
  }


  public void setBlockGenerationTargetTime(String blockGenerationTargetTime) {
    this.blockGenerationTargetTime = blockGenerationTargetTime;
  }


  public ChainPropertiesDTO blockTimeSmoothingFactor(String blockTimeSmoothingFactor) {
    
    this.blockTimeSmoothingFactor = blockTimeSmoothingFactor;
    return this;
  }

   /**
   * A higher value makes the network more biased.
   * @return blockTimeSmoothingFactor
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "3000", value = "A higher value makes the network more biased.")
  @JsonProperty(JSON_PROPERTY_BLOCK_TIME_SMOOTHING_FACTOR)
  // @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBlockTimeSmoothingFactor() {
    return blockTimeSmoothingFactor;
  }


  public void setBlockTimeSmoothingFactor(String blockTimeSmoothingFactor) {
    this.blockTimeSmoothingFactor = blockTimeSmoothingFactor;
  }


  public ChainPropertiesDTO blockFinalizationInterval(String blockFinalizationInterval) {
    
    this.blockFinalizationInterval = blockFinalizationInterval;
    return this;
  }

   /**
   * Number of blocks between successive finalization attempts.
   * @return blockFinalizationInterval
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "30", value = "Number of blocks between successive finalization attempts.")
  @JsonProperty(JSON_PROPERTY_BLOCK_FINALIZATION_INTERVAL)
  // @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBlockFinalizationInterval() {
    return blockFinalizationInterval;
  }


  public void setBlockFinalizationInterval(String blockFinalizationInterval) {
    this.blockFinalizationInterval = blockFinalizationInterval;
  }


  public ChainPropertiesDTO importanceGrouping(String importanceGrouping) {
    
    this.importanceGrouping = importanceGrouping;
    return this;
  }

   /**
   * Number of blocks that should be treated as a group for importance purposes.
   * @return importanceGrouping
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "39", value = "Number of blocks that should be treated as a group for importance purposes.")
  @JsonProperty(JSON_PROPERTY_IMPORTANCE_GROUPING)
  // @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getImportanceGrouping() {
    return importanceGrouping;
  }


  public void setImportanceGrouping(String importanceGrouping) {
    this.importanceGrouping = importanceGrouping;
  }


  public ChainPropertiesDTO importanceActivityPercentage(String importanceActivityPercentage) {
    
    this.importanceActivityPercentage = importanceActivityPercentage;
    return this;
  }

   /**
   * Percentage of importance resulting from fee generation and beneficiary usage.
   * @return importanceActivityPercentage
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "5", value = "Percentage of importance resulting from fee generation and beneficiary usage.")
  @JsonProperty(JSON_PROPERTY_IMPORTANCE_ACTIVITY_PERCENTAGE)
  // @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getImportanceActivityPercentage() {
    return importanceActivityPercentage;
  }


  public void setImportanceActivityPercentage(String importanceActivityPercentage) {
    this.importanceActivityPercentage = importanceActivityPercentage;
  }


  public ChainPropertiesDTO maxRollbackBlocks(String maxRollbackBlocks) {
    
    this.maxRollbackBlocks = maxRollbackBlocks;
    return this;
  }

   /**
   * Maximum number of blocks that can be rolled back.
   * @return maxRollbackBlocks
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "40", value = "Maximum number of blocks that can be rolled back.")
  @JsonProperty(JSON_PROPERTY_MAX_ROLLBACK_BLOCKS)
  // @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMaxRollbackBlocks() {
    return maxRollbackBlocks;
  }


  public void setMaxRollbackBlocks(String maxRollbackBlocks) {
    this.maxRollbackBlocks = maxRollbackBlocks;
  }


  public ChainPropertiesDTO maxDifficultyBlocks(String maxDifficultyBlocks) {
    
    this.maxDifficultyBlocks = maxDifficultyBlocks;
    return this;
  }

   /**
   * Maximum number of blocks to use in a difficulty calculation.
   * @return maxDifficultyBlocks
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "60", value = "Maximum number of blocks to use in a difficulty calculation.")
  @JsonProperty(JSON_PROPERTY_MAX_DIFFICULTY_BLOCKS)
  // @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMaxDifficultyBlocks() {
    return maxDifficultyBlocks;
  }


  public void setMaxDifficultyBlocks(String maxDifficultyBlocks) {
    this.maxDifficultyBlocks = maxDifficultyBlocks;
  }


  public ChainPropertiesDTO defaultDynamicFeeMultiplier(String defaultDynamicFeeMultiplier) {
    
    this.defaultDynamicFeeMultiplier = defaultDynamicFeeMultiplier;
    return this;
  }

   /**
   * Default multiplier to use for dynamic fees.
   * @return defaultDynamicFeeMultiplier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "10'000", value = "Default multiplier to use for dynamic fees.")
  @JsonProperty(JSON_PROPERTY_DEFAULT_DYNAMIC_FEE_MULTIPLIER)
  // @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDefaultDynamicFeeMultiplier() {
    return defaultDynamicFeeMultiplier;
  }


  public void setDefaultDynamicFeeMultiplier(String defaultDynamicFeeMultiplier) {
    this.defaultDynamicFeeMultiplier = defaultDynamicFeeMultiplier;
  }


  public ChainPropertiesDTO maxTransactionLifetime(String maxTransactionLifetime) {
    
    this.maxTransactionLifetime = maxTransactionLifetime;
    return this;
  }

   /**
   * Maximum lifetime a transaction can have before it expires.
   * @return maxTransactionLifetime
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "24h", value = "Maximum lifetime a transaction can have before it expires.")
  @JsonProperty(JSON_PROPERTY_MAX_TRANSACTION_LIFETIME)
  // @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMaxTransactionLifetime() {
    return maxTransactionLifetime;
  }


  public void setMaxTransactionLifetime(String maxTransactionLifetime) {
    this.maxTransactionLifetime = maxTransactionLifetime;
  }


  public ChainPropertiesDTO maxBlockFutureTime(String maxBlockFutureTime) {
    
    this.maxBlockFutureTime = maxBlockFutureTime;
    return this;
  }

   /**
   * Maximum future time of a block that can be accepted.
   * @return maxBlockFutureTime
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "500ms", value = "Maximum future time of a block that can be accepted.")
  @JsonProperty(JSON_PROPERTY_MAX_BLOCK_FUTURE_TIME)
  // @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMaxBlockFutureTime() {
    return maxBlockFutureTime;
  }


  public void setMaxBlockFutureTime(String maxBlockFutureTime) {
    this.maxBlockFutureTime = maxBlockFutureTime;
  }


  public ChainPropertiesDTO initialCurrencyAtomicUnits(String initialCurrencyAtomicUnits) {
    
    this.initialCurrencyAtomicUnits = initialCurrencyAtomicUnits;
    return this;
  }

   /**
   * Initial currency atomic units available in the network.
   * @return initialCurrencyAtomicUnits
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "8'998'999'998'000'000", value = "Initial currency atomic units available in the network.")
  @JsonProperty(JSON_PROPERTY_INITIAL_CURRENCY_ATOMIC_UNITS)
  // @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getInitialCurrencyAtomicUnits() {
    return initialCurrencyAtomicUnits;
  }


  public void setInitialCurrencyAtomicUnits(String initialCurrencyAtomicUnits) {
    this.initialCurrencyAtomicUnits = initialCurrencyAtomicUnits;
  }


  public ChainPropertiesDTO maxMosaicAtomicUnits(String maxMosaicAtomicUnits) {
    
    this.maxMosaicAtomicUnits = maxMosaicAtomicUnits;
    return this;
  }

   /**
   * Maximum atomic units (total-supply * 10 ^ divisibility) of a mosaic allowed in the network.
   * @return maxMosaicAtomicUnits
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "9'000'000'000'000'000", value = "Maximum atomic units (total-supply * 10 ^ divisibility) of a mosaic allowed in the network.")
  @JsonProperty(JSON_PROPERTY_MAX_MOSAIC_ATOMIC_UNITS)
  // @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMaxMosaicAtomicUnits() {
    return maxMosaicAtomicUnits;
  }


  public void setMaxMosaicAtomicUnits(String maxMosaicAtomicUnits) {
    this.maxMosaicAtomicUnits = maxMosaicAtomicUnits;
  }


  public ChainPropertiesDTO totalChainImportance(String totalChainImportance) {
    
    this.totalChainImportance = totalChainImportance;
    return this;
  }

   /**
   * Total whole importance units available in the network.
   * @return totalChainImportance
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "15'000'000", value = "Total whole importance units available in the network.")
  @JsonProperty(JSON_PROPERTY_TOTAL_CHAIN_IMPORTANCE)
  // @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTotalChainImportance() {
    return totalChainImportance;
  }


  public void setTotalChainImportance(String totalChainImportance) {
    this.totalChainImportance = totalChainImportance;
  }


  public ChainPropertiesDTO minHarvesterBalance(String minHarvesterBalance) {
    
    this.minHarvesterBalance = minHarvesterBalance;
    return this;
  }

   /**
   * Minimum number of harvesting mosaic atomic units needed for an account to be eligible for harvesting.
   * @return minHarvesterBalance
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "500", value = "Minimum number of harvesting mosaic atomic units needed for an account to be eligible for harvesting.")
  @JsonProperty(JSON_PROPERTY_MIN_HARVESTER_BALANCE)
  // @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMinHarvesterBalance() {
    return minHarvesterBalance;
  }


  public void setMinHarvesterBalance(String minHarvesterBalance) {
    this.minHarvesterBalance = minHarvesterBalance;
  }


  public ChainPropertiesDTO maxHarvesterBalance(String maxHarvesterBalance) {
    
    this.maxHarvesterBalance = maxHarvesterBalance;
    return this;
  }

   /**
   * Maximum number of harvesting mosaic atomic units needed for an account to be eligible for harvesting.
   * @return maxHarvesterBalance
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "4'000'000", value = "Maximum number of harvesting mosaic atomic units needed for an account to be eligible for harvesting.")
  @JsonProperty(JSON_PROPERTY_MAX_HARVESTER_BALANCE)
  // @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMaxHarvesterBalance() {
    return maxHarvesterBalance;
  }


  public void setMaxHarvesterBalance(String maxHarvesterBalance) {
    this.maxHarvesterBalance = maxHarvesterBalance;
  }


  public ChainPropertiesDTO minVoterBalance(String minVoterBalance) {
    
    this.minVoterBalance = minVoterBalance;
    return this;
  }

   /**
   * Minimum number of harvesting mosaic atomic units needed for an account to be eligible for voting.
   * @return minVoterBalance
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "50'000", value = "Minimum number of harvesting mosaic atomic units needed for an account to be eligible for voting.")
  @JsonProperty(JSON_PROPERTY_MIN_VOTER_BALANCE)
  // @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMinVoterBalance() {
    return minVoterBalance;
  }


  public void setMinVoterBalance(String minVoterBalance) {
    this.minVoterBalance = minVoterBalance;
  }


  public ChainPropertiesDTO maxVotingKeysPerAccount(String maxVotingKeysPerAccount) {
    
    this.maxVotingKeysPerAccount = maxVotingKeysPerAccount;
    return this;
  }

   /**
   * Maximum number of voting keys that can be registered at once per account.
   * @return maxVotingKeysPerAccount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "3", value = "Maximum number of voting keys that can be registered at once per account.")
  @JsonProperty(JSON_PROPERTY_MAX_VOTING_KEYS_PER_ACCOUNT)
  // @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMaxVotingKeysPerAccount() {
    return maxVotingKeysPerAccount;
  }


  public void setMaxVotingKeysPerAccount(String maxVotingKeysPerAccount) {
    this.maxVotingKeysPerAccount = maxVotingKeysPerAccount;
  }


  public ChainPropertiesDTO minVotingKeyLifetime(String minVotingKeyLifetime) {
    
    this.minVotingKeyLifetime = minVotingKeyLifetime;
    return this;
  }

   /**
   * Minimum number of finalization rounds for which voting key can be registered.
   * @return minVotingKeyLifetime
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "72", value = "Minimum number of finalization rounds for which voting key can be registered.")
  @JsonProperty(JSON_PROPERTY_MIN_VOTING_KEY_LIFETIME)
  // @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMinVotingKeyLifetime() {
    return minVotingKeyLifetime;
  }


  public void setMinVotingKeyLifetime(String minVotingKeyLifetime) {
    this.minVotingKeyLifetime = minVotingKeyLifetime;
  }


  public ChainPropertiesDTO maxVotingKeyLifetime(String maxVotingKeyLifetime) {
    
    this.maxVotingKeyLifetime = maxVotingKeyLifetime;
    return this;
  }

   /**
   * Maximum number of finalization rounds for which voting key can be registered.
   * @return maxVotingKeyLifetime
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "26280", value = "Maximum number of finalization rounds for which voting key can be registered.")
  @JsonProperty(JSON_PROPERTY_MAX_VOTING_KEY_LIFETIME)
  // @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMaxVotingKeyLifetime() {
    return maxVotingKeyLifetime;
  }


  public void setMaxVotingKeyLifetime(String maxVotingKeyLifetime) {
    this.maxVotingKeyLifetime = maxVotingKeyLifetime;
  }


  public ChainPropertiesDTO harvestBeneficiaryPercentage(String harvestBeneficiaryPercentage) {
    
    this.harvestBeneficiaryPercentage = harvestBeneficiaryPercentage;
    return this;
  }

   /**
   * Percentage of the harvested fee that is collected by the beneficiary account.
   * @return harvestBeneficiaryPercentage
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "10", value = "Percentage of the harvested fee that is collected by the beneficiary account.")
  @JsonProperty(JSON_PROPERTY_HARVEST_BENEFICIARY_PERCENTAGE)
  // @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHarvestBeneficiaryPercentage() {
    return harvestBeneficiaryPercentage;
  }


  public void setHarvestBeneficiaryPercentage(String harvestBeneficiaryPercentage) {
    this.harvestBeneficiaryPercentage = harvestBeneficiaryPercentage;
  }


  public ChainPropertiesDTO harvestNetworkPercentage(String harvestNetworkPercentage) {
    
    this.harvestNetworkPercentage = harvestNetworkPercentage;
    return this;
  }

   /**
   * Percentage of the harvested fee that is collected by the network.
   * @return harvestNetworkPercentage
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "5", value = "Percentage of the harvested fee that is collected by the network.")
  @JsonProperty(JSON_PROPERTY_HARVEST_NETWORK_PERCENTAGE)
  // @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHarvestNetworkPercentage() {
    return harvestNetworkPercentage;
  }


  public void setHarvestNetworkPercentage(String harvestNetworkPercentage) {
    this.harvestNetworkPercentage = harvestNetworkPercentage;
  }


  public ChainPropertiesDTO harvestNetworkFeeSinkAddress(String harvestNetworkFeeSinkAddress) {
    
    this.harvestNetworkFeeSinkAddress = harvestNetworkFeeSinkAddress;
    return this;
  }

   /**
   * Address encoded using a 32-character set.
   * @return harvestNetworkFeeSinkAddress
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "SAAA244WMCB2JXGNQTQHQOS45TGBFF4V2MJBVOQ", value = "Address encoded using a 32-character set.")
  @JsonProperty(JSON_PROPERTY_HARVEST_NETWORK_FEE_SINK_ADDRESS)
  // @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHarvestNetworkFeeSinkAddress() {
    return harvestNetworkFeeSinkAddress;
  }


  public void setHarvestNetworkFeeSinkAddress(String harvestNetworkFeeSinkAddress) {
    this.harvestNetworkFeeSinkAddress = harvestNetworkFeeSinkAddress;
  }


  public ChainPropertiesDTO blockPruneInterval(String blockPruneInterval) {
    
    this.blockPruneInterval = blockPruneInterval;
    return this;
  }

   /**
   * Number of blocks between cache pruning.
   * @return blockPruneInterval
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "360", value = "Number of blocks between cache pruning.")
  @JsonProperty(JSON_PROPERTY_BLOCK_PRUNE_INTERVAL)
  // @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBlockPruneInterval() {
    return blockPruneInterval;
  }


  public void setBlockPruneInterval(String blockPruneInterval) {
    this.blockPruneInterval = blockPruneInterval;
  }


  public ChainPropertiesDTO maxTransactionsPerBlock(String maxTransactionsPerBlock) {
    
    this.maxTransactionsPerBlock = maxTransactionsPerBlock;
    return this;
  }

   /**
   * Maximum number of transactions per block.
   * @return maxTransactionsPerBlock
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "200'000", value = "Maximum number of transactions per block.")
  @JsonProperty(JSON_PROPERTY_MAX_TRANSACTIONS_PER_BLOCK)
  // @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMaxTransactionsPerBlock() {
    return maxTransactionsPerBlock;
  }


  public void setMaxTransactionsPerBlock(String maxTransactionsPerBlock) {
    this.maxTransactionsPerBlock = maxTransactionsPerBlock;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ChainPropertiesDTO chainPropertiesDTO = (ChainPropertiesDTO) o;
    return Objects.equals(this.enableVerifiableState, chainPropertiesDTO.enableVerifiableState) &&
        Objects.equals(this.enableVerifiableReceipts, chainPropertiesDTO.enableVerifiableReceipts) &&
        Objects.equals(this.currencyMosaicId, chainPropertiesDTO.currencyMosaicId) &&
        Objects.equals(this.harvestingMosaicId, chainPropertiesDTO.harvestingMosaicId) &&
        Objects.equals(this.blockGenerationTargetTime, chainPropertiesDTO.blockGenerationTargetTime) &&
        Objects.equals(this.blockTimeSmoothingFactor, chainPropertiesDTO.blockTimeSmoothingFactor) &&
        Objects.equals(this.blockFinalizationInterval, chainPropertiesDTO.blockFinalizationInterval) &&
        Objects.equals(this.importanceGrouping, chainPropertiesDTO.importanceGrouping) &&
        Objects.equals(this.importanceActivityPercentage, chainPropertiesDTO.importanceActivityPercentage) &&
        Objects.equals(this.maxRollbackBlocks, chainPropertiesDTO.maxRollbackBlocks) &&
        Objects.equals(this.maxDifficultyBlocks, chainPropertiesDTO.maxDifficultyBlocks) &&
        Objects.equals(this.defaultDynamicFeeMultiplier, chainPropertiesDTO.defaultDynamicFeeMultiplier) &&
        Objects.equals(this.maxTransactionLifetime, chainPropertiesDTO.maxTransactionLifetime) &&
        Objects.equals(this.maxBlockFutureTime, chainPropertiesDTO.maxBlockFutureTime) &&
        Objects.equals(this.initialCurrencyAtomicUnits, chainPropertiesDTO.initialCurrencyAtomicUnits) &&
        Objects.equals(this.maxMosaicAtomicUnits, chainPropertiesDTO.maxMosaicAtomicUnits) &&
        Objects.equals(this.totalChainImportance, chainPropertiesDTO.totalChainImportance) &&
        Objects.equals(this.minHarvesterBalance, chainPropertiesDTO.minHarvesterBalance) &&
        Objects.equals(this.maxHarvesterBalance, chainPropertiesDTO.maxHarvesterBalance) &&
        Objects.equals(this.minVoterBalance, chainPropertiesDTO.minVoterBalance) &&
        Objects.equals(this.maxVotingKeysPerAccount, chainPropertiesDTO.maxVotingKeysPerAccount) &&
        Objects.equals(this.minVotingKeyLifetime, chainPropertiesDTO.minVotingKeyLifetime) &&
        Objects.equals(this.maxVotingKeyLifetime, chainPropertiesDTO.maxVotingKeyLifetime) &&
        Objects.equals(this.harvestBeneficiaryPercentage, chainPropertiesDTO.harvestBeneficiaryPercentage) &&
        Objects.equals(this.harvestNetworkPercentage, chainPropertiesDTO.harvestNetworkPercentage) &&
        Objects.equals(this.harvestNetworkFeeSinkAddress, chainPropertiesDTO.harvestNetworkFeeSinkAddress) &&
        Objects.equals(this.blockPruneInterval, chainPropertiesDTO.blockPruneInterval) &&
        Objects.equals(this.maxTransactionsPerBlock, chainPropertiesDTO.maxTransactionsPerBlock);
  }

  @Override
  public int hashCode() {
    return Objects.hash(enableVerifiableState, enableVerifiableReceipts, currencyMosaicId, harvestingMosaicId, blockGenerationTargetTime, blockTimeSmoothingFactor, blockFinalizationInterval, importanceGrouping, importanceActivityPercentage, maxRollbackBlocks, maxDifficultyBlocks, defaultDynamicFeeMultiplier, maxTransactionLifetime, maxBlockFutureTime, initialCurrencyAtomicUnits, maxMosaicAtomicUnits, totalChainImportance, minHarvesterBalance, maxHarvesterBalance, minVoterBalance, maxVotingKeysPerAccount, minVotingKeyLifetime, maxVotingKeyLifetime, harvestBeneficiaryPercentage, harvestNetworkPercentage, harvestNetworkFeeSinkAddress, blockPruneInterval, maxTransactionsPerBlock);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ChainPropertiesDTO {\n");
    sb.append("    enableVerifiableState: ").append(toIndentedString(enableVerifiableState)).append("\n");
    sb.append("    enableVerifiableReceipts: ").append(toIndentedString(enableVerifiableReceipts)).append("\n");
    sb.append("    currencyMosaicId: ").append(toIndentedString(currencyMosaicId)).append("\n");
    sb.append("    harvestingMosaicId: ").append(toIndentedString(harvestingMosaicId)).append("\n");
    sb.append("    blockGenerationTargetTime: ").append(toIndentedString(blockGenerationTargetTime)).append("\n");
    sb.append("    blockTimeSmoothingFactor: ").append(toIndentedString(blockTimeSmoothingFactor)).append("\n");
    sb.append("    blockFinalizationInterval: ").append(toIndentedString(blockFinalizationInterval)).append("\n");
    sb.append("    importanceGrouping: ").append(toIndentedString(importanceGrouping)).append("\n");
    sb.append("    importanceActivityPercentage: ").append(toIndentedString(importanceActivityPercentage)).append("\n");
    sb.append("    maxRollbackBlocks: ").append(toIndentedString(maxRollbackBlocks)).append("\n");
    sb.append("    maxDifficultyBlocks: ").append(toIndentedString(maxDifficultyBlocks)).append("\n");
    sb.append("    defaultDynamicFeeMultiplier: ").append(toIndentedString(defaultDynamicFeeMultiplier)).append("\n");
    sb.append("    maxTransactionLifetime: ").append(toIndentedString(maxTransactionLifetime)).append("\n");
    sb.append("    maxBlockFutureTime: ").append(toIndentedString(maxBlockFutureTime)).append("\n");
    sb.append("    initialCurrencyAtomicUnits: ").append(toIndentedString(initialCurrencyAtomicUnits)).append("\n");
    sb.append("    maxMosaicAtomicUnits: ").append(toIndentedString(maxMosaicAtomicUnits)).append("\n");
    sb.append("    totalChainImportance: ").append(toIndentedString(totalChainImportance)).append("\n");
    sb.append("    minHarvesterBalance: ").append(toIndentedString(minHarvesterBalance)).append("\n");
    sb.append("    maxHarvesterBalance: ").append(toIndentedString(maxHarvesterBalance)).append("\n");
    sb.append("    minVoterBalance: ").append(toIndentedString(minVoterBalance)).append("\n");
    sb.append("    maxVotingKeysPerAccount: ").append(toIndentedString(maxVotingKeysPerAccount)).append("\n");
    sb.append("    minVotingKeyLifetime: ").append(toIndentedString(minVotingKeyLifetime)).append("\n");
    sb.append("    maxVotingKeyLifetime: ").append(toIndentedString(maxVotingKeyLifetime)).append("\n");
    sb.append("    harvestBeneficiaryPercentage: ").append(toIndentedString(harvestBeneficiaryPercentage)).append("\n");
    sb.append("    harvestNetworkPercentage: ").append(toIndentedString(harvestNetworkPercentage)).append("\n");
    sb.append("    harvestNetworkFeeSinkAddress: ").append(toIndentedString(harvestNetworkFeeSinkAddress)).append("\n");
    sb.append("    blockPruneInterval: ").append(toIndentedString(blockPruneInterval)).append("\n");
    sb.append("    maxTransactionsPerBlock: ").append(toIndentedString(maxTransactionsPerBlock)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

