package io.nem.symbol.sdk.openapi.vertx.api.rxjava;

import io.nem.symbol.sdk.openapi.vertx.model.MerkleStateInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MetadataInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MetadataPage;
import io.nem.symbol.sdk.openapi.vertx.model.MetadataTypeEnum;
import io.nem.symbol.sdk.openapi.vertx.model.ModelError;
import io.nem.symbol.sdk.openapi.vertx.model.Order;

import java.util.*;

import rx.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2021-01-14T22:22:33.231Z[UTC]")
public class MetadataRoutesApi {

	private final io.nem.symbol.sdk.openapi.vertx.api.MetadataRoutesApi delegate;

	public MetadataRoutesApi(io.nem.symbol.sdk.openapi.vertx.api.MetadataRoutesApi delegate) {
	    this.delegate = delegate;
    }

	public io.nem.symbol.sdk.openapi.vertx.api.MetadataRoutesApi getDelegate() {
	    return delegate;
	}

    /**
     * Get metadata information
     * Gets the metadata for a given composite hash.
     * @param compositeHash Filter by composite hash. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getMetadata(String compositeHash, Handler<AsyncResult<MetadataInfoDTO>> resultHandler) {
        delegate.getMetadata(compositeHash, resultHandler);
    }

    /**
     * Get metadata information
     * Gets the metadata for a given composite hash.
     * @param compositeHash Filter by composite hash. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MetadataInfoDTO> rxGetMetadata(String compositeHash) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getMetadata(compositeHash, fut);
        }));
    }
    /**
     * Get metadata merkle information
     * Gets the metadata merkle for a given composite hash.
     * @param compositeHash Filter by composite hash. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getMetadataMerkle(String compositeHash, Handler<AsyncResult<MerkleStateInfoDTO>> resultHandler) {
        delegate.getMetadataMerkle(compositeHash, resultHandler);
    }

    /**
     * Get metadata merkle information
     * Gets the metadata merkle for a given composite hash.
     * @param compositeHash Filter by composite hash. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MerkleStateInfoDTO> rxGetMetadataMerkle(String compositeHash) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getMetadataMerkle(compositeHash, fut);
        }));
    }
    /**
     * Search metadata entries
     * Returns an array of metadata.
     * @param sourceAddress Filter by address sending the metadata entry. (optional)
     * @param targetAddress Filter by target address. (optional)
     * @param scopedMetadataKey Filter by metadata key. (optional)
     * @param targetId Filter by namespace or mosaic id. (optional)
     * @param metadataType Filter by metadata type. (optional)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @param resultHandler Asynchronous result handler
     */
    public void searchMetadataEntries(String sourceAddress, String targetAddress, String scopedMetadataKey, String targetId, MetadataTypeEnum metadataType, Integer pageSize, Integer pageNumber, String offset, Order order, Handler<AsyncResult<MetadataPage>> resultHandler) {
        delegate.searchMetadataEntries(sourceAddress, targetAddress, scopedMetadataKey, targetId, metadataType, pageSize, pageNumber, offset, order, resultHandler);
    }

    /**
     * Search metadata entries
     * Returns an array of metadata.
     * @param sourceAddress Filter by address sending the metadata entry. (optional)
     * @param targetAddress Filter by target address. (optional)
     * @param scopedMetadataKey Filter by metadata key. (optional)
     * @param targetId Filter by namespace or mosaic id. (optional)
     * @param metadataType Filter by metadata type. (optional)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MetadataPage> rxSearchMetadataEntries(String sourceAddress, String targetAddress, String scopedMetadataKey, String targetId, MetadataTypeEnum metadataType, Integer pageSize, Integer pageNumber, String offset, Order order) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.searchMetadataEntries(sourceAddress, targetAddress, scopedMetadataKey, targetId, metadataType, pageSize, pageNumber, offset, order, fut);
        }));
    }

    public static MetadataRoutesApi newInstance(io.nem.symbol.sdk.openapi.vertx.api.MetadataRoutesApi arg) {
        return arg != null ? new MetadataRoutesApi(arg) : null;
    }
}
