/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.vertx.api;

import com.fasterxml.jackson.core.type.TypeReference;
import io.nem.symbol.sdk.openapi.vertx.api.HashLockRoutesApi;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiException;
import io.nem.symbol.sdk.openapi.vertx.invoker.Configuration;
import io.nem.symbol.sdk.openapi.vertx.invoker.Pair;
import io.nem.symbol.sdk.openapi.vertx.model.HashLockInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.HashLockPage;
import io.nem.symbol.sdk.openapi.vertx.model.MerkleStateInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.Order;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import java.util.ArrayList;
import java.util.HashMap;

public class HashLockRoutesApiImpl
implements HashLockRoutesApi {
    private ApiClient apiClient;

    public HashLockRoutesApiImpl() {
        this(null);
    }

    public HashLockRoutesApiImpl(ApiClient apiClient) {
        this.apiClient = apiClient != null ? apiClient : Configuration.getDefaultApiClient();
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public void getHashLock(String hash, Handler<AsyncResult<HashLockInfoDTO>> resultHandler) {
        Object localVarBody = null;
        if (hash == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'hash' when calling getHashLock"));
            return;
        }
        String localVarPath = "/lock/hash/{hash}".replaceAll("\\{hash\\}", hash.toString());
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{};
        String[] localVarAuthNames = new String[]{};
        TypeReference<HashLockInfoDTO> localVarReturnType = new TypeReference<HashLockInfoDTO>(){};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }

    @Override
    public void getHashLockMerkle(String hash, Handler<AsyncResult<MerkleStateInfoDTO>> resultHandler) {
        Object localVarBody = null;
        if (hash == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'hash' when calling getHashLockMerkle"));
            return;
        }
        String localVarPath = "/lock/hash/{hash}/merkle".replaceAll("\\{hash\\}", hash.toString());
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{};
        String[] localVarAuthNames = new String[]{};
        TypeReference<MerkleStateInfoDTO> localVarReturnType = new TypeReference<MerkleStateInfoDTO>(){};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }

    @Override
    public void searchHashLock(String address, Integer pageSize, Integer pageNumber, String offset, Order order, Handler<AsyncResult<HashLockPage>> resultHandler) {
        Object localVarBody = null;
        String localVarPath = "/lock/hash";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "address", address));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageNumber", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "order", (Object)order));
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{};
        String[] localVarAuthNames = new String[]{};
        TypeReference<HashLockPage> localVarReturnType = new TypeReference<HashLockPage>(){};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
}

