/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest 2.3.0
 *
 * The version of the OpenAPI document: 0.11.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.symbol.sdk.openapi.vertx.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.nem.symbol.sdk.openapi.vertx.model.NetworkTypeEnum;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionDTO;
import io.nem.symbol.sdk.openapi.vertx.model.TransferTransactionBodyDTO;
import io.nem.symbol.sdk.openapi.vertx.model.UnresolvedMosaic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Transaction to transfer mosaics and a message to another account.
 */
@ApiModel(description = "Transaction to transfer mosaics and a message to another account.")
@JsonPropertyOrder({
  TransferTransactionDTO.JSON_PROPERTY_SIZE,
  TransferTransactionDTO.JSON_PROPERTY_SIGNATURE,
  TransferTransactionDTO.JSON_PROPERTY_SIGNER_PUBLIC_KEY,
  TransferTransactionDTO.JSON_PROPERTY_VERSION,
  TransferTransactionDTO.JSON_PROPERTY_NETWORK,
  TransferTransactionDTO.JSON_PROPERTY_TYPE,
  TransferTransactionDTO.JSON_PROPERTY_MAX_FEE,
  TransferTransactionDTO.JSON_PROPERTY_DEADLINE,
  TransferTransactionDTO.JSON_PROPERTY_RECIPIENT_ADDRESS,
  TransferTransactionDTO.JSON_PROPERTY_MOSAICS,
  TransferTransactionDTO.JSON_PROPERTY_MESSAGE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2021-01-14T16:43:20.330Z[UTC]")
public class TransferTransactionDTO {
  public static final String JSON_PROPERTY_SIZE = "size";
  private Long size;

  public static final String JSON_PROPERTY_SIGNATURE = "signature";
  private String signature;

  public static final String JSON_PROPERTY_SIGNER_PUBLIC_KEY = "signerPublicKey";
  private String signerPublicKey;

  public static final String JSON_PROPERTY_VERSION = "version";
  private Integer version;

  public static final String JSON_PROPERTY_NETWORK = "network";
  private NetworkTypeEnum network;

  public static final String JSON_PROPERTY_TYPE = "type";
  private Integer type;

  public static final String JSON_PROPERTY_MAX_FEE = "maxFee";
  private java.math.BigInteger maxFee = null;

  public static final String JSON_PROPERTY_DEADLINE = "deadline";
  private java.math.BigInteger deadline = null;

  public static final String JSON_PROPERTY_RECIPIENT_ADDRESS = "recipientAddress";
  private String recipientAddress;

  public static final String JSON_PROPERTY_MOSAICS = "mosaics";
  private List<UnresolvedMosaic> mosaics = new ArrayList<>();

  public static final String JSON_PROPERTY_MESSAGE = "message";
  private String message;


  public TransferTransactionDTO size(Long size) {
    
    this.size = size;
    return this;
  }

   /**
   * A number that allows uint 32 values.
   * @return size
  **/
  @ApiModelProperty(example = "2222212828", required = true, value = "A number that allows uint 32 values.")
  @JsonProperty(JSON_PROPERTY_SIZE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Long getSize() {
    return size;
  }


  public void setSize(Long size) {
    this.size = size;
  }


  public TransferTransactionDTO signature(String signature) {
    
    this.signature = signature;
    return this;
  }

   /**
   * Entity&#39;s signature generated by the signer.
   * @return signature
  **/
  @ApiModelProperty(example = "4B408BBEDF25F2AC8E0E44A6E51E3CCBA03885902055F75EB9FF50433532CA44BF9175FDA7502EEE2FC1617126E453A2BD692BAFDAAF06BC8EDEBA7961B3730D", required = true, value = "Entity's signature generated by the signer.")
  @JsonProperty(JSON_PROPERTY_SIGNATURE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSignature() {
    return signature;
  }


  public void setSignature(String signature) {
    this.signature = signature;
  }


  public TransferTransactionDTO signerPublicKey(String signerPublicKey) {
    
    this.signerPublicKey = signerPublicKey;
    return this;
  }

   /**
   * Public key.
   * @return signerPublicKey
  **/
  @ApiModelProperty(example = "AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required = true, value = "Public key.")
  @JsonProperty(JSON_PROPERTY_SIGNER_PUBLIC_KEY)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSignerPublicKey() {
    return signerPublicKey;
  }


  public void setSignerPublicKey(String signerPublicKey) {
    this.signerPublicKey = signerPublicKey;
  }


  public TransferTransactionDTO version(Integer version) {
    
    this.version = version;
    return this;
  }

   /**
   * Entity version.
   * @return version
  **/
  @ApiModelProperty(required = true, value = "Entity version.")
  @JsonProperty(JSON_PROPERTY_VERSION)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getVersion() {
    return version;
  }


  public void setVersion(Integer version) {
    this.version = version;
  }


  public TransferTransactionDTO network(NetworkTypeEnum network) {
    
    this.network = network;
    return this;
  }

   /**
   * Get network
   * @return network
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_NETWORK)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public NetworkTypeEnum getNetwork() {
    return network;
  }


  public void setNetwork(NetworkTypeEnum network) {
    this.network = network;
  }


  public TransferTransactionDTO type(Integer type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TYPE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getType() {
    return type;
  }


  public void setType(Integer type) {
    this.type = type;
  }


  public TransferTransactionDTO maxFee(java.math.BigInteger maxFee) {
    
    this.maxFee = maxFee;
    return this;
  }

   /**
   * Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).
   * @return maxFee
  **/
  @ApiModelProperty(example = "123456", required = true, value = "Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
  @JsonProperty(JSON_PROPERTY_MAX_FEE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getMaxFee() {
    return maxFee;
  }


  public void setMaxFee(java.math.BigInteger maxFee) {
    this.maxFee = maxFee;
  }


  public TransferTransactionDTO deadline(java.math.BigInteger deadline) {
    
    this.deadline = deadline;
    return this;
  }

   /**
   * Duration expressed in number of blocks.
   * @return deadline
  **/
  @ApiModelProperty(example = "200", required = true, value = "Duration expressed in number of blocks.")
  @JsonProperty(JSON_PROPERTY_DEADLINE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getDeadline() {
    return deadline;
  }


  public void setDeadline(java.math.BigInteger deadline) {
    this.deadline = deadline;
  }


  public TransferTransactionDTO recipientAddress(String recipientAddress) {
    
    this.recipientAddress = recipientAddress;
    return this;
  }

   /**
   * Address expressed in hexadecimal base. If the bit 0 of byte 0 is not set (like in 0x90), then it is a regular address. Else (e.g. 0x91) it represents a namespace id which starts at byte 1. 
   * @return recipientAddress
  **/
  @ApiModelProperty(example = "90340017CFF3DD2BCF3B2670CDCB9FC8C75754E2325F297C", required = true, value = "Address expressed in hexadecimal base. If the bit 0 of byte 0 is not set (like in 0x90), then it is a regular address. Else (e.g. 0x91) it represents a namespace id which starts at byte 1. ")
  @JsonProperty(JSON_PROPERTY_RECIPIENT_ADDRESS)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRecipientAddress() {
    return recipientAddress;
  }


  public void setRecipientAddress(String recipientAddress) {
    this.recipientAddress = recipientAddress;
  }


  public TransferTransactionDTO mosaics(List<UnresolvedMosaic> mosaics) {
    
    this.mosaics = mosaics;
    return this;
  }

  public TransferTransactionDTO addMosaicsItem(UnresolvedMosaic mosaicsItem) {
    this.mosaics.add(mosaicsItem);
    return this;
  }

   /**
   * Array of mosaics sent to the recipient. 
   * @return mosaics
  **/
  @ApiModelProperty(required = true, value = "Array of mosaics sent to the recipient. ")
  @JsonProperty(JSON_PROPERTY_MOSAICS)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<UnresolvedMosaic> getMosaics() {
    return mosaics;
  }


  public void setMosaics(List<UnresolvedMosaic> mosaics) {
    this.mosaics = mosaics;
  }


  public TransferTransactionDTO message(String message) {
    
    this.message = message;
    return this;
  }

   /**
   * Transfer transaction message
   * @return message
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Transfer transaction message")
  @JsonProperty(JSON_PROPERTY_MESSAGE)
  // @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMessage() {
    return message;
  }


  public void setMessage(String message) {
    this.message = message;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TransferTransactionDTO transferTransactionDTO = (TransferTransactionDTO) o;
    return Objects.equals(this.size, transferTransactionDTO.size) &&
        Objects.equals(this.signature, transferTransactionDTO.signature) &&
        Objects.equals(this.signerPublicKey, transferTransactionDTO.signerPublicKey) &&
        Objects.equals(this.version, transferTransactionDTO.version) &&
        Objects.equals(this.network, transferTransactionDTO.network) &&
        Objects.equals(this.type, transferTransactionDTO.type) &&
        Objects.equals(this.maxFee, transferTransactionDTO.maxFee) &&
        Objects.equals(this.deadline, transferTransactionDTO.deadline) &&
        Objects.equals(this.recipientAddress, transferTransactionDTO.recipientAddress) &&
        Objects.equals(this.mosaics, transferTransactionDTO.mosaics) &&
        Objects.equals(this.message, transferTransactionDTO.message);
  }

  @Override
  public int hashCode() {
    return Objects.hash(size, signature, signerPublicKey, version, network, type, maxFee, deadline, recipientAddress, mosaics, message);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TransferTransactionDTO {\n");
    sb.append("    size: ").append(toIndentedString(size)).append("\n");
    sb.append("    signature: ").append(toIndentedString(signature)).append("\n");
    sb.append("    signerPublicKey: ").append(toIndentedString(signerPublicKey)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    network: ").append(toIndentedString(network)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    maxFee: ").append(toIndentedString(maxFee)).append("\n");
    sb.append("    deadline: ").append(toIndentedString(deadline)).append("\n");
    sb.append("    recipientAddress: ").append(toIndentedString(recipientAddress)).append("\n");
    sb.append("    mosaics: ").append(toIndentedString(mosaics)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

