/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest 2.3.0
 *
 * The version of the OpenAPI document: 0.11.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.symbol.sdk.openapi.vertx.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * MultisigDTO
 */
@JsonPropertyOrder({
  MultisigDTO.JSON_PROPERTY_VERSION,
  MultisigDTO.JSON_PROPERTY_ACCOUNT_ADDRESS,
  MultisigDTO.JSON_PROPERTY_MIN_APPROVAL,
  MultisigDTO.JSON_PROPERTY_MIN_REMOVAL,
  MultisigDTO.JSON_PROPERTY_COSIGNATORY_ADDRESSES,
  MultisigDTO.JSON_PROPERTY_MULTISIG_ADDRESSES
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2021-01-14T16:43:20.330Z[UTC]")
public class MultisigDTO {
  public static final String JSON_PROPERTY_VERSION = "version";
  private Integer version;

  public static final String JSON_PROPERTY_ACCOUNT_ADDRESS = "accountAddress";
  private String accountAddress;

  public static final String JSON_PROPERTY_MIN_APPROVAL = "minApproval";
  private Long minApproval;

  public static final String JSON_PROPERTY_MIN_REMOVAL = "minRemoval";
  private Long minRemoval;

  public static final String JSON_PROPERTY_COSIGNATORY_ADDRESSES = "cosignatoryAddresses";
  private List<String> cosignatoryAddresses = new ArrayList<>();

  public static final String JSON_PROPERTY_MULTISIG_ADDRESSES = "multisigAddresses";
  private List<String> multisigAddresses = new ArrayList<>();


  public MultisigDTO version(Integer version) {
    
    this.version = version;
    return this;
  }

   /**
   * The version of the state
   * @return version
  **/
  @ApiModelProperty(example = "1", required = true, value = "The version of the state")
  @JsonProperty(JSON_PROPERTY_VERSION)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getVersion() {
    return version;
  }


  public void setVersion(Integer version) {
    this.version = version;
  }


  public MultisigDTO accountAddress(String accountAddress) {
    
    this.accountAddress = accountAddress;
    return this;
  }

   /**
   * Address expressed in hexadecimal base.
   * @return accountAddress
  **/
  @ApiModelProperty(example = "9081FCCB41F8C8409A9B99E485E0E28D23BD6304EF7215E0", required = true, value = "Address expressed in hexadecimal base.")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_ADDRESS)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAccountAddress() {
    return accountAddress;
  }


  public void setAccountAddress(String accountAddress) {
    this.accountAddress = accountAddress;
  }


  public MultisigDTO minApproval(Long minApproval) {
    
    this.minApproval = minApproval;
    return this;
  }

   /**
   * A number that allows uint 32 values.
   * @return minApproval
  **/
  @ApiModelProperty(example = "2222212828", required = true, value = "A number that allows uint 32 values.")
  @JsonProperty(JSON_PROPERTY_MIN_APPROVAL)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Long getMinApproval() {
    return minApproval;
  }


  public void setMinApproval(Long minApproval) {
    this.minApproval = minApproval;
  }


  public MultisigDTO minRemoval(Long minRemoval) {
    
    this.minRemoval = minRemoval;
    return this;
  }

   /**
   * A number that allows uint 32 values.
   * @return minRemoval
  **/
  @ApiModelProperty(example = "2222212828", required = true, value = "A number that allows uint 32 values.")
  @JsonProperty(JSON_PROPERTY_MIN_REMOVAL)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Long getMinRemoval() {
    return minRemoval;
  }


  public void setMinRemoval(Long minRemoval) {
    this.minRemoval = minRemoval;
  }


  public MultisigDTO cosignatoryAddresses(List<String> cosignatoryAddresses) {
    
    this.cosignatoryAddresses = cosignatoryAddresses;
    return this;
  }

  public MultisigDTO addCosignatoryAddressesItem(String cosignatoryAddressesItem) {
    this.cosignatoryAddresses.add(cosignatoryAddressesItem);
    return this;
  }

   /**
   * Addresses of the cosignatory accounts.
   * @return cosignatoryAddresses
  **/
  @ApiModelProperty(required = true, value = "Addresses of the cosignatory accounts.")
  @JsonProperty(JSON_PROPERTY_COSIGNATORY_ADDRESSES)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getCosignatoryAddresses() {
    return cosignatoryAddresses;
  }


  public void setCosignatoryAddresses(List<String> cosignatoryAddresses) {
    this.cosignatoryAddresses = cosignatoryAddresses;
  }


  public MultisigDTO multisigAddresses(List<String> multisigAddresses) {
    
    this.multisigAddresses = multisigAddresses;
    return this;
  }

  public MultisigDTO addMultisigAddressesItem(String multisigAddressesItem) {
    this.multisigAddresses.add(multisigAddressesItem);
    return this;
  }

   /**
   * Multisig accounts where the account is cosignatory.
   * @return multisigAddresses
  **/
  @ApiModelProperty(required = true, value = "Multisig accounts where the account is cosignatory.")
  @JsonProperty(JSON_PROPERTY_MULTISIG_ADDRESSES)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getMultisigAddresses() {
    return multisigAddresses;
  }


  public void setMultisigAddresses(List<String> multisigAddresses) {
    this.multisigAddresses = multisigAddresses;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MultisigDTO multisigDTO = (MultisigDTO) o;
    return Objects.equals(this.version, multisigDTO.version) &&
        Objects.equals(this.accountAddress, multisigDTO.accountAddress) &&
        Objects.equals(this.minApproval, multisigDTO.minApproval) &&
        Objects.equals(this.minRemoval, multisigDTO.minRemoval) &&
        Objects.equals(this.cosignatoryAddresses, multisigDTO.cosignatoryAddresses) &&
        Objects.equals(this.multisigAddresses, multisigDTO.multisigAddresses);
  }

  @Override
  public int hashCode() {
    return Objects.hash(version, accountAddress, minApproval, minRemoval, cosignatoryAddresses, multisigAddresses);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MultisigDTO {\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    accountAddress: ").append(toIndentedString(accountAddress)).append("\n");
    sb.append("    minApproval: ").append(toIndentedString(minApproval)).append("\n");
    sb.append("    minRemoval: ").append(toIndentedString(minRemoval)).append("\n");
    sb.append("    cosignatoryAddresses: ").append(toIndentedString(cosignatoryAddresses)).append("\n");
    sb.append("    multisigAddresses: ").append(toIndentedString(multisigAddresses)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

