/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest 2.3.0
 *
 * The version of the OpenAPI document: 0.11.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.symbol.sdk.openapi.vertx.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicDefinitionTransactionBodyDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NetworkTypeEnum;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Transaction to create a new mosaic.
 */
@ApiModel(description = "Transaction to create a new mosaic.")
@JsonPropertyOrder({
  MosaicDefinitionTransactionDTO.JSON_PROPERTY_SIZE,
  MosaicDefinitionTransactionDTO.JSON_PROPERTY_SIGNATURE,
  MosaicDefinitionTransactionDTO.JSON_PROPERTY_SIGNER_PUBLIC_KEY,
  MosaicDefinitionTransactionDTO.JSON_PROPERTY_VERSION,
  MosaicDefinitionTransactionDTO.JSON_PROPERTY_NETWORK,
  MosaicDefinitionTransactionDTO.JSON_PROPERTY_TYPE,
  MosaicDefinitionTransactionDTO.JSON_PROPERTY_MAX_FEE,
  MosaicDefinitionTransactionDTO.JSON_PROPERTY_DEADLINE,
  MosaicDefinitionTransactionDTO.JSON_PROPERTY_ID,
  MosaicDefinitionTransactionDTO.JSON_PROPERTY_DURATION,
  MosaicDefinitionTransactionDTO.JSON_PROPERTY_NONCE,
  MosaicDefinitionTransactionDTO.JSON_PROPERTY_FLAGS,
  MosaicDefinitionTransactionDTO.JSON_PROPERTY_DIVISIBILITY
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2021-01-14T16:43:20.330Z[UTC]")
public class MosaicDefinitionTransactionDTO {
  public static final String JSON_PROPERTY_SIZE = "size";
  private Long size;

  public static final String JSON_PROPERTY_SIGNATURE = "signature";
  private String signature;

  public static final String JSON_PROPERTY_SIGNER_PUBLIC_KEY = "signerPublicKey";
  private String signerPublicKey;

  public static final String JSON_PROPERTY_VERSION = "version";
  private Integer version;

  public static final String JSON_PROPERTY_NETWORK = "network";
  private NetworkTypeEnum network;

  public static final String JSON_PROPERTY_TYPE = "type";
  private Integer type;

  public static final String JSON_PROPERTY_MAX_FEE = "maxFee";
  private java.math.BigInteger maxFee = null;

  public static final String JSON_PROPERTY_DEADLINE = "deadline";
  private java.math.BigInteger deadline = null;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_DURATION = "duration";
  private java.math.BigInteger duration = null;

  public static final String JSON_PROPERTY_NONCE = "nonce";
  private Long nonce;

  public static final String JSON_PROPERTY_FLAGS = "flags";
  private Integer flags;

  public static final String JSON_PROPERTY_DIVISIBILITY = "divisibility";
  private Integer divisibility;


  public MosaicDefinitionTransactionDTO size(Long size) {
    
    this.size = size;
    return this;
  }

   /**
   * A number that allows uint 32 values.
   * @return size
  **/
  @ApiModelProperty(example = "2222212828", required = true, value = "A number that allows uint 32 values.")
  @JsonProperty(JSON_PROPERTY_SIZE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Long getSize() {
    return size;
  }


  public void setSize(Long size) {
    this.size = size;
  }


  public MosaicDefinitionTransactionDTO signature(String signature) {
    
    this.signature = signature;
    return this;
  }

   /**
   * Entity&#39;s signature generated by the signer.
   * @return signature
  **/
  @ApiModelProperty(example = "4B408BBEDF25F2AC8E0E44A6E51E3CCBA03885902055F75EB9FF50433532CA44BF9175FDA7502EEE2FC1617126E453A2BD692BAFDAAF06BC8EDEBA7961B3730D", required = true, value = "Entity's signature generated by the signer.")
  @JsonProperty(JSON_PROPERTY_SIGNATURE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSignature() {
    return signature;
  }


  public void setSignature(String signature) {
    this.signature = signature;
  }


  public MosaicDefinitionTransactionDTO signerPublicKey(String signerPublicKey) {
    
    this.signerPublicKey = signerPublicKey;
    return this;
  }

   /**
   * Public key.
   * @return signerPublicKey
  **/
  @ApiModelProperty(example = "AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required = true, value = "Public key.")
  @JsonProperty(JSON_PROPERTY_SIGNER_PUBLIC_KEY)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSignerPublicKey() {
    return signerPublicKey;
  }


  public void setSignerPublicKey(String signerPublicKey) {
    this.signerPublicKey = signerPublicKey;
  }


  public MosaicDefinitionTransactionDTO version(Integer version) {
    
    this.version = version;
    return this;
  }

   /**
   * Entity version.
   * @return version
  **/
  @ApiModelProperty(required = true, value = "Entity version.")
  @JsonProperty(JSON_PROPERTY_VERSION)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getVersion() {
    return version;
  }


  public void setVersion(Integer version) {
    this.version = version;
  }


  public MosaicDefinitionTransactionDTO network(NetworkTypeEnum network) {
    
    this.network = network;
    return this;
  }

   /**
   * Get network
   * @return network
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_NETWORK)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public NetworkTypeEnum getNetwork() {
    return network;
  }


  public void setNetwork(NetworkTypeEnum network) {
    this.network = network;
  }


  public MosaicDefinitionTransactionDTO type(Integer type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TYPE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getType() {
    return type;
  }


  public void setType(Integer type) {
    this.type = type;
  }


  public MosaicDefinitionTransactionDTO maxFee(java.math.BigInteger maxFee) {
    
    this.maxFee = maxFee;
    return this;
  }

   /**
   * Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).
   * @return maxFee
  **/
  @ApiModelProperty(example = "123456", required = true, value = "Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
  @JsonProperty(JSON_PROPERTY_MAX_FEE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getMaxFee() {
    return maxFee;
  }


  public void setMaxFee(java.math.BigInteger maxFee) {
    this.maxFee = maxFee;
  }


  public MosaicDefinitionTransactionDTO deadline(java.math.BigInteger deadline) {
    
    this.deadline = deadline;
    return this;
  }

   /**
   * Duration expressed in number of blocks.
   * @return deadline
  **/
  @ApiModelProperty(example = "200", required = true, value = "Duration expressed in number of blocks.")
  @JsonProperty(JSON_PROPERTY_DEADLINE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getDeadline() {
    return deadline;
  }


  public void setDeadline(java.math.BigInteger deadline) {
    this.deadline = deadline;
  }


  public MosaicDefinitionTransactionDTO id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Mosaic identifier.
   * @return id
  **/
  @ApiModelProperty(example = "0DC67FBE1CAD29E3", required = true, value = "Mosaic identifier.")
  @JsonProperty(JSON_PROPERTY_ID)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getId() {
    return id;
  }


  public void setId(String id) {
    this.id = id;
  }


  public MosaicDefinitionTransactionDTO duration(java.math.BigInteger duration) {
    
    this.duration = duration;
    return this;
  }

   /**
   * Duration expressed in number of blocks.
   * @return duration
  **/
  @ApiModelProperty(example = "200", required = true, value = "Duration expressed in number of blocks.")
  @JsonProperty(JSON_PROPERTY_DURATION)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getDuration() {
    return duration;
  }


  public void setDuration(java.math.BigInteger duration) {
    this.duration = duration;
  }


  public MosaicDefinitionTransactionDTO nonce(Long nonce) {
    
    this.nonce = nonce;
    return this;
  }

   /**
   * A number that allows uint 32 values.
   * @return nonce
  **/
  @ApiModelProperty(example = "2222212828", required = true, value = "A number that allows uint 32 values.")
  @JsonProperty(JSON_PROPERTY_NONCE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Long getNonce() {
    return nonce;
  }


  public void setNonce(Long nonce) {
    this.nonce = nonce;
  }


  public MosaicDefinitionTransactionDTO flags(Integer flags) {
    
    this.flags = flags;
    return this;
  }

   /**
   * - 0x00 (none) - No flags present. - 0x01 (supplyMutable) - Mosaic supports supply changes even when mosaic owner owns partial supply. - 0x02 (transferable) - Mosaic supports transfers between arbitrary accounts. When not set, mosaic can only be transferred to and from mosaic owner. - 0x04 (restrictable) - Mosaic supports custom restrictions configured by mosaic owner. 
   * @return flags
  **/
  @ApiModelProperty(required = true, value = "- 0x00 (none) - No flags present. - 0x01 (supplyMutable) - Mosaic supports supply changes even when mosaic owner owns partial supply. - 0x02 (transferable) - Mosaic supports transfers between arbitrary accounts. When not set, mosaic can only be transferred to and from mosaic owner. - 0x04 (restrictable) - Mosaic supports custom restrictions configured by mosaic owner. ")
  @JsonProperty(JSON_PROPERTY_FLAGS)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getFlags() {
    return flags;
  }


  public void setFlags(Integer flags) {
    this.flags = flags;
  }


  public MosaicDefinitionTransactionDTO divisibility(Integer divisibility) {
    
    this.divisibility = divisibility;
    return this;
  }

   /**
   * Determines up to what decimal place the mosaic can be divided. Divisibility of 3 means that a mosaic can be divided into smallest parts of 0.001 mosaics. The divisibility must be in the range of 0 and 6. 
   * @return divisibility
  **/
  @ApiModelProperty(required = true, value = "Determines up to what decimal place the mosaic can be divided. Divisibility of 3 means that a mosaic can be divided into smallest parts of 0.001 mosaics. The divisibility must be in the range of 0 and 6. ")
  @JsonProperty(JSON_PROPERTY_DIVISIBILITY)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getDivisibility() {
    return divisibility;
  }


  public void setDivisibility(Integer divisibility) {
    this.divisibility = divisibility;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MosaicDefinitionTransactionDTO mosaicDefinitionTransactionDTO = (MosaicDefinitionTransactionDTO) o;
    return Objects.equals(this.size, mosaicDefinitionTransactionDTO.size) &&
        Objects.equals(this.signature, mosaicDefinitionTransactionDTO.signature) &&
        Objects.equals(this.signerPublicKey, mosaicDefinitionTransactionDTO.signerPublicKey) &&
        Objects.equals(this.version, mosaicDefinitionTransactionDTO.version) &&
        Objects.equals(this.network, mosaicDefinitionTransactionDTO.network) &&
        Objects.equals(this.type, mosaicDefinitionTransactionDTO.type) &&
        Objects.equals(this.maxFee, mosaicDefinitionTransactionDTO.maxFee) &&
        Objects.equals(this.deadline, mosaicDefinitionTransactionDTO.deadline) &&
        Objects.equals(this.id, mosaicDefinitionTransactionDTO.id) &&
        Objects.equals(this.duration, mosaicDefinitionTransactionDTO.duration) &&
        Objects.equals(this.nonce, mosaicDefinitionTransactionDTO.nonce) &&
        Objects.equals(this.flags, mosaicDefinitionTransactionDTO.flags) &&
        Objects.equals(this.divisibility, mosaicDefinitionTransactionDTO.divisibility);
  }

  @Override
  public int hashCode() {
    return Objects.hash(size, signature, signerPublicKey, version, network, type, maxFee, deadline, id, duration, nonce, flags, divisibility);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MosaicDefinitionTransactionDTO {\n");
    sb.append("    size: ").append(toIndentedString(size)).append("\n");
    sb.append("    signature: ").append(toIndentedString(signature)).append("\n");
    sb.append("    signerPublicKey: ").append(toIndentedString(signerPublicKey)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    network: ").append(toIndentedString(network)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    maxFee: ").append(toIndentedString(maxFee)).append("\n");
    sb.append("    deadline: ").append(toIndentedString(deadline)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    duration: ").append(toIndentedString(duration)).append("\n");
    sb.append("    nonce: ").append(toIndentedString(nonce)).append("\n");
    sb.append("    flags: ").append(toIndentedString(flags)).append("\n");
    sb.append("    divisibility: ").append(toIndentedString(divisibility)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

