package io.nem.symbol.sdk.openapi.vertx.api.rxjava;

import io.nem.symbol.sdk.openapi.vertx.model.ModelError;
import io.nem.symbol.sdk.openapi.vertx.model.Order;
import io.nem.symbol.sdk.openapi.vertx.model.ReceiptTypeEnum;
import io.nem.symbol.sdk.openapi.vertx.model.ResolutionStatementPage;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionStatementPage;

import java.util.*;

import rx.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2021-01-14T16:43:20.330Z[UTC]")
public class ReceiptRoutesApi {

	private final io.nem.symbol.sdk.openapi.vertx.api.ReceiptRoutesApi delegate;

	public ReceiptRoutesApi(io.nem.symbol.sdk.openapi.vertx.api.ReceiptRoutesApi delegate) {
	    this.delegate = delegate;
    }

	public io.nem.symbol.sdk.openapi.vertx.api.ReceiptRoutesApi getDelegate() {
	    return delegate;
	}

    /**
     * Get receipts address resolution statements
     * Gets an array of address resolution statements.
     * @param height Filter by block height. (optional, default to null)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @param resultHandler Asynchronous result handler
     */
    public void searchAddressResolutionStatements(java.math.BigInteger height, Integer pageSize, Integer pageNumber, String offset, Order order, Handler<AsyncResult<ResolutionStatementPage>> resultHandler) {
        delegate.searchAddressResolutionStatements(height, pageSize, pageNumber, offset, order, resultHandler);
    }

    /**
     * Get receipts address resolution statements
     * Gets an array of address resolution statements.
     * @param height Filter by block height. (optional, default to null)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<ResolutionStatementPage> rxSearchAddressResolutionStatements(java.math.BigInteger height, Integer pageSize, Integer pageNumber, String offset, Order order) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.searchAddressResolutionStatements(height, pageSize, pageNumber, offset, order, fut);
        }));
    }
    /**
     * Get receipts mosaic resolution statements
     * Gets an array of mosaic resolution statements.
     * @param height Filter by block height. (optional, default to null)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @param resultHandler Asynchronous result handler
     */
    public void searchMosaicResolutionStatements(java.math.BigInteger height, Integer pageSize, Integer pageNumber, String offset, Order order, Handler<AsyncResult<ResolutionStatementPage>> resultHandler) {
        delegate.searchMosaicResolutionStatements(height, pageSize, pageNumber, offset, order, resultHandler);
    }

    /**
     * Get receipts mosaic resolution statements
     * Gets an array of mosaic resolution statements.
     * @param height Filter by block height. (optional, default to null)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<ResolutionStatementPage> rxSearchMosaicResolutionStatements(java.math.BigInteger height, Integer pageSize, Integer pageNumber, String offset, Order order) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.searchMosaicResolutionStatements(height, pageSize, pageNumber, offset, order, fut);
        }));
    }
    /**
     * Search transaction statements
     * Gets an array of transaction statements.
     * @param height Filter by block height. (optional, default to null)
     * @param receiptType Filter by receipt type. To filter by multiple receipt types, add more filter query params like: &#x60;&#x60;receiptType&#x3D;8515&amp;receiptType&#x3D;20803&#x60;&#x60;.  (optional, default to new ArrayList&lt;&gt;())
     * @param recipientAddress Filter by address of the account receiving the transaction. (optional)
     * @param senderAddress Filter by address sending mosaics. (optional)
     * @param targetAddress Filter by target address. (optional)
     * @param artifactId Mosaic or namespace identifier (optional)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @param resultHandler Asynchronous result handler
     */
    public void searchReceipts(java.math.BigInteger height, List<ReceiptTypeEnum> receiptType, String recipientAddress, String senderAddress, String targetAddress, String artifactId, Integer pageSize, Integer pageNumber, String offset, Order order, Handler<AsyncResult<TransactionStatementPage>> resultHandler) {
        delegate.searchReceipts(height, receiptType, recipientAddress, senderAddress, targetAddress, artifactId, pageSize, pageNumber, offset, order, resultHandler);
    }

    /**
     * Search transaction statements
     * Gets an array of transaction statements.
     * @param height Filter by block height. (optional, default to null)
     * @param receiptType Filter by receipt type. To filter by multiple receipt types, add more filter query params like: &#x60;&#x60;receiptType&#x3D;8515&amp;receiptType&#x3D;20803&#x60;&#x60;.  (optional, default to new ArrayList&lt;&gt;())
     * @param recipientAddress Filter by address of the account receiving the transaction. (optional)
     * @param senderAddress Filter by address sending mosaics. (optional)
     * @param targetAddress Filter by target address. (optional)
     * @param artifactId Mosaic or namespace identifier (optional)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<TransactionStatementPage> rxSearchReceipts(java.math.BigInteger height, List<ReceiptTypeEnum> receiptType, String recipientAddress, String senderAddress, String targetAddress, String artifactId, Integer pageSize, Integer pageNumber, String offset, Order order) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.searchReceipts(height, receiptType, recipientAddress, senderAddress, targetAddress, artifactId, pageSize, pageNumber, offset, order, fut);
        }));
    }

    public static ReceiptRoutesApi newInstance(io.nem.symbol.sdk.openapi.vertx.api.ReceiptRoutesApi arg) {
        return arg != null ? new ReceiptRoutesApi(arg) : null;
    }
}
