package io.nem.symbol.sdk.openapi.vertx.api;

import io.nem.symbol.sdk.openapi.vertx.model.ModelError;
import io.nem.symbol.sdk.openapi.vertx.model.Order;
import io.nem.symbol.sdk.openapi.vertx.model.ReceiptTypeEnum;
import io.nem.symbol.sdk.openapi.vertx.model.ResolutionStatementPage;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionStatementPage;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonObject;

import com.fasterxml.jackson.core.type.TypeReference;

import java.util.*;

import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiException;
import io.nem.symbol.sdk.openapi.vertx.invoker.Configuration;
import io.nem.symbol.sdk.openapi.vertx.invoker.Pair;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2021-01-14T16:43:20.330Z[UTC]")
public class ReceiptRoutesApiImpl implements ReceiptRoutesApi {

    private ApiClient apiClient;

    public ReceiptRoutesApiImpl() {
        this(null);
    }

    public ReceiptRoutesApiImpl(ApiClient apiClient) {
        this.apiClient = apiClient != null ? apiClient : Configuration.getDefaultApiClient();
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Get receipts address resolution statements
     * Gets an array of address resolution statements.
     * @param height Filter by block height. (optional, default to null)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @param resultHandler Asynchronous result handler
     */
    public void searchAddressResolutionStatements(java.math.BigInteger height, Integer pageSize, Integer pageNumber, String offset, Order order, Handler<AsyncResult<ResolutionStatementPage>> resultHandler) {
        Object localVarBody = null;
        
        // create path and map variables
        String localVarPath = "/statements/resolutions/address";

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "height", height));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageNumber", pageNumber));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "offset", offset));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "order", order));

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<ResolutionStatementPage> localVarReturnType = new TypeReference<ResolutionStatementPage>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get receipts mosaic resolution statements
     * Gets an array of mosaic resolution statements.
     * @param height Filter by block height. (optional, default to null)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @param resultHandler Asynchronous result handler
     */
    public void searchMosaicResolutionStatements(java.math.BigInteger height, Integer pageSize, Integer pageNumber, String offset, Order order, Handler<AsyncResult<ResolutionStatementPage>> resultHandler) {
        Object localVarBody = null;
        
        // create path and map variables
        String localVarPath = "/statements/resolutions/mosaic";

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "height", height));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageNumber", pageNumber));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "offset", offset));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "order", order));

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<ResolutionStatementPage> localVarReturnType = new TypeReference<ResolutionStatementPage>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Search transaction statements
     * Gets an array of transaction statements.
     * @param height Filter by block height. (optional, default to null)
     * @param receiptType Filter by receipt type. To filter by multiple receipt types, add more filter query params like: &#x60;&#x60;receiptType&#x3D;8515&amp;receiptType&#x3D;20803&#x60;&#x60;.  (optional, default to new ArrayList&lt;&gt;())
     * @param recipientAddress Filter by address of the account receiving the transaction. (optional)
     * @param senderAddress Filter by address sending mosaics. (optional)
     * @param targetAddress Filter by target address. (optional)
     * @param artifactId Mosaic or namespace identifier (optional)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @param resultHandler Asynchronous result handler
     */
    public void searchReceipts(java.math.BigInteger height, List<ReceiptTypeEnum> receiptType, String recipientAddress, String senderAddress, String targetAddress, String artifactId, Integer pageSize, Integer pageNumber, String offset, Order order, Handler<AsyncResult<TransactionStatementPage>> resultHandler) {
        Object localVarBody = null;
        
        // create path and map variables
        String localVarPath = "/statements/transaction";

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "height", height));
        localVarQueryParams.addAll(apiClient.parameterToPairs("multi", "receiptType", receiptType));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "recipientAddress", recipientAddress));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "senderAddress", senderAddress));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "targetAddress", targetAddress));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "artifactId", artifactId));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageNumber", pageNumber));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "offset", offset));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "order", order));

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<TransactionStatementPage> localVarReturnType = new TypeReference<TransactionStatementPage>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
}
