package io.nem.symbol.sdk.openapi.vertx.api;

import io.nem.symbol.sdk.openapi.vertx.model.NodeHealthInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NodeInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NodeTimeDTO;
import io.nem.symbol.sdk.openapi.vertx.model.ServerInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.StorageInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.UnlockedAccountDTO;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonObject;

import com.fasterxml.jackson.core.type.TypeReference;

import java.util.*;

import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiException;
import io.nem.symbol.sdk.openapi.vertx.invoker.Configuration;
import io.nem.symbol.sdk.openapi.vertx.invoker.Pair;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2021-01-14T16:43:20.330Z[UTC]")
public class NodeRoutesApiImpl implements NodeRoutesApi {

    private ApiClient apiClient;

    public NodeRoutesApiImpl() {
        this(null);
    }

    public NodeRoutesApiImpl(ApiClient apiClient) {
        this.apiClient = apiClient != null ? apiClient : Configuration.getDefaultApiClient();
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Get the node health information
     * Supplies information regarding the connection and services status.
     * @param resultHandler Asynchronous result handler
     */
    public void getNodeHealth(Handler<AsyncResult<NodeHealthInfoDTO>> resultHandler) {
        Object localVarBody = null;
        
        // create path and map variables
        String localVarPath = "/node/health";

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<NodeHealthInfoDTO> localVarReturnType = new TypeReference<NodeHealthInfoDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get the node information
     * Supplies additional information about the application running on a node.
     * @param resultHandler Asynchronous result handler
     */
    public void getNodeInfo(Handler<AsyncResult<NodeInfoDTO>> resultHandler) {
        Object localVarBody = null;
        
        // create path and map variables
        String localVarPath = "/node/info";

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<NodeInfoDTO> localVarReturnType = new TypeReference<NodeInfoDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get peers information
     * Gets the list of peers visible by the node.
     * @param resultHandler Asynchronous result handler
     */
    public void getNodePeers(Handler<AsyncResult<List<NodeInfoDTO>>> resultHandler) {
        Object localVarBody = null;
        
        // create path and map variables
        String localVarPath = "/node/peers";

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<List<NodeInfoDTO>> localVarReturnType = new TypeReference<List<NodeInfoDTO>>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get the storage information of the node
     * Returns storage information about the node.
     * @param resultHandler Asynchronous result handler
     */
    public void getNodeStorage(Handler<AsyncResult<StorageInfoDTO>> resultHandler) {
        Object localVarBody = null;
        
        // create path and map variables
        String localVarPath = "/node/storage";

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<StorageInfoDTO> localVarReturnType = new TypeReference<StorageInfoDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get the node time
     * Gets the node time at the moment the reply was sent and received.
     * @param resultHandler Asynchronous result handler
     */
    public void getNodeTime(Handler<AsyncResult<NodeTimeDTO>> resultHandler) {
        Object localVarBody = null;
        
        // create path and map variables
        String localVarPath = "/node/time";

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<NodeTimeDTO> localVarReturnType = new TypeReference<NodeTimeDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get the version of the running REST component
     * Returns the version of the running catapult-rest component.
     * @param resultHandler Asynchronous result handler
     */
    public void getServerInfo(Handler<AsyncResult<ServerInfoDTO>> resultHandler) {
        Object localVarBody = null;
        
        // create path and map variables
        String localVarPath = "/node/server";

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<ServerInfoDTO> localVarReturnType = new TypeReference<ServerInfoDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get the unlocked harvesting account public keys.
     * Returns array of unlocked account public keys.
     * @param resultHandler Asynchronous result handler
     */
    public void getUnlockedAccount(Handler<AsyncResult<UnlockedAccountDTO>> resultHandler) {
        Object localVarBody = null;
        
        // create path and map variables
        String localVarPath = "/node/unlockedaccount";

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<UnlockedAccountDTO> localVarReturnType = new TypeReference<UnlockedAccountDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
}
