package io.nem.symbol.sdk.openapi.vertx.api;

import io.nem.symbol.sdk.openapi.vertx.model.AccountIds;
import io.nem.symbol.sdk.openapi.vertx.model.AccountInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.AccountOrderByEnum;
import io.nem.symbol.sdk.openapi.vertx.model.AccountPage;
import io.nem.symbol.sdk.openapi.vertx.model.MerkleStateInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.ModelError;
import io.nem.symbol.sdk.openapi.vertx.model.Order;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;

import java.util.*;

public interface AccountRoutesApi {

    void getAccountInfo(String accountId, Handler<AsyncResult<AccountInfoDTO>> handler);

    void getAccountInfoMerkle(String accountId, Handler<AsyncResult<MerkleStateInfoDTO>> handler);

    void getAccountsInfo(AccountIds accountIds, Handler<AsyncResult<List<AccountInfoDTO>>> handler);

    void searchAccounts(Integer pageSize, Integer pageNumber, String offset, Order order, AccountOrderByEnum orderBy, String mosaicId, Handler<AsyncResult<AccountPage>> handler);

}
