/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.vertx.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The merkle path information clients can use to proof the state of the given entity. ")
@JsonPropertyOrder(value={"raw", "tree"})
public class MerkleStateInfoDTO {
    public static final String JSON_PROPERTY_RAW = "raw";
    private String raw;
    public static final String JSON_PROPERTY_TREE = "tree";
    private List<Object> tree = new ArrayList<Object>();

    public MerkleStateInfoDTO raw(String raw) {
        this.raw = raw;
        return this;
    }

    @ApiModelProperty(example="00008080DA9B4AF63BE985715EA635AF98E3CF3B0A22F9A2BE1C7DD40B79948AA63E36586E5D2E9D0C089C1C64BC0D42A11ADBD1CD6CDB4B7C294062F55113525A64AE3CFF3F04A7F2A487B42EA89323C4408F82415223ACFEC7DFA7924EFC31A70778AB17A00C3EAFF635F01BB3B474F0AF1BE99FBDA85EEFB209CC7BD158D3540DE3A3F2D1", required=true, value="The hex information of the complete merkle tree as returned by server api. More information can be found in chapter 4.3 of the catapult whitepaper. ")
    @JsonProperty(value="raw")
    public String getRaw() {
        return this.raw;
    }

    public void setRaw(String raw) {
        this.raw = raw;
    }

    public MerkleStateInfoDTO tree(List<Object> tree) {
        this.tree = tree;
        return this;
    }

    public MerkleStateInfoDTO addTreeItem(Object treeItem) {
        this.tree.add(treeItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Merkle tree parsed from merkle tree raw.")
    @JsonProperty(value="tree")
    public List<Object> getTree() {
        return this.tree;
    }

    public void setTree(List<Object> tree) {
        this.tree = tree;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MerkleStateInfoDTO merkleStateInfoDTO = (MerkleStateInfoDTO)o;
        return Objects.equals(this.raw, merkleStateInfoDTO.raw) && Objects.equals(this.tree, merkleStateInfoDTO.tree);
    }

    public int hashCode() {
        return Objects.hash(this.raw, this.tree);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MerkleStateInfoDTO {\n");
        sb.append("    raw: ").append(this.toIndentedString(this.raw)).append("\n");
        sb.append("    tree: ").append(this.toIndentedString(this.tree)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

