/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest 2.2.0
 *
 * The version of the OpenAPI document: 0.10.5
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.symbol.sdk.openapi.vertx.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.nem.symbol.sdk.openapi.vertx.model.EmbeddedTransactionDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicAddressRestrictionTransactionBodyDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NetworkTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * EmbeddedMosaicAddressRestrictionTransactionDTO
 */
@JsonPropertyOrder({
  EmbeddedMosaicAddressRestrictionTransactionDTO.JSON_PROPERTY_SIGNER_PUBLIC_KEY,
  EmbeddedMosaicAddressRestrictionTransactionDTO.JSON_PROPERTY_VERSION,
  EmbeddedMosaicAddressRestrictionTransactionDTO.JSON_PROPERTY_NETWORK,
  EmbeddedMosaicAddressRestrictionTransactionDTO.JSON_PROPERTY_TYPE,
  EmbeddedMosaicAddressRestrictionTransactionDTO.JSON_PROPERTY_MOSAIC_ID,
  EmbeddedMosaicAddressRestrictionTransactionDTO.JSON_PROPERTY_RESTRICTION_KEY,
  EmbeddedMosaicAddressRestrictionTransactionDTO.JSON_PROPERTY_PREVIOUS_RESTRICTION_VALUE,
  EmbeddedMosaicAddressRestrictionTransactionDTO.JSON_PROPERTY_NEW_RESTRICTION_VALUE,
  EmbeddedMosaicAddressRestrictionTransactionDTO.JSON_PROPERTY_TARGET_ADDRESS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-12-10T22:06:53.577Z[UTC]")
public class EmbeddedMosaicAddressRestrictionTransactionDTO {
  public static final String JSON_PROPERTY_SIGNER_PUBLIC_KEY = "signerPublicKey";
  private String signerPublicKey;

  public static final String JSON_PROPERTY_VERSION = "version";
  private Integer version;

  public static final String JSON_PROPERTY_NETWORK = "network";
  private NetworkTypeEnum network;

  public static final String JSON_PROPERTY_TYPE = "type";
  private Integer type;

  public static final String JSON_PROPERTY_MOSAIC_ID = "mosaicId";
  private String mosaicId;

  public static final String JSON_PROPERTY_RESTRICTION_KEY = "restrictionKey";
  private String restrictionKey;

  public static final String JSON_PROPERTY_PREVIOUS_RESTRICTION_VALUE = "previousRestrictionValue";
  private java.math.BigInteger previousRestrictionValue = null;

  public static final String JSON_PROPERTY_NEW_RESTRICTION_VALUE = "newRestrictionValue";
  private java.math.BigInteger newRestrictionValue = null;

  public static final String JSON_PROPERTY_TARGET_ADDRESS = "targetAddress";
  private String targetAddress;


  public EmbeddedMosaicAddressRestrictionTransactionDTO signerPublicKey(String signerPublicKey) {
    
    this.signerPublicKey = signerPublicKey;
    return this;
  }

   /**
   * Public key.
   * @return signerPublicKey
  **/
  @ApiModelProperty(example = "AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required = true, value = "Public key.")
  @JsonProperty(JSON_PROPERTY_SIGNER_PUBLIC_KEY)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSignerPublicKey() {
    return signerPublicKey;
  }


  public void setSignerPublicKey(String signerPublicKey) {
    this.signerPublicKey = signerPublicKey;
  }


  public EmbeddedMosaicAddressRestrictionTransactionDTO version(Integer version) {
    
    this.version = version;
    return this;
  }

   /**
   * Entity version.
   * @return version
  **/
  @ApiModelProperty(required = true, value = "Entity version.")
  @JsonProperty(JSON_PROPERTY_VERSION)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getVersion() {
    return version;
  }


  public void setVersion(Integer version) {
    this.version = version;
  }


  public EmbeddedMosaicAddressRestrictionTransactionDTO network(NetworkTypeEnum network) {
    
    this.network = network;
    return this;
  }

   /**
   * Get network
   * @return network
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_NETWORK)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public NetworkTypeEnum getNetwork() {
    return network;
  }


  public void setNetwork(NetworkTypeEnum network) {
    this.network = network;
  }


  public EmbeddedMosaicAddressRestrictionTransactionDTO type(Integer type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TYPE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getType() {
    return type;
  }


  public void setType(Integer type) {
    this.type = type;
  }


  public EmbeddedMosaicAddressRestrictionTransactionDTO mosaicId(String mosaicId) {
    
    this.mosaicId = mosaicId;
    return this;
  }

   /**
   * Mosaic identifier. If the most significant bit of byte 0 is set, a namespaceId (alias) is used instead of the real mosaic identifier. 
   * @return mosaicId
  **/
  @ApiModelProperty(example = "85BBEA6CC462B244", required = true, value = "Mosaic identifier. If the most significant bit of byte 0 is set, a namespaceId (alias) is used instead of the real mosaic identifier. ")
  @JsonProperty(JSON_PROPERTY_MOSAIC_ID)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getMosaicId() {
    return mosaicId;
  }


  public void setMosaicId(String mosaicId) {
    this.mosaicId = mosaicId;
  }


  public EmbeddedMosaicAddressRestrictionTransactionDTO restrictionKey(String restrictionKey) {
    
    this.restrictionKey = restrictionKey;
    return this;
  }

   /**
   * Restriction key.
   * @return restrictionKey
  **/
  @ApiModelProperty(example = "0DC67FBE1CAD29E3", required = true, value = "Restriction key.")
  @JsonProperty(JSON_PROPERTY_RESTRICTION_KEY)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRestrictionKey() {
    return restrictionKey;
  }


  public void setRestrictionKey(String restrictionKey) {
    this.restrictionKey = restrictionKey;
  }


  public EmbeddedMosaicAddressRestrictionTransactionDTO previousRestrictionValue(java.math.BigInteger previousRestrictionValue) {
    
    this.previousRestrictionValue = previousRestrictionValue;
    return this;
  }

   /**
   * Restriction value.
   * @return previousRestrictionValue
  **/
  @ApiModelProperty(example = "1000", required = true, value = "Restriction value.")
  @JsonProperty(JSON_PROPERTY_PREVIOUS_RESTRICTION_VALUE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getPreviousRestrictionValue() {
    return previousRestrictionValue;
  }


  public void setPreviousRestrictionValue(java.math.BigInteger previousRestrictionValue) {
    this.previousRestrictionValue = previousRestrictionValue;
  }


  public EmbeddedMosaicAddressRestrictionTransactionDTO newRestrictionValue(java.math.BigInteger newRestrictionValue) {
    
    this.newRestrictionValue = newRestrictionValue;
    return this;
  }

   /**
   * Restriction value.
   * @return newRestrictionValue
  **/
  @ApiModelProperty(example = "1000", required = true, value = "Restriction value.")
  @JsonProperty(JSON_PROPERTY_NEW_RESTRICTION_VALUE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getNewRestrictionValue() {
    return newRestrictionValue;
  }


  public void setNewRestrictionValue(java.math.BigInteger newRestrictionValue) {
    this.newRestrictionValue = newRestrictionValue;
  }


  public EmbeddedMosaicAddressRestrictionTransactionDTO targetAddress(String targetAddress) {
    
    this.targetAddress = targetAddress;
    return this;
  }

   /**
   * Address expressed in hexadecimal base. If the bit 0 of byte 0 is not set (like in 0x90), then it is a regular address. Else (e.g. 0x91) it represents a namespace id which starts at byte 1. 
   * @return targetAddress
  **/
  @ApiModelProperty(example = "90340017CFF3DD2BCF3B2670CDCB9FC8C75754E2325F297C", required = true, value = "Address expressed in hexadecimal base. If the bit 0 of byte 0 is not set (like in 0x90), then it is a regular address. Else (e.g. 0x91) it represents a namespace id which starts at byte 1. ")
  @JsonProperty(JSON_PROPERTY_TARGET_ADDRESS)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTargetAddress() {
    return targetAddress;
  }


  public void setTargetAddress(String targetAddress) {
    this.targetAddress = targetAddress;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EmbeddedMosaicAddressRestrictionTransactionDTO embeddedMosaicAddressRestrictionTransactionDTO = (EmbeddedMosaicAddressRestrictionTransactionDTO) o;
    return Objects.equals(this.signerPublicKey, embeddedMosaicAddressRestrictionTransactionDTO.signerPublicKey) &&
        Objects.equals(this.version, embeddedMosaicAddressRestrictionTransactionDTO.version) &&
        Objects.equals(this.network, embeddedMosaicAddressRestrictionTransactionDTO.network) &&
        Objects.equals(this.type, embeddedMosaicAddressRestrictionTransactionDTO.type) &&
        Objects.equals(this.mosaicId, embeddedMosaicAddressRestrictionTransactionDTO.mosaicId) &&
        Objects.equals(this.restrictionKey, embeddedMosaicAddressRestrictionTransactionDTO.restrictionKey) &&
        Objects.equals(this.previousRestrictionValue, embeddedMosaicAddressRestrictionTransactionDTO.previousRestrictionValue) &&
        Objects.equals(this.newRestrictionValue, embeddedMosaicAddressRestrictionTransactionDTO.newRestrictionValue) &&
        Objects.equals(this.targetAddress, embeddedMosaicAddressRestrictionTransactionDTO.targetAddress);
  }

  @Override
  public int hashCode() {
    return Objects.hash(signerPublicKey, version, network, type, mosaicId, restrictionKey, previousRestrictionValue, newRestrictionValue, targetAddress);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EmbeddedMosaicAddressRestrictionTransactionDTO {\n");
    sb.append("    signerPublicKey: ").append(toIndentedString(signerPublicKey)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    network: ").append(toIndentedString(network)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    mosaicId: ").append(toIndentedString(mosaicId)).append("\n");
    sb.append("    restrictionKey: ").append(toIndentedString(restrictionKey)).append("\n");
    sb.append("    previousRestrictionValue: ").append(toIndentedString(previousRestrictionValue)).append("\n");
    sb.append("    newRestrictionValue: ").append(toIndentedString(newRestrictionValue)).append("\n");
    sb.append("    targetAddress: ").append(toIndentedString(targetAddress)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

