package io.nem.symbol.sdk.openapi.vertx.api;

import io.nem.symbol.sdk.openapi.vertx.model.BlockInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.BlockOrderByEnum;
import io.nem.symbol.sdk.openapi.vertx.model.BlockPage;
import io.nem.symbol.sdk.openapi.vertx.model.MerkleProofInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.ModelError;
import io.nem.symbol.sdk.openapi.vertx.model.Order;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonObject;

import com.fasterxml.jackson.core.type.TypeReference;

import java.util.*;

import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiException;
import io.nem.symbol.sdk.openapi.vertx.invoker.Configuration;
import io.nem.symbol.sdk.openapi.vertx.invoker.Pair;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-12-10T22:06:53.577Z[UTC]")
public class BlockRoutesApiImpl implements BlockRoutesApi {

    private ApiClient apiClient;

    public BlockRoutesApiImpl() {
        this(null);
    }

    public BlockRoutesApiImpl(ApiClient apiClient) {
        this.apiClient = apiClient != null ? apiClient : Configuration.getDefaultApiClient();
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Get block information
     * Gets a block from the chain that has the given height.
     * @param height Block height. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getBlockByHeight(java.math.BigInteger height, Handler<AsyncResult<BlockInfoDTO>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'height' is set
        if (height == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'height' when calling getBlockByHeight"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/blocks/{height}".replaceAll("\\{" + "height" + "\\}", height.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<BlockInfoDTO> localVarReturnType = new TypeReference<BlockInfoDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get the merkle path for a given a receipt statement hash and block
     * Returns the merkle path for a receipt statement or resolution linked to a block. The merkle path is the minimum number of nodes needed to calculate the merkle root.  Steps to calculate the merkle root: 1. proofHash &#x3D; hash (leaf). 2. Concatenate proofHash with the first unprocessed item from the merklePath list as follows: * a) If item.position &#x3D;&#x3D; left -&gt; proofHash &#x3D; sha_256(item.hash + proofHash). * b) If item.position &#x3D;&#x3D; right -&gt; proofHash &#x3D; sha_256(proofHash+ item.hash). 3. Repeat 2. for every item in the merklePath list. 4. Compare if the calculated proofHash equals the one recorded in the block header (block.receiptsHash) to verify if the statement was linked with the block. 
     * @param height Block height. (required)
     * @param hash Receipt hash. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getMerkleReceipts(java.math.BigInteger height, String hash, Handler<AsyncResult<MerkleProofInfoDTO>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'height' is set
        if (height == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'height' when calling getMerkleReceipts"));
            return;
        }
        
        // verify the required parameter 'hash' is set
        if (hash == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'hash' when calling getMerkleReceipts"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/blocks/{height}/statements/{hash}/merkle".replaceAll("\\{" + "height" + "\\}", height.toString()).replaceAll("\\{" + "hash" + "\\}", hash.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<MerkleProofInfoDTO> localVarReturnType = new TypeReference<MerkleProofInfoDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get the merkle path for a given a transaction and block
     * Returns the merkle path for a transaction included in a block. The merkle path is the minimum number of nodes needed to calculate the merkle root.  Steps to calculate the merkle root: 1. proofHash &#x3D; hash (leaf). 2. Concatenate proofHash with the first unprocessed item from the merklePath list as follows: * a) If item.position &#x3D;&#x3D; left -&gt; proofHash &#x3D; sha_256(item.hash + proofHash). * b) If item.position &#x3D;&#x3D; right -&gt; proofHash &#x3D; sha_256(proofHash+ item.hash). 3. Repeat 2. for every item in the merklePath list. 4. Compare if the calculated proofHash equals the one recorded in the block header (block.transactionsHash) to verify if the transaction was included in the block. 
     * @param height Block height. (required)
     * @param hash Transaction hash. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getMerkleTransaction(java.math.BigInteger height, String hash, Handler<AsyncResult<MerkleProofInfoDTO>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'height' is set
        if (height == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'height' when calling getMerkleTransaction"));
            return;
        }
        
        // verify the required parameter 'hash' is set
        if (hash == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'hash' when calling getMerkleTransaction"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/blocks/{height}/transactions/{hash}/merkle".replaceAll("\\{" + "height" + "\\}", height.toString()).replaceAll("\\{" + "hash" + "\\}", hash.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<MerkleProofInfoDTO> localVarReturnType = new TypeReference<MerkleProofInfoDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Search blocks
     * Gets an array of bocks.
     * @param signerPublicKey Filter by public key of the account signing the entity. (optional)
     * @param beneficiaryAddress Filter by beneficiary address. (optional)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @param orderBy Sort responses by the property set.  (optional)
     * @param resultHandler Asynchronous result handler
     */
    public void searchBlocks(String signerPublicKey, String beneficiaryAddress, Integer pageSize, Integer pageNumber, String offset, Order order, BlockOrderByEnum orderBy, Handler<AsyncResult<BlockPage>> resultHandler) {
        Object localVarBody = null;
        
        // create path and map variables
        String localVarPath = "/blocks";

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "signerPublicKey", signerPublicKey));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "beneficiaryAddress", beneficiaryAddress));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageNumber", pageNumber));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "offset", offset));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "order", order));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "orderBy", orderBy));

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<BlockPage> localVarReturnType = new TypeReference<BlockPage>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
}
