/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.vertx.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"version", "publicKey", "networkGenerationHashSeed", "roles", "port", "networkIdentifier", "friendlyName", "host", "nodePublicKey"})
public class NodeInfoDTO {
    public static final String JSON_PROPERTY_VERSION = "version";
    private Integer version;
    public static final String JSON_PROPERTY_PUBLIC_KEY = "publicKey";
    private String publicKey;
    public static final String JSON_PROPERTY_NETWORK_GENERATION_HASH_SEED = "networkGenerationHashSeed";
    private String networkGenerationHashSeed;
    public static final String JSON_PROPERTY_ROLES = "roles";
    private Integer roles;
    public static final String JSON_PROPERTY_PORT = "port";
    private Integer port;
    public static final String JSON_PROPERTY_NETWORK_IDENTIFIER = "networkIdentifier";
    private Integer networkIdentifier;
    public static final String JSON_PROPERTY_FRIENDLY_NAME = "friendlyName";
    private String friendlyName;
    public static final String JSON_PROPERTY_HOST = "host";
    private String host;
    public static final String JSON_PROPERTY_NODE_PUBLIC_KEY = "nodePublicKey";
    private String nodePublicKey;

    public NodeInfoDTO version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="0", required=true, value="Version of the application.")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public NodeInfoDTO publicKey(String publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    @ApiModelProperty(example="AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required=true, value="Public key.")
    @JsonProperty(value="publicKey")
    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public NodeInfoDTO networkGenerationHashSeed(String networkGenerationHashSeed) {
        this.networkGenerationHashSeed = networkGenerationHashSeed;
        return this;
    }

    @ApiModelProperty(example="C8FC3FB54FDDFBCE0E8C71224990124E4EEC5AD5D30E592EDFA9524669A23810", required=true, value="")
    @JsonProperty(value="networkGenerationHashSeed")
    public String getNetworkGenerationHashSeed() {
        return this.networkGenerationHashSeed;
    }

    public void setNetworkGenerationHashSeed(String networkGenerationHashSeed) {
        this.networkGenerationHashSeed = networkGenerationHashSeed;
    }

    public NodeInfoDTO roles(Integer roles) {
        this.roles = roles;
        return this;
    }

    @ApiModelProperty(example="7", required=true, value="A number that defines the different roles the node provides. Possible roles are: * 1 - Peer node. * 2 - Api node. * 4 - Voting node. * 64 - IPv4 compatible node * 128 - IPv6 compatible node.  The values are bitwise added together, Examples: 1 = Just Peer. 2 = Just Api. 3 = Peer and Api node. 7 = Peer, Api and Voting node. 65 = IPv4 and Peer node. ")
    @JsonProperty(value="roles")
    public Integer getRoles() {
        return this.roles;
    }

    public void setRoles(Integer roles) {
        this.roles = roles;
    }

    public NodeInfoDTO port(Integer port) {
        this.port = port;
        return this;
    }

    @ApiModelProperty(example="7900", required=true, value="Port used for the communication.")
    @JsonProperty(value="port")
    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public NodeInfoDTO networkIdentifier(Integer networkIdentifier) {
        this.networkIdentifier = networkIdentifier;
        return this;
    }

    @ApiModelProperty(example="144", required=true, value="")
    @JsonProperty(value="networkIdentifier")
    public Integer getNetworkIdentifier() {
        return this.networkIdentifier;
    }

    public void setNetworkIdentifier(Integer networkIdentifier) {
        this.networkIdentifier = networkIdentifier;
    }

    public NodeInfoDTO friendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    @ApiModelProperty(example="api-node-0", required=true, value="Node friendly name.")
    @JsonProperty(value="friendlyName")
    public String getFriendlyName() {
        return this.friendlyName;
    }

    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    public NodeInfoDTO host(String host) {
        this.host = host;
        return this;
    }

    @ApiModelProperty(example="127.0.0.1", required=true, value="Node IP address.")
    @JsonProperty(value="host")
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public NodeInfoDTO nodePublicKey(String nodePublicKey) {
        this.nodePublicKey = nodePublicKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", value="Public key.")
    @JsonProperty(value="nodePublicKey")
    public String getNodePublicKey() {
        return this.nodePublicKey;
    }

    public void setNodePublicKey(String nodePublicKey) {
        this.nodePublicKey = nodePublicKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeInfoDTO nodeInfoDTO = (NodeInfoDTO)o;
        return Objects.equals(this.version, nodeInfoDTO.version) && Objects.equals(this.publicKey, nodeInfoDTO.publicKey) && Objects.equals(this.networkGenerationHashSeed, nodeInfoDTO.networkGenerationHashSeed) && Objects.equals(this.roles, nodeInfoDTO.roles) && Objects.equals(this.port, nodeInfoDTO.port) && Objects.equals(this.networkIdentifier, nodeInfoDTO.networkIdentifier) && Objects.equals(this.friendlyName, nodeInfoDTO.friendlyName) && Objects.equals(this.host, nodeInfoDTO.host) && Objects.equals(this.nodePublicKey, nodeInfoDTO.nodePublicKey);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.publicKey, this.networkGenerationHashSeed, this.roles, this.port, this.networkIdentifier, this.friendlyName, this.host, this.nodePublicKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NodeInfoDTO {\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    publicKey: ").append(this.toIndentedString(this.publicKey)).append("\n");
        sb.append("    networkGenerationHashSeed: ").append(this.toIndentedString(this.networkGenerationHashSeed)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("    networkIdentifier: ").append(this.toIndentedString(this.networkIdentifier)).append("\n");
        sb.append("    friendlyName: ").append(this.toIndentedString(this.friendlyName)).append("\n");
        sb.append("    host: ").append(this.toIndentedString(this.host)).append("\n");
        sb.append("    nodePublicKey: ").append(this.toIndentedString(this.nodePublicKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

