/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.vertx.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"minRemovalDelta", "minApprovalDelta", "addressAdditions", "addressDeletions"})
public class MultisigAccountModificationTransactionBodyDTO {
    public static final String JSON_PROPERTY_MIN_REMOVAL_DELTA = "minRemovalDelta";
    private Integer minRemovalDelta;
    public static final String JSON_PROPERTY_MIN_APPROVAL_DELTA = "minApprovalDelta";
    private Integer minApprovalDelta;
    public static final String JSON_PROPERTY_ADDRESS_ADDITIONS = "addressAdditions";
    private List<String> addressAdditions = new ArrayList<String>();
    public static final String JSON_PROPERTY_ADDRESS_DELETIONS = "addressDeletions";
    private List<String> addressDeletions = new ArrayList<String>();

    public MultisigAccountModificationTransactionBodyDTO minRemovalDelta(Integer minRemovalDelta) {
        this.minRemovalDelta = minRemovalDelta;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="Number of signatures needed to remove a cosignatory. If we are modifying an existing multisig account, this indicates the relative change of the minimum cosignatories. ")
    @JsonProperty(value="minRemovalDelta")
    public Integer getMinRemovalDelta() {
        return this.minRemovalDelta;
    }

    public void setMinRemovalDelta(Integer minRemovalDelta) {
        this.minRemovalDelta = minRemovalDelta;
    }

    public MultisigAccountModificationTransactionBodyDTO minApprovalDelta(Integer minApprovalDelta) {
        this.minApprovalDelta = minApprovalDelta;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="Number of signatures needed to approve a transaction. If we are modifying an existing multisig account, this indicates the relative change of the minimum cosignatories. ")
    @JsonProperty(value="minApprovalDelta")
    public Integer getMinApprovalDelta() {
        return this.minApprovalDelta;
    }

    public void setMinApprovalDelta(Integer minApprovalDelta) {
        this.minApprovalDelta = minApprovalDelta;
    }

    public MultisigAccountModificationTransactionBodyDTO addressAdditions(List<String> addressAdditions) {
        this.addressAdditions = addressAdditions;
        return this;
    }

    public MultisigAccountModificationTransactionBodyDTO addAddressAdditionsItem(String addressAdditionsItem) {
        this.addressAdditions.add(addressAdditionsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Array of cosignatory accounts to add.")
    @JsonProperty(value="addressAdditions")
    public List<String> getAddressAdditions() {
        return this.addressAdditions;
    }

    public void setAddressAdditions(List<String> addressAdditions) {
        this.addressAdditions = addressAdditions;
    }

    public MultisigAccountModificationTransactionBodyDTO addressDeletions(List<String> addressDeletions) {
        this.addressDeletions = addressDeletions;
        return this;
    }

    public MultisigAccountModificationTransactionBodyDTO addAddressDeletionsItem(String addressDeletionsItem) {
        this.addressDeletions.add(addressDeletionsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Array of cosignatory accounts to delete.")
    @JsonProperty(value="addressDeletions")
    public List<String> getAddressDeletions() {
        return this.addressDeletions;
    }

    public void setAddressDeletions(List<String> addressDeletions) {
        this.addressDeletions = addressDeletions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultisigAccountModificationTransactionBodyDTO multisigAccountModificationTransactionBodyDTO = (MultisigAccountModificationTransactionBodyDTO)o;
        return Objects.equals(this.minRemovalDelta, multisigAccountModificationTransactionBodyDTO.minRemovalDelta) && Objects.equals(this.minApprovalDelta, multisigAccountModificationTransactionBodyDTO.minApprovalDelta) && Objects.equals(this.addressAdditions, multisigAccountModificationTransactionBodyDTO.addressAdditions) && Objects.equals(this.addressDeletions, multisigAccountModificationTransactionBodyDTO.addressDeletions);
    }

    public int hashCode() {
        return Objects.hash(this.minRemovalDelta, this.minApprovalDelta, this.addressAdditions, this.addressDeletions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MultisigAccountModificationTransactionBodyDTO {\n");
        sb.append("    minRemovalDelta: ").append(this.toIndentedString(this.minRemovalDelta)).append("\n");
        sb.append("    minApprovalDelta: ").append(this.toIndentedString(this.minApprovalDelta)).append("\n");
        sb.append("    addressAdditions: ").append(this.toIndentedString(this.addressAdditions)).append("\n");
        sb.append("    addressDeletions: ").append(this.toIndentedString(this.addressDeletions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

