/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest 2.2.0
 *
 * The version of the OpenAPI document: 0.10.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.symbol.sdk.openapi.vertx.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * MultisigAccountModificationTransactionBodyDTO
 */
@JsonPropertyOrder({
  MultisigAccountModificationTransactionBodyDTO.JSON_PROPERTY_MIN_REMOVAL_DELTA,
  MultisigAccountModificationTransactionBodyDTO.JSON_PROPERTY_MIN_APPROVAL_DELTA,
  MultisigAccountModificationTransactionBodyDTO.JSON_PROPERTY_ADDRESS_ADDITIONS,
  MultisigAccountModificationTransactionBodyDTO.JSON_PROPERTY_ADDRESS_DELETIONS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-12-08T20:59:17.892Z[UTC]")
public class MultisigAccountModificationTransactionBodyDTO {
  public static final String JSON_PROPERTY_MIN_REMOVAL_DELTA = "minRemovalDelta";
  private Integer minRemovalDelta;

  public static final String JSON_PROPERTY_MIN_APPROVAL_DELTA = "minApprovalDelta";
  private Integer minApprovalDelta;

  public static final String JSON_PROPERTY_ADDRESS_ADDITIONS = "addressAdditions";
  private List<String> addressAdditions = new ArrayList<>();

  public static final String JSON_PROPERTY_ADDRESS_DELETIONS = "addressDeletions";
  private List<String> addressDeletions = new ArrayList<>();


  public MultisigAccountModificationTransactionBodyDTO minRemovalDelta(Integer minRemovalDelta) {
    
    this.minRemovalDelta = minRemovalDelta;
    return this;
  }

   /**
   * Number of signatures needed to remove a cosignatory. If we are modifying an existing multisig account, this indicates the relative change of the minimum cosignatories. 
   * @return minRemovalDelta
  **/
  @ApiModelProperty(example = "1", required = true, value = "Number of signatures needed to remove a cosignatory. If we are modifying an existing multisig account, this indicates the relative change of the minimum cosignatories. ")
  @JsonProperty(JSON_PROPERTY_MIN_REMOVAL_DELTA)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMinRemovalDelta() {
    return minRemovalDelta;
  }


  public void setMinRemovalDelta(Integer minRemovalDelta) {
    this.minRemovalDelta = minRemovalDelta;
  }


  public MultisigAccountModificationTransactionBodyDTO minApprovalDelta(Integer minApprovalDelta) {
    
    this.minApprovalDelta = minApprovalDelta;
    return this;
  }

   /**
   * Number of signatures needed to approve a transaction. If we are modifying an existing multisig account, this indicates the relative change of the minimum cosignatories. 
   * @return minApprovalDelta
  **/
  @ApiModelProperty(example = "1", required = true, value = "Number of signatures needed to approve a transaction. If we are modifying an existing multisig account, this indicates the relative change of the minimum cosignatories. ")
  @JsonProperty(JSON_PROPERTY_MIN_APPROVAL_DELTA)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMinApprovalDelta() {
    return minApprovalDelta;
  }


  public void setMinApprovalDelta(Integer minApprovalDelta) {
    this.minApprovalDelta = minApprovalDelta;
  }


  public MultisigAccountModificationTransactionBodyDTO addressAdditions(List<String> addressAdditions) {
    
    this.addressAdditions = addressAdditions;
    return this;
  }

  public MultisigAccountModificationTransactionBodyDTO addAddressAdditionsItem(String addressAdditionsItem) {
    this.addressAdditions.add(addressAdditionsItem);
    return this;
  }

   /**
   * Array of cosignatory accounts to add.
   * @return addressAdditions
  **/
  @ApiModelProperty(required = true, value = "Array of cosignatory accounts to add.")
  @JsonProperty(JSON_PROPERTY_ADDRESS_ADDITIONS)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getAddressAdditions() {
    return addressAdditions;
  }


  public void setAddressAdditions(List<String> addressAdditions) {
    this.addressAdditions = addressAdditions;
  }


  public MultisigAccountModificationTransactionBodyDTO addressDeletions(List<String> addressDeletions) {
    
    this.addressDeletions = addressDeletions;
    return this;
  }

  public MultisigAccountModificationTransactionBodyDTO addAddressDeletionsItem(String addressDeletionsItem) {
    this.addressDeletions.add(addressDeletionsItem);
    return this;
  }

   /**
   * Array of cosignatory accounts to delete.
   * @return addressDeletions
  **/
  @ApiModelProperty(required = true, value = "Array of cosignatory accounts to delete.")
  @JsonProperty(JSON_PROPERTY_ADDRESS_DELETIONS)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getAddressDeletions() {
    return addressDeletions;
  }


  public void setAddressDeletions(List<String> addressDeletions) {
    this.addressDeletions = addressDeletions;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MultisigAccountModificationTransactionBodyDTO multisigAccountModificationTransactionBodyDTO = (MultisigAccountModificationTransactionBodyDTO) o;
    return Objects.equals(this.minRemovalDelta, multisigAccountModificationTransactionBodyDTO.minRemovalDelta) &&
        Objects.equals(this.minApprovalDelta, multisigAccountModificationTransactionBodyDTO.minApprovalDelta) &&
        Objects.equals(this.addressAdditions, multisigAccountModificationTransactionBodyDTO.addressAdditions) &&
        Objects.equals(this.addressDeletions, multisigAccountModificationTransactionBodyDTO.addressDeletions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(minRemovalDelta, minApprovalDelta, addressAdditions, addressDeletions);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MultisigAccountModificationTransactionBodyDTO {\n");
    sb.append("    minRemovalDelta: ").append(toIndentedString(minRemovalDelta)).append("\n");
    sb.append("    minApprovalDelta: ").append(toIndentedString(minApprovalDelta)).append("\n");
    sb.append("    addressAdditions: ").append(toIndentedString(addressAdditions)).append("\n");
    sb.append("    addressDeletions: ").append(toIndentedString(addressDeletions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

