/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest 2.2.0
 *
 * The version of the OpenAPI document: 0.10.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.symbol.sdk.openapi.vertx.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * The merkle path information clients can use to proof the state of the given entity. 
 */
@ApiModel(description = "The merkle path information clients can use to proof the state of the given entity. ")
@JsonPropertyOrder({
  MerkleStateInfoDTO.JSON_PROPERTY_RAW,
  MerkleStateInfoDTO.JSON_PROPERTY_TREE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-12-08T20:59:17.892Z[UTC]")
public class MerkleStateInfoDTO {
  public static final String JSON_PROPERTY_RAW = "raw";
  private String raw;

  public static final String JSON_PROPERTY_TREE = "tree";
  private List<Object> tree = new ArrayList<>();


  public MerkleStateInfoDTO raw(String raw) {
    
    this.raw = raw;
    return this;
  }

   /**
   * The hex information of the complete merkle tree as returned by server api. More information can be found in chapter 4.3 of the catapult whitepaper. 
   * @return raw
  **/
  @ApiModelProperty(example = "00008080DA9B4AF63BE985715EA635AF98E3CF3B0A22F9A2BE1C7DD40B79948AA63E36586E5D2E9D0C089C1C64BC0D42A11ADBD1CD6CDB4B7C294062F55113525A64AE3CFF3F04A7F2A487B42EA89323C4408F82415223ACFEC7DFA7924EFC31A70778AB17A00C3EAFF635F01BB3B474F0AF1BE99FBDA85EEFB209CC7BD158D3540DE3A3F2D1", required = true, value = "The hex information of the complete merkle tree as returned by server api. More information can be found in chapter 4.3 of the catapult whitepaper. ")
  @JsonProperty(JSON_PROPERTY_RAW)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRaw() {
    return raw;
  }


  public void setRaw(String raw) {
    this.raw = raw;
  }


  public MerkleStateInfoDTO tree(List<Object> tree) {
    
    this.tree = tree;
    return this;
  }

  public MerkleStateInfoDTO addTreeItem(Object treeItem) {
    this.tree.add(treeItem);
    return this;
  }

   /**
   * Merkle tree parsed from merkle tree raw.
   * @return tree
  **/
  @ApiModelProperty(required = true, value = "Merkle tree parsed from merkle tree raw.")
  @JsonProperty(JSON_PROPERTY_TREE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<Object> getTree() {
    return tree;
  }


  public void setTree(List<Object> tree) {
    this.tree = tree;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MerkleStateInfoDTO merkleStateInfoDTO = (MerkleStateInfoDTO) o;
    return Objects.equals(this.raw, merkleStateInfoDTO.raw) &&
        Objects.equals(this.tree, merkleStateInfoDTO.tree);
  }

  @Override
  public int hashCode() {
    return Objects.hash(raw, tree);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MerkleStateInfoDTO {\n");
    sb.append("    raw: ").append(toIndentedString(raw)).append("\n");
    sb.append("    tree: ").append(toIndentedString(tree)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

