/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest 2.2.0
 *
 * The version of the OpenAPI document: 0.10.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.symbol.sdk.openapi.vertx.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.nem.symbol.sdk.openapi.vertx.model.EmbeddedTransactionDTO;
import io.nem.symbol.sdk.openapi.vertx.model.LockHashAlgorithmEnum;
import io.nem.symbol.sdk.openapi.vertx.model.NetworkTypeEnum;
import io.nem.symbol.sdk.openapi.vertx.model.SecretProofTransactionBodyDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * EmbeddedSecretProofTransactionDTO
 */
@JsonPropertyOrder({
  EmbeddedSecretProofTransactionDTO.JSON_PROPERTY_SIGNER_PUBLIC_KEY,
  EmbeddedSecretProofTransactionDTO.JSON_PROPERTY_VERSION,
  EmbeddedSecretProofTransactionDTO.JSON_PROPERTY_NETWORK,
  EmbeddedSecretProofTransactionDTO.JSON_PROPERTY_TYPE,
  EmbeddedSecretProofTransactionDTO.JSON_PROPERTY_RECIPIENT_ADDRESS,
  EmbeddedSecretProofTransactionDTO.JSON_PROPERTY_SECRET,
  EmbeddedSecretProofTransactionDTO.JSON_PROPERTY_HASH_ALGORITHM,
  EmbeddedSecretProofTransactionDTO.JSON_PROPERTY_PROOF
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-12-08T20:59:17.892Z[UTC]")
public class EmbeddedSecretProofTransactionDTO {
  public static final String JSON_PROPERTY_SIGNER_PUBLIC_KEY = "signerPublicKey";
  private String signerPublicKey;

  public static final String JSON_PROPERTY_VERSION = "version";
  private Integer version;

  public static final String JSON_PROPERTY_NETWORK = "network";
  private NetworkTypeEnum network;

  public static final String JSON_PROPERTY_TYPE = "type";
  private Integer type;

  public static final String JSON_PROPERTY_RECIPIENT_ADDRESS = "recipientAddress";
  private String recipientAddress;

  public static final String JSON_PROPERTY_SECRET = "secret";
  private String secret;

  public static final String JSON_PROPERTY_HASH_ALGORITHM = "hashAlgorithm";
  private LockHashAlgorithmEnum hashAlgorithm;

  public static final String JSON_PROPERTY_PROOF = "proof";
  private String proof;


  public EmbeddedSecretProofTransactionDTO signerPublicKey(String signerPublicKey) {
    
    this.signerPublicKey = signerPublicKey;
    return this;
  }

   /**
   * Public key.
   * @return signerPublicKey
  **/
  @ApiModelProperty(example = "AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required = true, value = "Public key.")
  @JsonProperty(JSON_PROPERTY_SIGNER_PUBLIC_KEY)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSignerPublicKey() {
    return signerPublicKey;
  }


  public void setSignerPublicKey(String signerPublicKey) {
    this.signerPublicKey = signerPublicKey;
  }


  public EmbeddedSecretProofTransactionDTO version(Integer version) {
    
    this.version = version;
    return this;
  }

   /**
   * Entity version.
   * @return version
  **/
  @ApiModelProperty(required = true, value = "Entity version.")
  @JsonProperty(JSON_PROPERTY_VERSION)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getVersion() {
    return version;
  }


  public void setVersion(Integer version) {
    this.version = version;
  }


  public EmbeddedSecretProofTransactionDTO network(NetworkTypeEnum network) {
    
    this.network = network;
    return this;
  }

   /**
   * Get network
   * @return network
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_NETWORK)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public NetworkTypeEnum getNetwork() {
    return network;
  }


  public void setNetwork(NetworkTypeEnum network) {
    this.network = network;
  }


  public EmbeddedSecretProofTransactionDTO type(Integer type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TYPE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getType() {
    return type;
  }


  public void setType(Integer type) {
    this.type = type;
  }


  public EmbeddedSecretProofTransactionDTO recipientAddress(String recipientAddress) {
    
    this.recipientAddress = recipientAddress;
    return this;
  }

   /**
   * Address expressed in hexadecimal base. If the bit 0 of byte 0 is not set (like in 0x90), then it is a regular address. Else (e.g. 0x91) it represents a namespace id which starts at byte 1. 
   * @return recipientAddress
  **/
  @ApiModelProperty(example = "90340017CFF3DD2BCF3B2670CDCB9FC8C75754E2325F297C", required = true, value = "Address expressed in hexadecimal base. If the bit 0 of byte 0 is not set (like in 0x90), then it is a regular address. Else (e.g. 0x91) it represents a namespace id which starts at byte 1. ")
  @JsonProperty(JSON_PROPERTY_RECIPIENT_ADDRESS)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRecipientAddress() {
    return recipientAddress;
  }


  public void setRecipientAddress(String recipientAddress) {
    this.recipientAddress = recipientAddress;
  }


  public EmbeddedSecretProofTransactionDTO secret(String secret) {
    
    this.secret = secret;
    return this;
  }

   /**
   * Get secret
   * @return secret
  **/
  @ApiModelProperty(example = "C8FC3FB54FDDFBCE0E8C71224990124E4EEC5AD5D30E592EDFA9524669A23810", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_SECRET)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSecret() {
    return secret;
  }


  public void setSecret(String secret) {
    this.secret = secret;
  }


  public EmbeddedSecretProofTransactionDTO hashAlgorithm(LockHashAlgorithmEnum hashAlgorithm) {
    
    this.hashAlgorithm = hashAlgorithm;
    return this;
  }

   /**
   * Get hashAlgorithm
   * @return hashAlgorithm
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_HASH_ALGORITHM)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LockHashAlgorithmEnum getHashAlgorithm() {
    return hashAlgorithm;
  }


  public void setHashAlgorithm(LockHashAlgorithmEnum hashAlgorithm) {
    this.hashAlgorithm = hashAlgorithm;
  }


  public EmbeddedSecretProofTransactionDTO proof(String proof) {
    
    this.proof = proof;
    return this;
  }

   /**
   * Original random set of bytes.
   * @return proof
  **/
  @ApiModelProperty(required = true, value = "Original random set of bytes.")
  @JsonProperty(JSON_PROPERTY_PROOF)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getProof() {
    return proof;
  }


  public void setProof(String proof) {
    this.proof = proof;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EmbeddedSecretProofTransactionDTO embeddedSecretProofTransactionDTO = (EmbeddedSecretProofTransactionDTO) o;
    return Objects.equals(this.signerPublicKey, embeddedSecretProofTransactionDTO.signerPublicKey) &&
        Objects.equals(this.version, embeddedSecretProofTransactionDTO.version) &&
        Objects.equals(this.network, embeddedSecretProofTransactionDTO.network) &&
        Objects.equals(this.type, embeddedSecretProofTransactionDTO.type) &&
        Objects.equals(this.recipientAddress, embeddedSecretProofTransactionDTO.recipientAddress) &&
        Objects.equals(this.secret, embeddedSecretProofTransactionDTO.secret) &&
        Objects.equals(this.hashAlgorithm, embeddedSecretProofTransactionDTO.hashAlgorithm) &&
        Objects.equals(this.proof, embeddedSecretProofTransactionDTO.proof);
  }

  @Override
  public int hashCode() {
    return Objects.hash(signerPublicKey, version, network, type, recipientAddress, secret, hashAlgorithm, proof);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EmbeddedSecretProofTransactionDTO {\n");
    sb.append("    signerPublicKey: ").append(toIndentedString(signerPublicKey)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    network: ").append(toIndentedString(network)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    recipientAddress: ").append(toIndentedString(recipientAddress)).append("\n");
    sb.append("    secret: ").append(toIndentedString(secret)).append("\n");
    sb.append("    hashAlgorithm: ").append(toIndentedString(hashAlgorithm)).append("\n");
    sb.append("    proof: ").append(toIndentedString(proof)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

