package io.nem.symbol.sdk.openapi.vertx.api.rxjava;

import io.nem.symbol.sdk.openapi.vertx.model.AnnounceTransactionInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.Cosignature;
import io.nem.symbol.sdk.openapi.vertx.model.ModelError;
import io.nem.symbol.sdk.openapi.vertx.model.Order;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionIds;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionPage;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionPayload;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionTypeEnum;

import java.util.*;

import rx.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-12-08T20:59:17.892Z[UTC]")
public class TransactionRoutesApi {

	private final io.nem.symbol.sdk.openapi.vertx.api.TransactionRoutesApi delegate;

	public TransactionRoutesApi(io.nem.symbol.sdk.openapi.vertx.api.TransactionRoutesApi delegate) {
	    this.delegate = delegate;
    }

	public io.nem.symbol.sdk.openapi.vertx.api.TransactionRoutesApi getDelegate() {
	    return delegate;
	}

    /**
     * Announce a cosignature transaction
     * Announces a cosignature transaction to the network.
     * @param cosignature  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void announceCosignatureTransaction(Cosignature cosignature, Handler<AsyncResult<AnnounceTransactionInfoDTO>> resultHandler) {
        delegate.announceCosignatureTransaction(cosignature, resultHandler);
    }

    /**
     * Announce a cosignature transaction
     * Announces a cosignature transaction to the network.
     * @param cosignature  (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<AnnounceTransactionInfoDTO> rxAnnounceCosignatureTransaction(Cosignature cosignature) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.announceCosignatureTransaction(cosignature, fut);
        }));
    }
    /**
     * Announce an aggregate bonded transaction
     * Announces an aggregate bonded transaction to the network.
     * @param transactionPayload  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void announcePartialTransaction(TransactionPayload transactionPayload, Handler<AsyncResult<AnnounceTransactionInfoDTO>> resultHandler) {
        delegate.announcePartialTransaction(transactionPayload, resultHandler);
    }

    /**
     * Announce an aggregate bonded transaction
     * Announces an aggregate bonded transaction to the network.
     * @param transactionPayload  (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<AnnounceTransactionInfoDTO> rxAnnouncePartialTransaction(TransactionPayload transactionPayload) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.announcePartialTransaction(transactionPayload, fut);
        }));
    }
    /**
     * Announce a new transaction
     * Announces a transaction to the network. The [catbuffer library](https://github.com/nemtech/catbuffer) defines the protocol to serialize and deserialize Symbol entities. Catbuffers are integrated into [Symbol SDKs](https://nemtech.github.io/sdk.html).  It&#39;s recommended to use SDKs instead of calling the API endpoint directly to announce transactions. 
     * @param transactionPayload  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void announceTransaction(TransactionPayload transactionPayload, Handler<AsyncResult<AnnounceTransactionInfoDTO>> resultHandler) {
        delegate.announceTransaction(transactionPayload, resultHandler);
    }

    /**
     * Announce a new transaction
     * Announces a transaction to the network. The [catbuffer library](https://github.com/nemtech/catbuffer) defines the protocol to serialize and deserialize Symbol entities. Catbuffers are integrated into [Symbol SDKs](https://nemtech.github.io/sdk.html).  It&#39;s recommended to use SDKs instead of calling the API endpoint directly to announce transactions. 
     * @param transactionPayload  (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<AnnounceTransactionInfoDTO> rxAnnounceTransaction(TransactionPayload transactionPayload) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.announceTransaction(transactionPayload, fut);
        }));
    }
    /**
     * Get confirmed transaction information
     * Returns confirmed transaction information given a transactionId or hash.
     * @param transactionId Transaction id or hash. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getConfirmedTransaction(String transactionId, Handler<AsyncResult<TransactionInfoDTO>> resultHandler) {
        delegate.getConfirmedTransaction(transactionId, resultHandler);
    }

    /**
     * Get confirmed transaction information
     * Returns confirmed transaction information given a transactionId or hash.
     * @param transactionId Transaction id or hash. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<TransactionInfoDTO> rxGetConfirmedTransaction(String transactionId) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getConfirmedTransaction(transactionId, fut);
        }));
    }
    /**
     * Get confirmed trasactions information
     * Returns confirmed transactions information for a given array of transactionIds.
     * @param transactionIds  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getConfirmedTransactions(TransactionIds transactionIds, Handler<AsyncResult<List<TransactionInfoDTO>>> resultHandler) {
        delegate.getConfirmedTransactions(transactionIds, resultHandler);
    }

    /**
     * Get confirmed trasactions information
     * Returns confirmed transactions information for a given array of transactionIds.
     * @param transactionIds  (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<List<TransactionInfoDTO>> rxGetConfirmedTransactions(TransactionIds transactionIds) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getConfirmedTransactions(transactionIds, fut);
        }));
    }
    /**
     * Get partial transaction information
     * Returns partial transaction information given a transactionId or hash.
     * @param transactionId Transaction id or hash. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getPartialTransaction(String transactionId, Handler<AsyncResult<TransactionInfoDTO>> resultHandler) {
        delegate.getPartialTransaction(transactionId, resultHandler);
    }

    /**
     * Get partial transaction information
     * Returns partial transaction information given a transactionId or hash.
     * @param transactionId Transaction id or hash. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<TransactionInfoDTO> rxGetPartialTransaction(String transactionId) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getPartialTransaction(transactionId, fut);
        }));
    }
    /**
     * Get partial trasactions information
     * Returns partial transactions information for a given array of transactionIds.
     * @param transactionIds  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getPartialTransactions(TransactionIds transactionIds, Handler<AsyncResult<List<TransactionInfoDTO>>> resultHandler) {
        delegate.getPartialTransactions(transactionIds, resultHandler);
    }

    /**
     * Get partial trasactions information
     * Returns partial transactions information for a given array of transactionIds.
     * @param transactionIds  (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<List<TransactionInfoDTO>> rxGetPartialTransactions(TransactionIds transactionIds) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getPartialTransactions(transactionIds, fut);
        }));
    }
    /**
     * Get unconfirmed transaction information
     * Returns unconfirmed transaction information given a transactionId or hash.
     * @param transactionId Transaction id or hash. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getUnconfirmedTransaction(String transactionId, Handler<AsyncResult<TransactionInfoDTO>> resultHandler) {
        delegate.getUnconfirmedTransaction(transactionId, resultHandler);
    }

    /**
     * Get unconfirmed transaction information
     * Returns unconfirmed transaction information given a transactionId or hash.
     * @param transactionId Transaction id or hash. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<TransactionInfoDTO> rxGetUnconfirmedTransaction(String transactionId) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getUnconfirmedTransaction(transactionId, fut);
        }));
    }
    /**
     * Get unconfirmed trasactions information
     * Returns unconfirmed transactions information for a given array of transactionIds.
     * @param transactionIds  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getUnconfirmedTransactions(TransactionIds transactionIds, Handler<AsyncResult<List<TransactionInfoDTO>>> resultHandler) {
        delegate.getUnconfirmedTransactions(transactionIds, resultHandler);
    }

    /**
     * Get unconfirmed trasactions information
     * Returns unconfirmed transactions information for a given array of transactionIds.
     * @param transactionIds  (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<List<TransactionInfoDTO>> rxGetUnconfirmedTransactions(TransactionIds transactionIds) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getUnconfirmedTransactions(transactionIds, fut);
        }));
    }
    /**
     * Search confirmed transactions
     * Returns an array of confirmed transactions. If a transaction was announced with an alias rather than an address, the address that will be considered when querying is the one that was resolved from the alias at confirmation time. 
     * @param address Filter by address involved in the transaction.  An account&#39;s address is considered to be involved in the transaction when the account is the sender, recipient, or it is required to cosign the transaction. This filter cannot be combined with &#x60;&#x60;recipientAddress&#x60;&#x60; and &#x60;&#x60;signerPublicKey&#x60;&#x60; query params.  (optional)
     * @param recipientAddress Filter by address of the account receiving the transaction. (optional)
     * @param signerPublicKey Filter by public key of the account signing the entity. (optional)
     * @param height Filter by block height. (optional, default to null)
     * @param fromHeight Only blocks with height greater or equal than this one are returned. (optional, default to null)
     * @param toHeight Only blocks with height smaller or equal than this one are returned. (optional, default to null)
     * @param fromTransferAmount Requires providing the &#x60;transferMosaicId&#x60; filter. Only transfer transactions with a transfer amount of the provided mosaic id, greater or equal than this amount are returned.  (optional, default to null)
     * @param toTransferAmount Requires providing the &#x60;transferMosaicId&#x60; filter. Only transfer transactions with a transfer amount of the provided mosaic id, lesser or equal than this amount are returned.  (optional, default to null)
     * @param type Filter by transaction type. To filter by multiple transaction types, add more filter query params like: &#x60;&#x60;type&#x3D;16974&amp;type&#x3D;16718&#x60;&#x60;.  (optional, default to new ArrayList&lt;&gt;())
     * @param embedded When true, the endpoint also returns all the embedded aggregate transactions. Otherwise, only top-level transactions used to calculate the block transactionsHash are returned.  (optional, default to false)
     * @param transferMosaicId Filters transactions involving a specific &#x60;&#x60;mosaicId&#x60;&#x60;. (optional)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @param resultHandler Asynchronous result handler
     */
    public void searchConfirmedTransactions(String address, String recipientAddress, String signerPublicKey, java.math.BigInteger height, java.math.BigInteger fromHeight, java.math.BigInteger toHeight, java.math.BigInteger fromTransferAmount, java.math.BigInteger toTransferAmount, List<TransactionTypeEnum> type, Boolean embedded, String transferMosaicId, Integer pageSize, Integer pageNumber, String offset, Order order, Handler<AsyncResult<TransactionPage>> resultHandler) {
        delegate.searchConfirmedTransactions(address, recipientAddress, signerPublicKey, height, fromHeight, toHeight, fromTransferAmount, toTransferAmount, type, embedded, transferMosaicId, pageSize, pageNumber, offset, order, resultHandler);
    }

    /**
     * Search confirmed transactions
     * Returns an array of confirmed transactions. If a transaction was announced with an alias rather than an address, the address that will be considered when querying is the one that was resolved from the alias at confirmation time. 
     * @param address Filter by address involved in the transaction.  An account&#39;s address is considered to be involved in the transaction when the account is the sender, recipient, or it is required to cosign the transaction. This filter cannot be combined with &#x60;&#x60;recipientAddress&#x60;&#x60; and &#x60;&#x60;signerPublicKey&#x60;&#x60; query params.  (optional)
     * @param recipientAddress Filter by address of the account receiving the transaction. (optional)
     * @param signerPublicKey Filter by public key of the account signing the entity. (optional)
     * @param height Filter by block height. (optional, default to null)
     * @param fromHeight Only blocks with height greater or equal than this one are returned. (optional, default to null)
     * @param toHeight Only blocks with height smaller or equal than this one are returned. (optional, default to null)
     * @param fromTransferAmount Requires providing the &#x60;transferMosaicId&#x60; filter. Only transfer transactions with a transfer amount of the provided mosaic id, greater or equal than this amount are returned.  (optional, default to null)
     * @param toTransferAmount Requires providing the &#x60;transferMosaicId&#x60; filter. Only transfer transactions with a transfer amount of the provided mosaic id, lesser or equal than this amount are returned.  (optional, default to null)
     * @param type Filter by transaction type. To filter by multiple transaction types, add more filter query params like: &#x60;&#x60;type&#x3D;16974&amp;type&#x3D;16718&#x60;&#x60;.  (optional, default to new ArrayList&lt;&gt;())
     * @param embedded When true, the endpoint also returns all the embedded aggregate transactions. Otherwise, only top-level transactions used to calculate the block transactionsHash are returned.  (optional, default to false)
     * @param transferMosaicId Filters transactions involving a specific &#x60;&#x60;mosaicId&#x60;&#x60;. (optional)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<TransactionPage> rxSearchConfirmedTransactions(String address, String recipientAddress, String signerPublicKey, java.math.BigInteger height, java.math.BigInteger fromHeight, java.math.BigInteger toHeight, java.math.BigInteger fromTransferAmount, java.math.BigInteger toTransferAmount, List<TransactionTypeEnum> type, Boolean embedded, String transferMosaicId, Integer pageSize, Integer pageNumber, String offset, Order order) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.searchConfirmedTransactions(address, recipientAddress, signerPublicKey, height, fromHeight, toHeight, fromTransferAmount, toTransferAmount, type, embedded, transferMosaicId, pageSize, pageNumber, offset, order, fut);
        }));
    }
    /**
     * Search partial transactions
     * Returns an array of partial transactions.
     * @param address Filter by address involved in the transaction.  An account&#39;s address is considered to be involved in the transaction when the account is the sender, recipient, or it is required to cosign the transaction. This filter cannot be combined with &#x60;&#x60;recipientAddress&#x60;&#x60; and &#x60;&#x60;signerPublicKey&#x60;&#x60; query params.  (optional)
     * @param recipientAddress Filter by address of the account receiving the transaction. (optional)
     * @param signerPublicKey Filter by public key of the account signing the entity. (optional)
     * @param height Filter by block height. (optional, default to null)
     * @param fromHeight Only blocks with height greater or equal than this one are returned. (optional, default to null)
     * @param toHeight Only blocks with height smaller or equal than this one are returned. (optional, default to null)
     * @param fromTransferAmount Requires providing the &#x60;transferMosaicId&#x60; filter. Only transfer transactions with a transfer amount of the provided mosaic id, greater or equal than this amount are returned.  (optional, default to null)
     * @param toTransferAmount Requires providing the &#x60;transferMosaicId&#x60; filter. Only transfer transactions with a transfer amount of the provided mosaic id, lesser or equal than this amount are returned.  (optional, default to null)
     * @param type Filter by transaction type. To filter by multiple transaction types, add more filter query params like: &#x60;&#x60;type&#x3D;16974&amp;type&#x3D;16718&#x60;&#x60;.  (optional, default to new ArrayList&lt;&gt;())
     * @param embedded When true, the endpoint also returns all the embedded aggregate transactions. Otherwise, only top-level transactions used to calculate the block transactionsHash are returned.  (optional, default to false)
     * @param transferMosaicId Filters transactions involving a specific &#x60;&#x60;mosaicId&#x60;&#x60;. (optional)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @param resultHandler Asynchronous result handler
     */
    public void searchPartialTransactions(String address, String recipientAddress, String signerPublicKey, java.math.BigInteger height, java.math.BigInteger fromHeight, java.math.BigInteger toHeight, java.math.BigInteger fromTransferAmount, java.math.BigInteger toTransferAmount, List<TransactionTypeEnum> type, Boolean embedded, String transferMosaicId, Integer pageSize, Integer pageNumber, String offset, Order order, Handler<AsyncResult<TransactionPage>> resultHandler) {
        delegate.searchPartialTransactions(address, recipientAddress, signerPublicKey, height, fromHeight, toHeight, fromTransferAmount, toTransferAmount, type, embedded, transferMosaicId, pageSize, pageNumber, offset, order, resultHandler);
    }

    /**
     * Search partial transactions
     * Returns an array of partial transactions.
     * @param address Filter by address involved in the transaction.  An account&#39;s address is considered to be involved in the transaction when the account is the sender, recipient, or it is required to cosign the transaction. This filter cannot be combined with &#x60;&#x60;recipientAddress&#x60;&#x60; and &#x60;&#x60;signerPublicKey&#x60;&#x60; query params.  (optional)
     * @param recipientAddress Filter by address of the account receiving the transaction. (optional)
     * @param signerPublicKey Filter by public key of the account signing the entity. (optional)
     * @param height Filter by block height. (optional, default to null)
     * @param fromHeight Only blocks with height greater or equal than this one are returned. (optional, default to null)
     * @param toHeight Only blocks with height smaller or equal than this one are returned. (optional, default to null)
     * @param fromTransferAmount Requires providing the &#x60;transferMosaicId&#x60; filter. Only transfer transactions with a transfer amount of the provided mosaic id, greater or equal than this amount are returned.  (optional, default to null)
     * @param toTransferAmount Requires providing the &#x60;transferMosaicId&#x60; filter. Only transfer transactions with a transfer amount of the provided mosaic id, lesser or equal than this amount are returned.  (optional, default to null)
     * @param type Filter by transaction type. To filter by multiple transaction types, add more filter query params like: &#x60;&#x60;type&#x3D;16974&amp;type&#x3D;16718&#x60;&#x60;.  (optional, default to new ArrayList&lt;&gt;())
     * @param embedded When true, the endpoint also returns all the embedded aggregate transactions. Otherwise, only top-level transactions used to calculate the block transactionsHash are returned.  (optional, default to false)
     * @param transferMosaicId Filters transactions involving a specific &#x60;&#x60;mosaicId&#x60;&#x60;. (optional)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<TransactionPage> rxSearchPartialTransactions(String address, String recipientAddress, String signerPublicKey, java.math.BigInteger height, java.math.BigInteger fromHeight, java.math.BigInteger toHeight, java.math.BigInteger fromTransferAmount, java.math.BigInteger toTransferAmount, List<TransactionTypeEnum> type, Boolean embedded, String transferMosaicId, Integer pageSize, Integer pageNumber, String offset, Order order) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.searchPartialTransactions(address, recipientAddress, signerPublicKey, height, fromHeight, toHeight, fromTransferAmount, toTransferAmount, type, embedded, transferMosaicId, pageSize, pageNumber, offset, order, fut);
        }));
    }
    /**
     * Search unconfirmed transactions
     * Returns an array of unconfirmed transactions.
     * @param address Filter by address involved in the transaction.  An account&#39;s address is considered to be involved in the transaction when the account is the sender, recipient, or it is required to cosign the transaction. This filter cannot be combined with &#x60;&#x60;recipientAddress&#x60;&#x60; and &#x60;&#x60;signerPublicKey&#x60;&#x60; query params.  (optional)
     * @param recipientAddress Filter by address of the account receiving the transaction. (optional)
     * @param signerPublicKey Filter by public key of the account signing the entity. (optional)
     * @param height Filter by block height. (optional, default to null)
     * @param fromHeight Only blocks with height greater or equal than this one are returned. (optional, default to null)
     * @param toHeight Only blocks with height smaller or equal than this one are returned. (optional, default to null)
     * @param fromTransferAmount Requires providing the &#x60;transferMosaicId&#x60; filter. Only transfer transactions with a transfer amount of the provided mosaic id, greater or equal than this amount are returned.  (optional, default to null)
     * @param toTransferAmount Requires providing the &#x60;transferMosaicId&#x60; filter. Only transfer transactions with a transfer amount of the provided mosaic id, lesser or equal than this amount are returned.  (optional, default to null)
     * @param type Filter by transaction type. To filter by multiple transaction types, add more filter query params like: &#x60;&#x60;type&#x3D;16974&amp;type&#x3D;16718&#x60;&#x60;.  (optional, default to new ArrayList&lt;&gt;())
     * @param embedded When true, the endpoint also returns all the embedded aggregate transactions. Otherwise, only top-level transactions used to calculate the block transactionsHash are returned.  (optional, default to false)
     * @param transferMosaicId Filters transactions involving a specific &#x60;&#x60;mosaicId&#x60;&#x60;. (optional)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @param resultHandler Asynchronous result handler
     */
    public void searchUnconfirmedTransactions(String address, String recipientAddress, String signerPublicKey, java.math.BigInteger height, java.math.BigInteger fromHeight, java.math.BigInteger toHeight, java.math.BigInteger fromTransferAmount, java.math.BigInteger toTransferAmount, List<TransactionTypeEnum> type, Boolean embedded, String transferMosaicId, Integer pageSize, Integer pageNumber, String offset, Order order, Handler<AsyncResult<TransactionPage>> resultHandler) {
        delegate.searchUnconfirmedTransactions(address, recipientAddress, signerPublicKey, height, fromHeight, toHeight, fromTransferAmount, toTransferAmount, type, embedded, transferMosaicId, pageSize, pageNumber, offset, order, resultHandler);
    }

    /**
     * Search unconfirmed transactions
     * Returns an array of unconfirmed transactions.
     * @param address Filter by address involved in the transaction.  An account&#39;s address is considered to be involved in the transaction when the account is the sender, recipient, or it is required to cosign the transaction. This filter cannot be combined with &#x60;&#x60;recipientAddress&#x60;&#x60; and &#x60;&#x60;signerPublicKey&#x60;&#x60; query params.  (optional)
     * @param recipientAddress Filter by address of the account receiving the transaction. (optional)
     * @param signerPublicKey Filter by public key of the account signing the entity. (optional)
     * @param height Filter by block height. (optional, default to null)
     * @param fromHeight Only blocks with height greater or equal than this one are returned. (optional, default to null)
     * @param toHeight Only blocks with height smaller or equal than this one are returned. (optional, default to null)
     * @param fromTransferAmount Requires providing the &#x60;transferMosaicId&#x60; filter. Only transfer transactions with a transfer amount of the provided mosaic id, greater or equal than this amount are returned.  (optional, default to null)
     * @param toTransferAmount Requires providing the &#x60;transferMosaicId&#x60; filter. Only transfer transactions with a transfer amount of the provided mosaic id, lesser or equal than this amount are returned.  (optional, default to null)
     * @param type Filter by transaction type. To filter by multiple transaction types, add more filter query params like: &#x60;&#x60;type&#x3D;16974&amp;type&#x3D;16718&#x60;&#x60;.  (optional, default to new ArrayList&lt;&gt;())
     * @param embedded When true, the endpoint also returns all the embedded aggregate transactions. Otherwise, only top-level transactions used to calculate the block transactionsHash are returned.  (optional, default to false)
     * @param transferMosaicId Filters transactions involving a specific &#x60;&#x60;mosaicId&#x60;&#x60;. (optional)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<TransactionPage> rxSearchUnconfirmedTransactions(String address, String recipientAddress, String signerPublicKey, java.math.BigInteger height, java.math.BigInteger fromHeight, java.math.BigInteger toHeight, java.math.BigInteger fromTransferAmount, java.math.BigInteger toTransferAmount, List<TransactionTypeEnum> type, Boolean embedded, String transferMosaicId, Integer pageSize, Integer pageNumber, String offset, Order order) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.searchUnconfirmedTransactions(address, recipientAddress, signerPublicKey, height, fromHeight, toHeight, fromTransferAmount, toTransferAmount, type, embedded, transferMosaicId, pageSize, pageNumber, offset, order, fut);
        }));
    }

    public static TransactionRoutesApi newInstance(io.nem.symbol.sdk.openapi.vertx.api.TransactionRoutesApi arg) {
        return arg != null ? new TransactionRoutesApi(arg) : null;
    }
}
