/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.vertx.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.nem.symbol.sdk.openapi.vertx.model.MetadataTypeEnum;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"version", "compositeHash", "sourceAddress", "targetAddress", "scopedMetadataKey", "targetId", "metadataType", "value"})
public class MetadataEntryDTO {
    public static final String JSON_PROPERTY_VERSION = "version";
    private Integer version;
    public static final String JSON_PROPERTY_COMPOSITE_HASH = "compositeHash";
    private String compositeHash;
    public static final String JSON_PROPERTY_SOURCE_ADDRESS = "sourceAddress";
    private String sourceAddress;
    public static final String JSON_PROPERTY_TARGET_ADDRESS = "targetAddress";
    private String targetAddress;
    public static final String JSON_PROPERTY_SCOPED_METADATA_KEY = "scopedMetadataKey";
    private String scopedMetadataKey;
    public static final String JSON_PROPERTY_TARGET_ID = "targetId";
    private String targetId;
    public static final String JSON_PROPERTY_METADATA_TYPE = "metadataType";
    private MetadataTypeEnum metadataType;
    public static final String JSON_PROPERTY_VALUE = "value";
    private String value;

    public MetadataEntryDTO version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="The version of the state")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public MetadataEntryDTO compositeHash(String compositeHash) {
        this.compositeHash = compositeHash;
        return this;
    }

    @ApiModelProperty(example="C8FC3FB54FDDFBCE0E8C71224990124E4EEC5AD5D30E592EDFA9524669A23810", required=true, value="")
    @JsonProperty(value="compositeHash")
    public String getCompositeHash() {
        return this.compositeHash;
    }

    public void setCompositeHash(String compositeHash) {
        this.compositeHash = compositeHash;
    }

    public MetadataEntryDTO sourceAddress(String sourceAddress) {
        this.sourceAddress = sourceAddress;
        return this;
    }

    @ApiModelProperty(example="9081FCCB41F8C8409A9B99E485E0E28D23BD6304EF7215E0", required=true, value="Address expressed in hexadecimal base.")
    @JsonProperty(value="sourceAddress")
    public String getSourceAddress() {
        return this.sourceAddress;
    }

    public void setSourceAddress(String sourceAddress) {
        this.sourceAddress = sourceAddress;
    }

    public MetadataEntryDTO targetAddress(String targetAddress) {
        this.targetAddress = targetAddress;
        return this;
    }

    @ApiModelProperty(example="9081FCCB41F8C8409A9B99E485E0E28D23BD6304EF7215E0", required=true, value="Address expressed in hexadecimal base.")
    @JsonProperty(value="targetAddress")
    public String getTargetAddress() {
        return this.targetAddress;
    }

    public void setTargetAddress(String targetAddress) {
        this.targetAddress = targetAddress;
    }

    public MetadataEntryDTO scopedMetadataKey(String scopedMetadataKey) {
        this.scopedMetadataKey = scopedMetadataKey;
        return this;
    }

    @ApiModelProperty(example="0DC67FBE1CAD29E3", required=true, value="Metadata key scoped to source, target and type expressed.")
    @JsonProperty(value="scopedMetadataKey")
    public String getScopedMetadataKey() {
        return this.scopedMetadataKey;
    }

    public void setScopedMetadataKey(String scopedMetadataKey) {
        this.scopedMetadataKey = scopedMetadataKey;
    }

    public MetadataEntryDTO targetId(String targetId) {
        this.targetId = targetId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="targetId")
    public String getTargetId() {
        return this.targetId;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    public MetadataEntryDTO metadataType(MetadataTypeEnum metadataType) {
        this.metadataType = metadataType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="metadataType")
    public MetadataTypeEnum getMetadataType() {
        return this.metadataType;
    }

    public void setMetadataType(MetadataTypeEnum metadataType) {
        this.metadataType = metadataType;
    }

    public MetadataEntryDTO value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(required=true, value="Metadata value.")
    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataEntryDTO metadataEntryDTO = (MetadataEntryDTO)o;
        return Objects.equals(this.version, metadataEntryDTO.version) && Objects.equals(this.compositeHash, metadataEntryDTO.compositeHash) && Objects.equals(this.sourceAddress, metadataEntryDTO.sourceAddress) && Objects.equals(this.targetAddress, metadataEntryDTO.targetAddress) && Objects.equals(this.scopedMetadataKey, metadataEntryDTO.scopedMetadataKey) && Objects.equals(this.targetId, metadataEntryDTO.targetId) && Objects.equals((Object)this.metadataType, (Object)metadataEntryDTO.metadataType) && Objects.equals(this.value, metadataEntryDTO.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.version, this.compositeHash, this.sourceAddress, this.targetAddress, this.scopedMetadataKey, this.targetId, this.metadataType, this.value});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetadataEntryDTO {\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    compositeHash: ").append(this.toIndentedString(this.compositeHash)).append("\n");
        sb.append("    sourceAddress: ").append(this.toIndentedString(this.sourceAddress)).append("\n");
        sb.append("    targetAddress: ").append(this.toIndentedString(this.targetAddress)).append("\n");
        sb.append("    scopedMetadataKey: ").append(this.toIndentedString(this.scopedMetadataKey)).append("\n");
        sb.append("    targetId: ").append(this.toIndentedString(this.targetId)).append("\n");
        sb.append("    metadataType: ").append(this.toIndentedString((Object)this.metadataType)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

