/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.vertx.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.nem.symbol.sdk.openapi.vertx.model.MerkleTreeBranchLinkDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MerkleTreeNodeTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Merkle tree branch node.")
@JsonPropertyOrder(value={"type", "path", "encodedPath", "nibbleCount", "linkMask", "links", "branchHash"})
public class MerkleTreeBranchDTO {
    public static final String JSON_PROPERTY_TYPE = "type";
    private MerkleTreeNodeTypeEnum type;
    public static final String JSON_PROPERTY_PATH = "path";
    private String path;
    public static final String JSON_PROPERTY_ENCODED_PATH = "encodedPath";
    private String encodedPath;
    public static final String JSON_PROPERTY_NIBBLE_COUNT = "nibbleCount";
    private Integer nibbleCount;
    public static final String JSON_PROPERTY_LINK_MASK = "linkMask";
    private String linkMask;
    public static final String JSON_PROPERTY_LINKS = "links";
    private List<MerkleTreeBranchLinkDTO> links = new ArrayList<MerkleTreeBranchLinkDTO>();
    public static final String JSON_PROPERTY_BRANCH_HASH = "branchHash";
    private String branchHash;

    public MerkleTreeBranchDTO type(MerkleTreeNodeTypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    public MerkleTreeNodeTypeEnum getType() {
        return this.type;
    }

    public void setType(MerkleTreeNodeTypeEnum type) {
        this.type = type;
    }

    public MerkleTreeBranchDTO path(String path) {
        this.path = path;
        return this;
    }

    @ApiModelProperty(required=true, value="Branch link path.")
    @JsonProperty(value="path")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public MerkleTreeBranchDTO encodedPath(String encodedPath) {
        this.encodedPath = encodedPath;
        return this;
    }

    @ApiModelProperty(required=true, value="Encoded branch link path.")
    @JsonProperty(value="encodedPath")
    public String getEncodedPath() {
        return this.encodedPath;
    }

    public void setEncodedPath(String encodedPath) {
        this.encodedPath = encodedPath;
    }

    public MerkleTreeBranchDTO nibbleCount(Integer nibbleCount) {
        this.nibbleCount = nibbleCount;
        return this;
    }

    @ApiModelProperty(required=true, value="Nibble count.")
    @JsonProperty(value="nibbleCount")
    public Integer getNibbleCount() {
        return this.nibbleCount;
    }

    public void setNibbleCount(Integer nibbleCount) {
        this.nibbleCount = nibbleCount;
    }

    public MerkleTreeBranchDTO linkMask(String linkMask) {
        this.linkMask = linkMask;
        return this;
    }

    @ApiModelProperty(required=true, value="Branch link bitmask.")
    @JsonProperty(value="linkMask")
    public String getLinkMask() {
        return this.linkMask;
    }

    public void setLinkMask(String linkMask) {
        this.linkMask = linkMask;
    }

    public MerkleTreeBranchDTO links(List<MerkleTreeBranchLinkDTO> links) {
        this.links = links;
        return this;
    }

    public MerkleTreeBranchDTO addLinksItem(MerkleTreeBranchLinkDTO linksItem) {
        this.links.add(linksItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Branch links (max 16).")
    @JsonProperty(value="links")
    public List<MerkleTreeBranchLinkDTO> getLinks() {
        return this.links;
    }

    public void setLinks(List<MerkleTreeBranchLinkDTO> links) {
        this.links = links;
    }

    public MerkleTreeBranchDTO branchHash(String branchHash) {
        this.branchHash = branchHash;
        return this;
    }

    @ApiModelProperty(example="C8FC3FB54FDDFBCE0E8C71224990124E4EEC5AD5D30E592EDFA9524669A23810", required=true, value="")
    @JsonProperty(value="branchHash")
    public String getBranchHash() {
        return this.branchHash;
    }

    public void setBranchHash(String branchHash) {
        this.branchHash = branchHash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MerkleTreeBranchDTO merkleTreeBranchDTO = (MerkleTreeBranchDTO)o;
        return Objects.equals((Object)this.type, (Object)merkleTreeBranchDTO.type) && Objects.equals(this.path, merkleTreeBranchDTO.path) && Objects.equals(this.encodedPath, merkleTreeBranchDTO.encodedPath) && Objects.equals(this.nibbleCount, merkleTreeBranchDTO.nibbleCount) && Objects.equals(this.linkMask, merkleTreeBranchDTO.linkMask) && Objects.equals(this.links, merkleTreeBranchDTO.links) && Objects.equals(this.branchHash, merkleTreeBranchDTO.branchHash);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.path, this.encodedPath, this.nibbleCount, this.linkMask, this.links, this.branchHash});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MerkleTreeBranchDTO {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    encodedPath: ").append(this.toIndentedString(this.encodedPath)).append("\n");
        sb.append("    nibbleCount: ").append(this.toIndentedString(this.nibbleCount)).append("\n");
        sb.append("    linkMask: ").append(this.toIndentedString(this.linkMask)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    branchHash: ").append(this.toIndentedString(this.branchHash)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

