package io.nem.symbol.sdk.openapi.vertx.api.rxjava;

import io.nem.symbol.sdk.openapi.vertx.model.ModelError;
import io.nem.symbol.sdk.openapi.vertx.model.NetworkConfigurationDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NetworkTypeDTO;
import io.nem.symbol.sdk.openapi.vertx.model.RentalFeesDTO;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionFeesDTO;

import java.util.*;

import rx.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-12-08T20:28:55.194Z[UTC]")
public class NetworkRoutesApi {

	private final io.nem.symbol.sdk.openapi.vertx.api.NetworkRoutesApi delegate;

	public NetworkRoutesApi(io.nem.symbol.sdk.openapi.vertx.api.NetworkRoutesApi delegate) {
	    this.delegate = delegate;
    }

	public io.nem.symbol.sdk.openapi.vertx.api.NetworkRoutesApi getDelegate() {
	    return delegate;
	}

    /**
     * Get the network properties
     * Returns the content from a catapult-server network configuration file (resources/config-network.properties). To enable this feature, the REST setting \&quot;network.propertiesFilePath\&quot; must define where the file is located. This is adjustable via the configuration file (rest/resources/rest.json) per REST instance. 
     * @param resultHandler Asynchronous result handler
     */
    public void getNetworkProperties(Handler<AsyncResult<NetworkConfigurationDTO>> resultHandler) {
        delegate.getNetworkProperties(resultHandler);
    }

    /**
     * Get the network properties
     * Returns the content from a catapult-server network configuration file (resources/config-network.properties). To enable this feature, the REST setting \&quot;network.propertiesFilePath\&quot; must define where the file is located. This is adjustable via the configuration file (rest/resources/rest.json) per REST instance. 
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<NetworkConfigurationDTO> rxGetNetworkProperties() {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getNetworkProperties(fut);
        }));
    }
    /**
     * Get the current network type of the chain
     * Returns the current network type.
     * @param resultHandler Asynchronous result handler
     */
    public void getNetworkType(Handler<AsyncResult<NetworkTypeDTO>> resultHandler) {
        delegate.getNetworkType(resultHandler);
    }

    /**
     * Get the current network type of the chain
     * Returns the current network type.
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<NetworkTypeDTO> rxGetNetworkType() {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getNetworkType(fut);
        }));
    }
    /**
     * Get rental fees information
     * Returns the estimated effective rental fees for namespaces and mosaics. This endpoint is only available if the REST instance has access to catapult-server &#x60;&#x60;resources/config-network.properties&#x60;&#x60; file. To activate this feature, add the setting \&quot;network.propertiesFilePath\&quot; in the configuration file (rest/resources/rest.json). 
     * @param resultHandler Asynchronous result handler
     */
    public void getRentalFees(Handler<AsyncResult<RentalFeesDTO>> resultHandler) {
        delegate.getRentalFees(resultHandler);
    }

    /**
     * Get rental fees information
     * Returns the estimated effective rental fees for namespaces and mosaics. This endpoint is only available if the REST instance has access to catapult-server &#x60;&#x60;resources/config-network.properties&#x60;&#x60; file. To activate this feature, add the setting \&quot;network.propertiesFilePath\&quot; in the configuration file (rest/resources/rest.json). 
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<RentalFeesDTO> rxGetRentalFees() {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getRentalFees(fut);
        }));
    }
    /**
     * Get transaction fees information
     * Returns the average, median, highest and lower fee multiplier over the last \&quot;numBlocksTransactionFeeStats\&quot;. The setting \&quot;numBlocksTransactionFeeStats\&quot; is adjustable via the configuration file (rest/resources/rest.json) per REST instance. 
     * @param resultHandler Asynchronous result handler
     */
    public void getTransactionFees(Handler<AsyncResult<TransactionFeesDTO>> resultHandler) {
        delegate.getTransactionFees(resultHandler);
    }

    /**
     * Get transaction fees information
     * Returns the average, median, highest and lower fee multiplier over the last \&quot;numBlocksTransactionFeeStats\&quot;. The setting \&quot;numBlocksTransactionFeeStats\&quot; is adjustable via the configuration file (rest/resources/rest.json) per REST instance. 
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<TransactionFeesDTO> rxGetTransactionFees() {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getTransactionFees(fut);
        }));
    }

    public static NetworkRoutesApi newInstance(io.nem.symbol.sdk.openapi.vertx.api.NetworkRoutesApi arg) {
        return arg != null ? new NetworkRoutesApi(arg) : null;
    }
}
