package io.nem.symbol.sdk.openapi.vertx.api.rxjava;

import io.nem.symbol.sdk.openapi.vertx.model.MerkleStateInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.ModelError;
import io.nem.symbol.sdk.openapi.vertx.model.MultisigAccountGraphInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MultisigAccountInfoDTO;

import java.util.*;

import rx.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-12-08T20:28:55.194Z[UTC]")
public class MultisigRoutesApi {

	private final io.nem.symbol.sdk.openapi.vertx.api.MultisigRoutesApi delegate;

	public MultisigRoutesApi(io.nem.symbol.sdk.openapi.vertx.api.MultisigRoutesApi delegate) {
	    this.delegate = delegate;
    }

	public io.nem.symbol.sdk.openapi.vertx.api.MultisigRoutesApi getDelegate() {
	    return delegate;
	}

    /**
     * Get multisig account information
     * Returns the multisig account information.
     * @param address Account address. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountMultisig(String address, Handler<AsyncResult<MultisigAccountInfoDTO>> resultHandler) {
        delegate.getAccountMultisig(address, resultHandler);
    }

    /**
     * Get multisig account information
     * Returns the multisig account information.
     * @param address Account address. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MultisigAccountInfoDTO> rxGetAccountMultisig(String address) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getAccountMultisig(address, fut);
        }));
    }
    /**
     * Get multisig account graph information
     * Returns the multisig account graph.
     * @param address Account address. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountMultisigGraph(String address, Handler<AsyncResult<List<MultisigAccountGraphInfoDTO>>> resultHandler) {
        delegate.getAccountMultisigGraph(address, resultHandler);
    }

    /**
     * Get multisig account graph information
     * Returns the multisig account graph.
     * @param address Account address. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<List<MultisigAccountGraphInfoDTO>> rxGetAccountMultisigGraph(String address) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getAccountMultisigGraph(address, fut);
        }));
    }
    /**
     * Get multisig account merkle information
     * Returns the multisig account merkle information.
     * @param address Account address. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountMultisigMerkle(String address, Handler<AsyncResult<MerkleStateInfoDTO>> resultHandler) {
        delegate.getAccountMultisigMerkle(address, resultHandler);
    }

    /**
     * Get multisig account merkle information
     * Returns the multisig account merkle information.
     * @param address Account address. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MerkleStateInfoDTO> rxGetAccountMultisigMerkle(String address) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getAccountMultisigMerkle(address, fut);
        }));
    }

    public static MultisigRoutesApi newInstance(io.nem.symbol.sdk.openapi.vertx.api.MultisigRoutesApi arg) {
        return arg != null ? new MultisigRoutesApi(arg) : null;
    }
}
