package io.nem.symbol.sdk.openapi.vertx.api.rxjava;

import io.nem.symbol.sdk.openapi.vertx.model.MerkleStateInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.ModelError;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicIds;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicPage;
import io.nem.symbol.sdk.openapi.vertx.model.Order;

import java.util.*;

import rx.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-12-08T20:28:55.194Z[UTC]")
public class MosaicRoutesApi {

	private final io.nem.symbol.sdk.openapi.vertx.api.MosaicRoutesApi delegate;

	public MosaicRoutesApi(io.nem.symbol.sdk.openapi.vertx.api.MosaicRoutesApi delegate) {
	    this.delegate = delegate;
    }

	public io.nem.symbol.sdk.openapi.vertx.api.MosaicRoutesApi getDelegate() {
	    return delegate;
	}

    /**
     * Get mosaic information
     * Gets the mosaic definition for a given mosaic identifier.
     * @param mosaicId Mosaic identifier. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getMosaic(String mosaicId, Handler<AsyncResult<MosaicInfoDTO>> resultHandler) {
        delegate.getMosaic(mosaicId, resultHandler);
    }

    /**
     * Get mosaic information
     * Gets the mosaic definition for a given mosaic identifier.
     * @param mosaicId Mosaic identifier. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MosaicInfoDTO> rxGetMosaic(String mosaicId) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getMosaic(mosaicId, fut);
        }));
    }
    /**
     * Get mosaic merkle information
     * Gets the mosaic definition merkle for a given mosaic identifier.
     * @param mosaicId Mosaic identifier. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getMosaicMerkle(String mosaicId, Handler<AsyncResult<MerkleStateInfoDTO>> resultHandler) {
        delegate.getMosaicMerkle(mosaicId, resultHandler);
    }

    /**
     * Get mosaic merkle information
     * Gets the mosaic definition merkle for a given mosaic identifier.
     * @param mosaicId Mosaic identifier. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MerkleStateInfoDTO> rxGetMosaicMerkle(String mosaicId) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getMosaicMerkle(mosaicId, fut);
        }));
    }
    /**
     * Get mosaics information for an array of mosaics
     * Gets an array of mosaic definition.
     * @param mosaicIds  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getMosaics(MosaicIds mosaicIds, Handler<AsyncResult<List<MosaicInfoDTO>>> resultHandler) {
        delegate.getMosaics(mosaicIds, resultHandler);
    }

    /**
     * Get mosaics information for an array of mosaics
     * Gets an array of mosaic definition.
     * @param mosaicIds  (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<List<MosaicInfoDTO>> rxGetMosaics(MosaicIds mosaicIds) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getMosaics(mosaicIds, fut);
        }));
    }
    /**
     * Search mosaics
     * Gets an array of mosaics.
     * @param ownerAddress Filter by owner address. (optional)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @param resultHandler Asynchronous result handler
     */
    public void searchMosaics(String ownerAddress, Integer pageSize, Integer pageNumber, String offset, Order order, Handler<AsyncResult<MosaicPage>> resultHandler) {
        delegate.searchMosaics(ownerAddress, pageSize, pageNumber, offset, order, resultHandler);
    }

    /**
     * Search mosaics
     * Gets an array of mosaics.
     * @param ownerAddress Filter by owner address. (optional)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MosaicPage> rxSearchMosaics(String ownerAddress, Integer pageSize, Integer pageNumber, String offset, Order order) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.searchMosaics(ownerAddress, pageSize, pageNumber, offset, order, fut);
        }));
    }

    public static MosaicRoutesApi newInstance(io.nem.symbol.sdk.openapi.vertx.api.MosaicRoutesApi arg) {
        return arg != null ? new MosaicRoutesApi(arg) : null;
    }
}
