package io.nem.symbol.sdk.openapi.vertx.api;

import io.nem.symbol.sdk.openapi.vertx.model.AccountsNamesDTO;
import io.nem.symbol.sdk.openapi.vertx.model.Addresses;
import io.nem.symbol.sdk.openapi.vertx.model.AliasTypeEnum;
import io.nem.symbol.sdk.openapi.vertx.model.MerkleStateInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.ModelError;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicIds;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicsNamesDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NamespaceIds;
import io.nem.symbol.sdk.openapi.vertx.model.NamespaceInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NamespaceNameDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NamespacePage;
import io.nem.symbol.sdk.openapi.vertx.model.NamespaceRegistrationTypeEnum;
import io.nem.symbol.sdk.openapi.vertx.model.Order;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonObject;

import com.fasterxml.jackson.core.type.TypeReference;

import java.util.*;

import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiException;
import io.nem.symbol.sdk.openapi.vertx.invoker.Configuration;
import io.nem.symbol.sdk.openapi.vertx.invoker.Pair;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-12-08T20:28:55.194Z[UTC]")
public class NamespaceRoutesApiImpl implements NamespaceRoutesApi {

    private ApiClient apiClient;

    public NamespaceRoutesApiImpl() {
        this(null);
    }

    public NamespaceRoutesApiImpl(ApiClient apiClient) {
        this.apiClient = apiClient != null ? apiClient : Configuration.getDefaultApiClient();
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Get readable names for a set of accountIds
     * Returns friendly names for accounts.
     * @param addresses  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountsNames(Addresses addresses, Handler<AsyncResult<AccountsNamesDTO>> resultHandler) {
        Object localVarBody = addresses;
        
        // verify the required parameter 'addresses' is set
        if (addresses == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'addresses' when calling getAccountsNames"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/namespaces/account/names";

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = { "application/json" };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<AccountsNamesDTO> localVarReturnType = new TypeReference<AccountsNamesDTO>() {};
        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get readable names for a set of mosaics
     * Returns friendly names for mosaics.
     * @param mosaicIds  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getMosaicsNames(MosaicIds mosaicIds, Handler<AsyncResult<MosaicsNamesDTO>> resultHandler) {
        Object localVarBody = mosaicIds;
        
        // verify the required parameter 'mosaicIds' is set
        if (mosaicIds == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'mosaicIds' when calling getMosaicsNames"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/namespaces/mosaic/names";

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = { "application/json" };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<MosaicsNamesDTO> localVarReturnType = new TypeReference<MosaicsNamesDTO>() {};
        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get namespace information
     * Gets the namespace for a given namespace identifier.
     * @param namespaceId Namespace identifier. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getNamespace(String namespaceId, Handler<AsyncResult<NamespaceInfoDTO>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'namespaceId' is set
        if (namespaceId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'namespaceId' when calling getNamespace"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/namespaces/{namespaceId}".replaceAll("\\{" + "namespaceId" + "\\}", namespaceId.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<NamespaceInfoDTO> localVarReturnType = new TypeReference<NamespaceInfoDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get namespace merkle information
     * Gets the namespace merkle for a given namespace identifier.
     * @param namespaceId Namespace identifier. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getNamespaceMerkle(String namespaceId, Handler<AsyncResult<MerkleStateInfoDTO>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'namespaceId' is set
        if (namespaceId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'namespaceId' when calling getNamespaceMerkle"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/namespaces/{namespaceId}/merkle".replaceAll("\\{" + "namespaceId" + "\\}", namespaceId.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<MerkleStateInfoDTO> localVarReturnType = new TypeReference<MerkleStateInfoDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get readable names for a set of namespaces
     * Returns friendly names for namespaces.
     * @param namespaceIds  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getNamespacesNames(NamespaceIds namespaceIds, Handler<AsyncResult<List<NamespaceNameDTO>>> resultHandler) {
        Object localVarBody = namespaceIds;
        
        // verify the required parameter 'namespaceIds' is set
        if (namespaceIds == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'namespaceIds' when calling getNamespacesNames"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/namespaces/names";

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = { "application/json" };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<List<NamespaceNameDTO>> localVarReturnType = new TypeReference<List<NamespaceNameDTO>>() {};
        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Search namespaces
     * Gets an array of namespaces.
     * @param ownerAddress Filter by owner address. (optional)
     * @param registrationType Filter by registration type. (optional)
     * @param level0 Filter by root namespace. (optional)
     * @param aliasType Filter by alias type. (optional)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @param resultHandler Asynchronous result handler
     */
    public void searchNamespaces(String ownerAddress, NamespaceRegistrationTypeEnum registrationType, String level0, AliasTypeEnum aliasType, Integer pageSize, Integer pageNumber, String offset, Order order, Handler<AsyncResult<NamespacePage>> resultHandler) {
        Object localVarBody = null;
        
        // create path and map variables
        String localVarPath = "/namespaces";

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "ownerAddress", ownerAddress));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "registrationType", registrationType));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "level0", level0));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "aliasType", aliasType));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageNumber", pageNumber));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "offset", offset));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "order", order));

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<NamespacePage> localVarReturnType = new TypeReference<NamespacePage>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
}
