/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.vertx.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.Objects;

@JsonPropertyOrder(value={"ownerAddress", "mosaicId", "amount", "endHeight", "status", "hash"})
public class HashLockEntryDTO {
    public static final String JSON_PROPERTY_OWNER_ADDRESS = "ownerAddress";
    private String ownerAddress;
    public static final String JSON_PROPERTY_MOSAIC_ID = "mosaicId";
    private String mosaicId;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private BigInteger amount = null;
    public static final String JSON_PROPERTY_END_HEIGHT = "endHeight";
    private BigInteger endHeight = null;
    public static final String JSON_PROPERTY_STATUS = "status";
    private Integer status;
    public static final String JSON_PROPERTY_HASH = "hash";
    private String hash;

    public HashLockEntryDTO ownerAddress(String ownerAddress) {
        this.ownerAddress = ownerAddress;
        return this;
    }

    @ApiModelProperty(example="9081FCCB41F8C8409A9B99E485E0E28D23BD6304EF7215E0", required=true, value="Address expressed in hexadecimal base.")
    @JsonProperty(value="ownerAddress")
    public String getOwnerAddress() {
        return this.ownerAddress;
    }

    public void setOwnerAddress(String ownerAddress) {
        this.ownerAddress = ownerAddress;
    }

    public HashLockEntryDTO mosaicId(String mosaicId) {
        this.mosaicId = mosaicId;
        return this;
    }

    @ApiModelProperty(example="0DC67FBE1CAD29E3", required=true, value="Mosaic identifier.")
    @JsonProperty(value="mosaicId")
    public String getMosaicId() {
        return this.mosaicId;
    }

    public void setMosaicId(String mosaicId) {
        this.mosaicId = mosaicId;
    }

    public HashLockEntryDTO amount(BigInteger amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(example="123456", required=true, value="Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
    @JsonProperty(value="amount")
    public BigInteger getAmount() {
        return this.amount;
    }

    public void setAmount(BigInteger amount) {
        this.amount = amount;
    }

    public HashLockEntryDTO endHeight(BigInteger endHeight) {
        this.endHeight = endHeight;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="Height of the blockchain.")
    @JsonProperty(value="endHeight")
    public BigInteger getEndHeight() {
        return this.endHeight;
    }

    public void setEndHeight(BigInteger endHeight) {
        this.endHeight = endHeight;
    }

    public HashLockEntryDTO status(Integer status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="A number that indicates the status.")
    @JsonProperty(value="status")
    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public HashLockEntryDTO hash(String hash) {
        this.hash = hash;
        return this;
    }

    @ApiModelProperty(example="C8FC3FB54FDDFBCE0E8C71224990124E4EEC5AD5D30E592EDFA9524669A23810", required=true, value="")
    @JsonProperty(value="hash")
    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HashLockEntryDTO hashLockEntryDTO = (HashLockEntryDTO)o;
        return Objects.equals(this.ownerAddress, hashLockEntryDTO.ownerAddress) && Objects.equals(this.mosaicId, hashLockEntryDTO.mosaicId) && Objects.equals(this.amount, hashLockEntryDTO.amount) && Objects.equals(this.endHeight, hashLockEntryDTO.endHeight) && Objects.equals(this.status, hashLockEntryDTO.status) && Objects.equals(this.hash, hashLockEntryDTO.hash);
    }

    public int hashCode() {
        return Objects.hash(this.ownerAddress, this.mosaicId, this.amount, this.endHeight, this.status, this.hash);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HashLockEntryDTO {\n");
        sb.append("    ownerAddress: ").append(this.toIndentedString(this.ownerAddress)).append("\n");
        sb.append("    mosaicId: ").append(this.toIndentedString(this.mosaicId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    endHeight: ").append(this.toIndentedString(this.endHeight)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    hash: ").append(this.toIndentedString(this.hash)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

