/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.vertx.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"hash", "totalFee", "generationHash", "stateHashSubCacheMerkleRoots", "totalTransactionsCount", "transactionsCount", "statementsCount"})
public class BlockMetaDTO {
    public static final String JSON_PROPERTY_HASH = "hash";
    private String hash;
    public static final String JSON_PROPERTY_TOTAL_FEE = "totalFee";
    private BigInteger totalFee = null;
    public static final String JSON_PROPERTY_GENERATION_HASH = "generationHash";
    private String generationHash;
    public static final String JSON_PROPERTY_STATE_HASH_SUB_CACHE_MERKLE_ROOTS = "stateHashSubCacheMerkleRoots";
    private List<String> stateHashSubCacheMerkleRoots = new ArrayList<String>();
    public static final String JSON_PROPERTY_TOTAL_TRANSACTIONS_COUNT = "totalTransactionsCount";
    private Integer totalTransactionsCount;
    public static final String JSON_PROPERTY_TRANSACTIONS_COUNT = "transactionsCount";
    private Integer transactionsCount;
    public static final String JSON_PROPERTY_STATEMENTS_COUNT = "statementsCount";
    private Integer statementsCount;

    public BlockMetaDTO hash(String hash) {
        this.hash = hash;
        return this;
    }

    @ApiModelProperty(example="C8FC3FB54FDDFBCE0E8C71224990124E4EEC5AD5D30E592EDFA9524669A23810", required=true, value="")
    @JsonProperty(value="hash")
    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public BlockMetaDTO totalFee(BigInteger totalFee) {
        this.totalFee = totalFee;
        return this;
    }

    @ApiModelProperty(example="123456", required=true, value="Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
    @JsonProperty(value="totalFee")
    public BigInteger getTotalFee() {
        return this.totalFee;
    }

    public void setTotalFee(BigInteger totalFee) {
        this.totalFee = totalFee;
    }

    public BlockMetaDTO generationHash(String generationHash) {
        this.generationHash = generationHash;
        return this;
    }

    @ApiModelProperty(example="C8FC3FB54FDDFBCE0E8C71224990124E4EEC5AD5D30E592EDFA9524669A23810", required=true, value="")
    @JsonProperty(value="generationHash")
    public String getGenerationHash() {
        return this.generationHash;
    }

    public void setGenerationHash(String generationHash) {
        this.generationHash = generationHash;
    }

    public BlockMetaDTO stateHashSubCacheMerkleRoots(List<String> stateHashSubCacheMerkleRoots) {
        this.stateHashSubCacheMerkleRoots = stateHashSubCacheMerkleRoots;
        return this;
    }

    public BlockMetaDTO addStateHashSubCacheMerkleRootsItem(String stateHashSubCacheMerkleRootsItem) {
        this.stateHashSubCacheMerkleRoots.add(stateHashSubCacheMerkleRootsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="stateHashSubCacheMerkleRoots")
    public List<String> getStateHashSubCacheMerkleRoots() {
        return this.stateHashSubCacheMerkleRoots;
    }

    public void setStateHashSubCacheMerkleRoots(List<String> stateHashSubCacheMerkleRoots) {
        this.stateHashSubCacheMerkleRoots = stateHashSubCacheMerkleRoots;
    }

    public BlockMetaDTO totalTransactionsCount(Integer totalTransactionsCount) {
        this.totalTransactionsCount = totalTransactionsCount;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="Total number of [transactions](https://docs.symbolplatform.com/concepts/transaction.html) confirmed in this block, including *embedded* transactions (i.e. transactions contained within aggregate transactions). ")
    @JsonProperty(value="totalTransactionsCount")
    public Integer getTotalTransactionsCount() {
        return this.totalTransactionsCount;
    }

    public void setTotalTransactionsCount(Integer totalTransactionsCount) {
        this.totalTransactionsCount = totalTransactionsCount;
    }

    public BlockMetaDTO transactionsCount(Integer transactionsCount) {
        this.transactionsCount = transactionsCount;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="Number of [transactions](https://docs.symbolplatform.com/concepts/transaction.html) confirmed in this block. This does not count *embedded* transactions (i.e. transactions contained within aggregate transactions). ")
    @JsonProperty(value="transactionsCount")
    public Integer getTransactionsCount() {
        return this.transactionsCount;
    }

    public void setTransactionsCount(Integer transactionsCount) {
        this.transactionsCount = transactionsCount;
    }

    public BlockMetaDTO statementsCount(Integer statementsCount) {
        this.statementsCount = statementsCount;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="Number of statements (of any kind) present in this block. Bear in mind that some of them (like [resolution statements](https://docs.symbolplatform.com/concepts/receipt.html#resolution-statement)) are triggered by transactions present in the block, but in general, [transaction statements](https://docs.symbolplatform.com/concepts/receipt.html#transaction-statement) are not. ")
    @JsonProperty(value="statementsCount")
    public Integer getStatementsCount() {
        return this.statementsCount;
    }

    public void setStatementsCount(Integer statementsCount) {
        this.statementsCount = statementsCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockMetaDTO blockMetaDTO = (BlockMetaDTO)o;
        return Objects.equals(this.hash, blockMetaDTO.hash) && Objects.equals(this.totalFee, blockMetaDTO.totalFee) && Objects.equals(this.generationHash, blockMetaDTO.generationHash) && Objects.equals(this.stateHashSubCacheMerkleRoots, blockMetaDTO.stateHashSubCacheMerkleRoots) && Objects.equals(this.totalTransactionsCount, blockMetaDTO.totalTransactionsCount) && Objects.equals(this.transactionsCount, blockMetaDTO.transactionsCount) && Objects.equals(this.statementsCount, blockMetaDTO.statementsCount);
    }

    public int hashCode() {
        return Objects.hash(this.hash, this.totalFee, this.generationHash, this.stateHashSubCacheMerkleRoots, this.totalTransactionsCount, this.transactionsCount, this.statementsCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BlockMetaDTO {\n");
        sb.append("    hash: ").append(this.toIndentedString(this.hash)).append("\n");
        sb.append("    totalFee: ").append(this.toIndentedString(this.totalFee)).append("\n");
        sb.append("    generationHash: ").append(this.toIndentedString(this.generationHash)).append("\n");
        sb.append("    stateHashSubCacheMerkleRoots: ").append(this.toIndentedString(this.stateHashSubCacheMerkleRoots)).append("\n");
        sb.append("    totalTransactionsCount: ").append(this.toIndentedString(this.totalTransactionsCount)).append("\n");
        sb.append("    transactionsCount: ").append(this.toIndentedString(this.transactionsCount)).append("\n");
        sb.append("    statementsCount: ").append(this.toIndentedString(this.statementsCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

