package io.nem.symbol.sdk.openapi.vertx.api.rxjava;

import io.nem.symbol.sdk.openapi.vertx.model.ModelError;
import io.nem.symbol.sdk.openapi.vertx.model.Order;
import io.nem.symbol.sdk.openapi.vertx.model.SecretLockInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.SecretLockPage;

import java.util.*;

import rx.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-09-25T14:18:23.319Z[UTC]")
public class SecretLockRoutesApi {

	private final io.nem.symbol.sdk.openapi.vertx.api.SecretLockRoutesApi delegate;

	public SecretLockRoutesApi(io.nem.symbol.sdk.openapi.vertx.api.SecretLockRoutesApi delegate) {
	    this.delegate = delegate;
    }

	public io.nem.symbol.sdk.openapi.vertx.api.SecretLockRoutesApi getDelegate() {
	    return delegate;
	}

    /**
     * Get secret lock information
     * Gets the secret lock for a given secret.
     * @param secret Filter by secret. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getSecretLock(String secret, Handler<AsyncResult<SecretLockInfoDTO>> resultHandler) {
        delegate.getSecretLock(secret, resultHandler);
    }

    /**
     * Get secret lock information
     * Gets the secret lock for a given secret.
     * @param secret Filter by secret. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<SecretLockInfoDTO> rxGetSecretLock(String secret) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getSecretLock(secret, fut);
        }));
    }
    /**
     * Search secret lock entries
     * Returns an array of secret locks.
     * @param address Account address. (required)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @param resultHandler Asynchronous result handler
     */
    public void searchSecretLock(String address, Integer pageSize, Integer pageNumber, String offset, Order order, Handler<AsyncResult<SecretLockPage>> resultHandler) {
        delegate.searchSecretLock(address, pageSize, pageNumber, offset, order, resultHandler);
    }

    /**
     * Search secret lock entries
     * Returns an array of secret locks.
     * @param address Account address. (required)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<SecretLockPage> rxSearchSecretLock(String address, Integer pageSize, Integer pageNumber, String offset, Order order) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.searchSecretLock(address, pageSize, pageNumber, offset, order, fut);
        }));
    }

    public static SecretLockRoutesApi newInstance(io.nem.symbol.sdk.openapi.vertx.api.SecretLockRoutesApi arg) {
        return arg != null ? new SecretLockRoutesApi(arg) : null;
    }
}
