package io.nem.symbol.sdk.openapi.vertx.api.rxjava;

import io.nem.symbol.sdk.openapi.vertx.model.ModelError;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicRestrictionEntryTypeEnum;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicRestrictionsPage;
import io.nem.symbol.sdk.openapi.vertx.model.Order;

import java.util.*;

import rx.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-09-25T14:18:23.319Z[UTC]")
public class RestrictionMosaicRoutesApi {

	private final io.nem.symbol.sdk.openapi.vertx.api.RestrictionMosaicRoutesApi delegate;

	public RestrictionMosaicRoutesApi(io.nem.symbol.sdk.openapi.vertx.api.RestrictionMosaicRoutesApi delegate) {
	    this.delegate = delegate;
    }

	public io.nem.symbol.sdk.openapi.vertx.api.RestrictionMosaicRoutesApi getDelegate() {
	    return delegate;
	}

    /**
     * Search mosaic restrictions
     * Returns an array of mosaic restrictions.
     * @param mosaicId Filter by mosaic identifier. (optional)
     * @param entryType Filter by entry type. (optional)
     * @param targetAddress Filter by target address. (optional)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @param resultHandler Asynchronous result handler
     */
    public void searchMosaicRestriction(String mosaicId, MosaicRestrictionEntryTypeEnum entryType, String targetAddress, Integer pageSize, Integer pageNumber, String offset, Order order, Handler<AsyncResult<MosaicRestrictionsPage>> resultHandler) {
        delegate.searchMosaicRestriction(mosaicId, entryType, targetAddress, pageSize, pageNumber, offset, order, resultHandler);
    }

    /**
     * Search mosaic restrictions
     * Returns an array of mosaic restrictions.
     * @param mosaicId Filter by mosaic identifier. (optional)
     * @param entryType Filter by entry type. (optional)
     * @param targetAddress Filter by target address. (optional)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MosaicRestrictionsPage> rxSearchMosaicRestriction(String mosaicId, MosaicRestrictionEntryTypeEnum entryType, String targetAddress, Integer pageSize, Integer pageNumber, String offset, Order order) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.searchMosaicRestriction(mosaicId, entryType, targetAddress, pageSize, pageNumber, offset, order, fut);
        }));
    }

    public static RestrictionMosaicRoutesApi newInstance(io.nem.symbol.sdk.openapi.vertx.api.RestrictionMosaicRoutesApi arg) {
        return arg != null ? new RestrictionMosaicRoutesApi(arg) : null;
    }
}
