package io.nem.symbol.sdk.openapi.vertx.api.rxjava;

import io.nem.symbol.sdk.openapi.vertx.model.AccountRestrictionsInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.ModelError;

import java.util.*;

import rx.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-09-25T14:18:23.319Z[UTC]")
public class RestrictionAccountRoutesApi {

	private final io.nem.symbol.sdk.openapi.vertx.api.RestrictionAccountRoutesApi delegate;

	public RestrictionAccountRoutesApi(io.nem.symbol.sdk.openapi.vertx.api.RestrictionAccountRoutesApi delegate) {
	    this.delegate = delegate;
    }

	public io.nem.symbol.sdk.openapi.vertx.api.RestrictionAccountRoutesApi getDelegate() {
	    return delegate;
	}

    /**
     * Get the account restrictions
     * Returns the account restrictions for a given address.
     * @param address Account address. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountRestrictions(String address, Handler<AsyncResult<AccountRestrictionsInfoDTO>> resultHandler) {
        delegate.getAccountRestrictions(address, resultHandler);
    }

    /**
     * Get the account restrictions
     * Returns the account restrictions for a given address.
     * @param address Account address. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<AccountRestrictionsInfoDTO> rxGetAccountRestrictions(String address) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getAccountRestrictions(address, fut);
        }));
    }

    public static RestrictionAccountRoutesApi newInstance(io.nem.symbol.sdk.openapi.vertx.api.RestrictionAccountRoutesApi arg) {
        return arg != null ? new RestrictionAccountRoutesApi(arg) : null;
    }
}
