package io.nem.symbol.sdk.openapi.vertx.api.rxjava;

import io.nem.symbol.sdk.openapi.vertx.model.AccountIds;
import io.nem.symbol.sdk.openapi.vertx.model.AccountInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.AccountOrderByEnum;
import io.nem.symbol.sdk.openapi.vertx.model.AccountPage;
import io.nem.symbol.sdk.openapi.vertx.model.ModelError;
import io.nem.symbol.sdk.openapi.vertx.model.Order;

import java.util.*;

import rx.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-09-25T14:18:23.319Z[UTC]")
public class AccountRoutesApi {

	private final io.nem.symbol.sdk.openapi.vertx.api.AccountRoutesApi delegate;

	public AccountRoutesApi(io.nem.symbol.sdk.openapi.vertx.api.AccountRoutesApi delegate) {
	    this.delegate = delegate;
    }

	public io.nem.symbol.sdk.openapi.vertx.api.AccountRoutesApi getDelegate() {
	    return delegate;
	}

    /**
     * Get account information
     * Returns the account information.
     * @param accountId Account public key or address encoded using a 32-character set. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountInfo(String accountId, Handler<AsyncResult<AccountInfoDTO>> resultHandler) {
        delegate.getAccountInfo(accountId, resultHandler);
    }

    /**
     * Get account information
     * Returns the account information.
     * @param accountId Account public key or address encoded using a 32-character set. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<AccountInfoDTO> rxGetAccountInfo(String accountId) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getAccountInfo(accountId, fut);
        }));
    }
    /**
     * Get accounts information
     * Returns the account information for an array of accounts.
     * @param accountIds  (optional)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountsInfo(AccountIds accountIds, Handler<AsyncResult<List<AccountInfoDTO>>> resultHandler) {
        delegate.getAccountsInfo(accountIds, resultHandler);
    }

    /**
     * Get accounts information
     * Returns the account information for an array of accounts.
     * @param accountIds  (optional)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<List<AccountInfoDTO>> rxGetAccountsInfo(AccountIds accountIds) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getAccountsInfo(accountIds, fut);
        }));
    }
    /**
     * Search accounts
     * Gets an array of accounts.
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @param orderBy Sort responses by the property set. If &#x60;&#x60;balance&#x60;&#x60; option is selected, the request must define the &#x60;&#x60;mosaicId&#x60;&#x60; filter.  (optional)
     * @param mosaicId Filter by mosaic identifier. (optional)
     * @param resultHandler Asynchronous result handler
     */
    public void searchAccounts(Integer pageSize, Integer pageNumber, String offset, Order order, AccountOrderByEnum orderBy, String mosaicId, Handler<AsyncResult<AccountPage>> resultHandler) {
        delegate.searchAccounts(pageSize, pageNumber, offset, order, orderBy, mosaicId, resultHandler);
    }

    /**
     * Search accounts
     * Gets an array of accounts.
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @param orderBy Sort responses by the property set. If &#x60;&#x60;balance&#x60;&#x60; option is selected, the request must define the &#x60;&#x60;mosaicId&#x60;&#x60; filter.  (optional)
     * @param mosaicId Filter by mosaic identifier. (optional)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<AccountPage> rxSearchAccounts(Integer pageSize, Integer pageNumber, String offset, Order order, AccountOrderByEnum orderBy, String mosaicId) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.searchAccounts(pageSize, pageNumber, offset, order, orderBy, mosaicId, fut);
        }));
    }

    public static AccountRoutesApi newInstance(io.nem.symbol.sdk.openapi.vertx.api.AccountRoutesApi arg) {
        return arg != null ? new AccountRoutesApi(arg) : null;
    }
}
