/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.jersey2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"targetAddress", "scopedMetadataKey", "targetNamespaceId", "valueSizeDelta", "valueSize", "value"})
public class NamespaceMetadataTransactionBodyDTO {
    public static final String JSON_PROPERTY_TARGET_ADDRESS = "targetAddress";
    private String targetAddress;
    public static final String JSON_PROPERTY_SCOPED_METADATA_KEY = "scopedMetadataKey";
    private String scopedMetadataKey;
    public static final String JSON_PROPERTY_TARGET_NAMESPACE_ID = "targetNamespaceId";
    private String targetNamespaceId;
    public static final String JSON_PROPERTY_VALUE_SIZE_DELTA = "valueSizeDelta";
    private Integer valueSizeDelta;
    public static final String JSON_PROPERTY_VALUE_SIZE = "valueSize";
    private Long valueSize;
    public static final String JSON_PROPERTY_VALUE = "value";
    private String value;

    public NamespaceMetadataTransactionBodyDTO targetAddress(String targetAddress) {
        this.targetAddress = targetAddress;
        return this;
    }

    @ApiModelProperty(example="TAOXUJOTTW3W5XTBQMQEX3SQNA6MCUVGXLXR3TA", required=true, value="Address expressed in Base32 format. If the bit 0 of byte 0 is not set (like in 0x90), then it is a regular address. Example: TAOXUJOTTW3W5XTBQMQEX3SQNA6MCUVGXLXR3TA.  Otherwise (e.g. 0x91) it represents a namespace id which starts at byte 1. Example: THBIMC3THGH5RUYAAAAAAAAAAAAAAAAAAAAAAAA ")
    @JsonProperty(value="targetAddress")
    public String getTargetAddress() {
        return this.targetAddress;
    }

    public void setTargetAddress(String targetAddress) {
        this.targetAddress = targetAddress;
    }

    public NamespaceMetadataTransactionBodyDTO scopedMetadataKey(String scopedMetadataKey) {
        this.scopedMetadataKey = scopedMetadataKey;
        return this;
    }

    @ApiModelProperty(example="0DC67FBE1CAD29E3", required=true, value="Metadata key scoped to source, target and type expressed.")
    @JsonProperty(value="scopedMetadataKey")
    public String getScopedMetadataKey() {
        return this.scopedMetadataKey;
    }

    public void setScopedMetadataKey(String scopedMetadataKey) {
        this.scopedMetadataKey = scopedMetadataKey;
    }

    public NamespaceMetadataTransactionBodyDTO targetNamespaceId(String targetNamespaceId) {
        this.targetNamespaceId = targetNamespaceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="85BBEA6CC462B244", value="Namespace identifier.")
    @JsonProperty(value="targetNamespaceId")
    public String getTargetNamespaceId() {
        return this.targetNamespaceId;
    }

    public void setTargetNamespaceId(String targetNamespaceId) {
        this.targetNamespaceId = targetNamespaceId;
    }

    public NamespaceMetadataTransactionBodyDTO valueSizeDelta(Integer valueSizeDelta) {
        this.valueSizeDelta = valueSizeDelta;
        return this;
    }

    @ApiModelProperty(required=true, value="Change in value size in bytes.")
    @JsonProperty(value="valueSizeDelta")
    public Integer getValueSizeDelta() {
        return this.valueSizeDelta;
    }

    public void setValueSizeDelta(Integer valueSizeDelta) {
        this.valueSizeDelta = valueSizeDelta;
    }

    public NamespaceMetadataTransactionBodyDTO valueSize(Long valueSize) {
        this.valueSize = valueSize;
        return this;
    }

    @ApiModelProperty(example="2222212828", required=true, value="A number that allows uint 32 values.")
    @JsonProperty(value="valueSize")
    public Long getValueSize() {
        return this.valueSize;
    }

    public void setValueSize(Long valueSize) {
        this.valueSize = valueSize;
    }

    public NamespaceMetadataTransactionBodyDTO value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(required=true, value="Metadata value. If embedded in a transaction, this is calculated as xor(previous-value, value).")
    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamespaceMetadataTransactionBodyDTO namespaceMetadataTransactionBodyDTO = (NamespaceMetadataTransactionBodyDTO)o;
        return Objects.equals(this.targetAddress, namespaceMetadataTransactionBodyDTO.targetAddress) && Objects.equals(this.scopedMetadataKey, namespaceMetadataTransactionBodyDTO.scopedMetadataKey) && Objects.equals(this.targetNamespaceId, namespaceMetadataTransactionBodyDTO.targetNamespaceId) && Objects.equals(this.valueSizeDelta, namespaceMetadataTransactionBodyDTO.valueSizeDelta) && Objects.equals(this.valueSize, namespaceMetadataTransactionBodyDTO.valueSize) && Objects.equals(this.value, namespaceMetadataTransactionBodyDTO.value);
    }

    public int hashCode() {
        return Objects.hash(this.targetAddress, this.scopedMetadataKey, this.targetNamespaceId, this.valueSizeDelta, this.valueSize, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NamespaceMetadataTransactionBodyDTO {\n");
        sb.append("    targetAddress: ").append(this.toIndentedString(this.targetAddress)).append("\n");
        sb.append("    scopedMetadataKey: ").append(this.toIndentedString(this.scopedMetadataKey)).append("\n");
        sb.append("    targetNamespaceId: ").append(this.toIndentedString(this.targetNamespaceId)).append("\n");
        sb.append("    valueSizeDelta: ").append(this.toIndentedString(this.valueSizeDelta)).append("\n");
        sb.append("    valueSize: ").append(this.toIndentedString(this.valueSize)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

