/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.jersey2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.nem.symbol.sdk.openapi.jersey2.model.MerkleTreeNodeTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Merkle tree leaf node.")
@JsonPropertyOrder(value={"type", "path", "encodedPath", "nibbleCount", "value", "leafHash"})
public class MerkleTreeLeafDTO {
    public static final String JSON_PROPERTY_TYPE = "type";
    private MerkleTreeNodeTypeEnum type;
    public static final String JSON_PROPERTY_PATH = "path";
    private String path;
    public static final String JSON_PROPERTY_ENCODED_PATH = "encodedPath";
    private String encodedPath;
    public static final String JSON_PROPERTY_NIBBLE_COUNT = "nibbleCount";
    private Integer nibbleCount;
    public static final String JSON_PROPERTY_VALUE = "value";
    private String value;
    public static final String JSON_PROPERTY_LEAF_HASH = "leafHash";
    private String leafHash;

    public MerkleTreeLeafDTO type(MerkleTreeNodeTypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    public MerkleTreeNodeTypeEnum getType() {
        return this.type;
    }

    public void setType(MerkleTreeNodeTypeEnum type) {
        this.type = type;
    }

    public MerkleTreeLeafDTO path(String path) {
        this.path = path;
        return this;
    }

    @ApiModelProperty(required=true, value="Leaf path.")
    @JsonProperty(value="path")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public MerkleTreeLeafDTO encodedPath(String encodedPath) {
        this.encodedPath = encodedPath;
        return this;
    }

    @ApiModelProperty(required=true, value="Encoded leaf path.")
    @JsonProperty(value="encodedPath")
    public String getEncodedPath() {
        return this.encodedPath;
    }

    public void setEncodedPath(String encodedPath) {
        this.encodedPath = encodedPath;
    }

    public MerkleTreeLeafDTO nibbleCount(Integer nibbleCount) {
        this.nibbleCount = nibbleCount;
        return this;
    }

    @ApiModelProperty(required=true, value="Nibble count.")
    @JsonProperty(value="nibbleCount")
    public Integer getNibbleCount() {
        return this.nibbleCount;
    }

    public void setNibbleCount(Integer nibbleCount) {
        this.nibbleCount = nibbleCount;
    }

    public MerkleTreeLeafDTO value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(required=true, value="Leaf value (sha256 hash).")
    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public MerkleTreeLeafDTO leafHash(String leafHash) {
        this.leafHash = leafHash;
        return this;
    }

    @ApiModelProperty(example="C8FC3FB54FDDFBCE0E8C71224990124E4EEC5AD5D30E592EDFA9524669A23810", required=true, value="")
    @JsonProperty(value="leafHash")
    public String getLeafHash() {
        return this.leafHash;
    }

    public void setLeafHash(String leafHash) {
        this.leafHash = leafHash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MerkleTreeLeafDTO merkleTreeLeafDTO = (MerkleTreeLeafDTO)o;
        return Objects.equals((Object)this.type, (Object)merkleTreeLeafDTO.type) && Objects.equals(this.path, merkleTreeLeafDTO.path) && Objects.equals(this.encodedPath, merkleTreeLeafDTO.encodedPath) && Objects.equals(this.nibbleCount, merkleTreeLeafDTO.nibbleCount) && Objects.equals(this.value, merkleTreeLeafDTO.value) && Objects.equals(this.leafHash, merkleTreeLeafDTO.leafHash);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.path, this.encodedPath, this.nibbleCount, this.value, this.leafHash});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MerkleTreeLeafDTO {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    encodedPath: ").append(this.toIndentedString(this.encodedPath)).append("\n");
        sb.append("    nibbleCount: ").append(this.toIndentedString(this.nibbleCount)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    leafHash: ").append(this.toIndentedString(this.leafHash)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

