/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.jersey2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.nem.symbol.sdk.openapi.jersey2.model.NetworkTypeEnum;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"signerPublicKey", "version", "network", "type", "targetAddress", "scopedMetadataKey", "targetMosaicId", "valueSizeDelta", "valueSize", "value"})
public class EmbeddedMosaicMetadataTransactionDTO {
    public static final String JSON_PROPERTY_SIGNER_PUBLIC_KEY = "signerPublicKey";
    private String signerPublicKey;
    public static final String JSON_PROPERTY_VERSION = "version";
    private Integer version;
    public static final String JSON_PROPERTY_NETWORK = "network";
    private NetworkTypeEnum network;
    public static final String JSON_PROPERTY_TYPE = "type";
    private Integer type;
    public static final String JSON_PROPERTY_TARGET_ADDRESS = "targetAddress";
    private String targetAddress;
    public static final String JSON_PROPERTY_SCOPED_METADATA_KEY = "scopedMetadataKey";
    private String scopedMetadataKey;
    public static final String JSON_PROPERTY_TARGET_MOSAIC_ID = "targetMosaicId";
    private String targetMosaicId;
    public static final String JSON_PROPERTY_VALUE_SIZE_DELTA = "valueSizeDelta";
    private Integer valueSizeDelta;
    public static final String JSON_PROPERTY_VALUE_SIZE = "valueSize";
    private Long valueSize;
    public static final String JSON_PROPERTY_VALUE = "value";
    private String value;

    public EmbeddedMosaicMetadataTransactionDTO signerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
        return this;
    }

    @ApiModelProperty(example="AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required=true, value="Public key.")
    @JsonProperty(value="signerPublicKey")
    public String getSignerPublicKey() {
        return this.signerPublicKey;
    }

    public void setSignerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
    }

    public EmbeddedMosaicMetadataTransactionDTO version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(required=true, value="Entity version.")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public EmbeddedMosaicMetadataTransactionDTO network(NetworkTypeEnum network) {
        this.network = network;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="network")
    public NetworkTypeEnum getNetwork() {
        return this.network;
    }

    public void setNetwork(NetworkTypeEnum network) {
        this.network = network;
    }

    public EmbeddedMosaicMetadataTransactionDTO type(Integer type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public EmbeddedMosaicMetadataTransactionDTO targetAddress(String targetAddress) {
        this.targetAddress = targetAddress;
        return this;
    }

    @ApiModelProperty(example="TAOXUJOTTW3W5XTBQMQEX3SQNA6MCUVGXLXR3TA", required=true, value="Address expressed in Base32 format. If the bit 0 of byte 0 is not set (like in 0x90), then it is a regular address. Example: TAOXUJOTTW3W5XTBQMQEX3SQNA6MCUVGXLXR3TA.  Otherwise (e.g. 0x91) it represents a namespace id which starts at byte 1. Example: THBIMC3THGH5RUYAAAAAAAAAAAAAAAAAAAAAAAA ")
    @JsonProperty(value="targetAddress")
    public String getTargetAddress() {
        return this.targetAddress;
    }

    public void setTargetAddress(String targetAddress) {
        this.targetAddress = targetAddress;
    }

    public EmbeddedMosaicMetadataTransactionDTO scopedMetadataKey(String scopedMetadataKey) {
        this.scopedMetadataKey = scopedMetadataKey;
        return this;
    }

    @ApiModelProperty(example="0DC67FBE1CAD29E3", required=true, value="Metadata key scoped to source, target and type expressed.")
    @JsonProperty(value="scopedMetadataKey")
    public String getScopedMetadataKey() {
        return this.scopedMetadataKey;
    }

    public void setScopedMetadataKey(String scopedMetadataKey) {
        this.scopedMetadataKey = scopedMetadataKey;
    }

    public EmbeddedMosaicMetadataTransactionDTO targetMosaicId(String targetMosaicId) {
        this.targetMosaicId = targetMosaicId;
        return this;
    }

    @ApiModelProperty(example="85BBEA6CC462B244", required=true, value="Mosaic identifier. If the most significant bit of byte 0 is set, a namespaceId (alias) is used instead of the real mosaic identifier. ")
    @JsonProperty(value="targetMosaicId")
    public String getTargetMosaicId() {
        return this.targetMosaicId;
    }

    public void setTargetMosaicId(String targetMosaicId) {
        this.targetMosaicId = targetMosaicId;
    }

    public EmbeddedMosaicMetadataTransactionDTO valueSizeDelta(Integer valueSizeDelta) {
        this.valueSizeDelta = valueSizeDelta;
        return this;
    }

    @ApiModelProperty(required=true, value="Change in value size in bytes.")
    @JsonProperty(value="valueSizeDelta")
    public Integer getValueSizeDelta() {
        return this.valueSizeDelta;
    }

    public void setValueSizeDelta(Integer valueSizeDelta) {
        this.valueSizeDelta = valueSizeDelta;
    }

    public EmbeddedMosaicMetadataTransactionDTO valueSize(Long valueSize) {
        this.valueSize = valueSize;
        return this;
    }

    @ApiModelProperty(example="2222212828", required=true, value="A number that allows uint 32 values.")
    @JsonProperty(value="valueSize")
    public Long getValueSize() {
        return this.valueSize;
    }

    public void setValueSize(Long valueSize) {
        this.valueSize = valueSize;
    }

    public EmbeddedMosaicMetadataTransactionDTO value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(required=true, value="Metadata value. If embedded in a transaction, this is calculated as xor(previous-value, value).")
    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmbeddedMosaicMetadataTransactionDTO embeddedMosaicMetadataTransactionDTO = (EmbeddedMosaicMetadataTransactionDTO)o;
        return Objects.equals(this.signerPublicKey, embeddedMosaicMetadataTransactionDTO.signerPublicKey) && Objects.equals(this.version, embeddedMosaicMetadataTransactionDTO.version) && Objects.equals((Object)this.network, (Object)embeddedMosaicMetadataTransactionDTO.network) && Objects.equals(this.type, embeddedMosaicMetadataTransactionDTO.type) && Objects.equals(this.targetAddress, embeddedMosaicMetadataTransactionDTO.targetAddress) && Objects.equals(this.scopedMetadataKey, embeddedMosaicMetadataTransactionDTO.scopedMetadataKey) && Objects.equals(this.targetMosaicId, embeddedMosaicMetadataTransactionDTO.targetMosaicId) && Objects.equals(this.valueSizeDelta, embeddedMosaicMetadataTransactionDTO.valueSizeDelta) && Objects.equals(this.valueSize, embeddedMosaicMetadataTransactionDTO.valueSize) && Objects.equals(this.value, embeddedMosaicMetadataTransactionDTO.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.signerPublicKey, this.version, this.network, this.type, this.targetAddress, this.scopedMetadataKey, this.targetMosaicId, this.valueSizeDelta, this.valueSize, this.value});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmbeddedMosaicMetadataTransactionDTO {\n");
        sb.append("    signerPublicKey: ").append(this.toIndentedString(this.signerPublicKey)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    network: ").append(this.toIndentedString((Object)this.network)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    targetAddress: ").append(this.toIndentedString(this.targetAddress)).append("\n");
        sb.append("    scopedMetadataKey: ").append(this.toIndentedString(this.scopedMetadataKey)).append("\n");
        sb.append("    targetMosaicId: ").append(this.toIndentedString(this.targetMosaicId)).append("\n");
        sb.append("    valueSizeDelta: ").append(this.toIndentedString(this.valueSizeDelta)).append("\n");
        sb.append("    valueSize: ").append(this.toIndentedString(this.valueSize)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

