/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.jersey2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"targetAddress", "scopedMetadataKey", "valueSizeDelta", "valueSize", "value"})
public class AccountMetadataTransactionBodyDTO {
    public static final String JSON_PROPERTY_TARGET_ADDRESS = "targetAddress";
    private String targetAddress;
    public static final String JSON_PROPERTY_SCOPED_METADATA_KEY = "scopedMetadataKey";
    private String scopedMetadataKey;
    public static final String JSON_PROPERTY_VALUE_SIZE_DELTA = "valueSizeDelta";
    private Integer valueSizeDelta;
    public static final String JSON_PROPERTY_VALUE_SIZE = "valueSize";
    private Long valueSize;
    public static final String JSON_PROPERTY_VALUE = "value";
    private String value;

    public AccountMetadataTransactionBodyDTO targetAddress(String targetAddress) {
        this.targetAddress = targetAddress;
        return this;
    }

    @ApiModelProperty(example="TAOXUJOTTW3W5XTBQMQEX3SQNA6MCUVGXLXR3TA", required=true, value="Address expressed in Base32 format. If the bit 0 of byte 0 is not set (like in 0x90), then it is a regular address. Example: TAOXUJOTTW3W5XTBQMQEX3SQNA6MCUVGXLXR3TA.  Otherwise (e.g. 0x91) it represents a namespace id which starts at byte 1. Example: THBIMC3THGH5RUYAAAAAAAAAAAAAAAAAAAAAAAA ")
    @JsonProperty(value="targetAddress")
    public String getTargetAddress() {
        return this.targetAddress;
    }

    public void setTargetAddress(String targetAddress) {
        this.targetAddress = targetAddress;
    }

    public AccountMetadataTransactionBodyDTO scopedMetadataKey(String scopedMetadataKey) {
        this.scopedMetadataKey = scopedMetadataKey;
        return this;
    }

    @ApiModelProperty(example="0DC67FBE1CAD29E3", required=true, value="Metadata key scoped to source, target and type expressed.")
    @JsonProperty(value="scopedMetadataKey")
    public String getScopedMetadataKey() {
        return this.scopedMetadataKey;
    }

    public void setScopedMetadataKey(String scopedMetadataKey) {
        this.scopedMetadataKey = scopedMetadataKey;
    }

    public AccountMetadataTransactionBodyDTO valueSizeDelta(Integer valueSizeDelta) {
        this.valueSizeDelta = valueSizeDelta;
        return this;
    }

    @ApiModelProperty(required=true, value="Change in value size in bytes.")
    @JsonProperty(value="valueSizeDelta")
    public Integer getValueSizeDelta() {
        return this.valueSizeDelta;
    }

    public void setValueSizeDelta(Integer valueSizeDelta) {
        this.valueSizeDelta = valueSizeDelta;
    }

    public AccountMetadataTransactionBodyDTO valueSize(Long valueSize) {
        this.valueSize = valueSize;
        return this;
    }

    @ApiModelProperty(example="2222212828", required=true, value="A number that allows uint 32 values.")
    @JsonProperty(value="valueSize")
    public Long getValueSize() {
        return this.valueSize;
    }

    public void setValueSize(Long valueSize) {
        this.valueSize = valueSize;
    }

    public AccountMetadataTransactionBodyDTO value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(required=true, value="Metadata value. If embedded in a transaction, this is calculated as xor(previous-value, value).")
    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountMetadataTransactionBodyDTO accountMetadataTransactionBodyDTO = (AccountMetadataTransactionBodyDTO)o;
        return Objects.equals(this.targetAddress, accountMetadataTransactionBodyDTO.targetAddress) && Objects.equals(this.scopedMetadataKey, accountMetadataTransactionBodyDTO.scopedMetadataKey) && Objects.equals(this.valueSizeDelta, accountMetadataTransactionBodyDTO.valueSizeDelta) && Objects.equals(this.valueSize, accountMetadataTransactionBodyDTO.valueSize) && Objects.equals(this.value, accountMetadataTransactionBodyDTO.value);
    }

    public int hashCode() {
        return Objects.hash(this.targetAddress, this.scopedMetadataKey, this.valueSizeDelta, this.valueSize, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountMetadataTransactionBodyDTO {\n");
        sb.append("    targetAddress: ").append(this.toIndentedString(this.targetAddress)).append("\n");
        sb.append("    scopedMetadataKey: ").append(this.toIndentedString(this.scopedMetadataKey)).append("\n");
        sb.append("    valueSizeDelta: ").append(this.toIndentedString(this.valueSizeDelta)).append("\n");
        sb.append("    valueSize: ").append(this.toIndentedString(this.valueSize)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

