/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.jersey2.api;

import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiException;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiResponse;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Configuration;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Pair;
import io.nem.symbol.sdk.openapi.jersey2.model.AccountsNamesDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.Addresses;
import io.nem.symbol.sdk.openapi.jersey2.model.AliasTypeEnum;
import io.nem.symbol.sdk.openapi.jersey2.model.MerkleStateInfoDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.MosaicIds;
import io.nem.symbol.sdk.openapi.jersey2.model.MosaicsNamesDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.NamespaceIds;
import io.nem.symbol.sdk.openapi.jersey2.model.NamespaceInfoDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.NamespaceNameDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.NamespacePage;
import io.nem.symbol.sdk.openapi.jersey2.model.NamespaceRegistrationTypeEnum;
import io.nem.symbol.sdk.openapi.jersey2.model.Order;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class NamespaceRoutesApi {
    private ApiClient apiClient;

    public NamespaceRoutesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public NamespaceRoutesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public AccountsNamesDTO getAccountsNames(Addresses addresses) throws ApiException {
        return this.getAccountsNamesWithHttpInfo(addresses).getData();
    }

    public ApiResponse<AccountsNamesDTO> getAccountsNamesWithHttpInfo(Addresses addresses) throws ApiException {
        Addresses localVarPostBody = addresses;
        if (addresses == null) {
            throw new ApiException(400, "Missing the required parameter 'addresses' when calling getAccountsNames");
        }
        String localVarPath = "/namespaces/account/names";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<AccountsNamesDTO> localVarReturnType = new GenericType<AccountsNamesDTO>(){};
        return this.apiClient.invokeAPI("NamespaceRoutesApi.getAccountsNames", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MosaicsNamesDTO getMosaicsNames(MosaicIds mosaicIds) throws ApiException {
        return this.getMosaicsNamesWithHttpInfo(mosaicIds).getData();
    }

    public ApiResponse<MosaicsNamesDTO> getMosaicsNamesWithHttpInfo(MosaicIds mosaicIds) throws ApiException {
        MosaicIds localVarPostBody = mosaicIds;
        if (mosaicIds == null) {
            throw new ApiException(400, "Missing the required parameter 'mosaicIds' when calling getMosaicsNames");
        }
        String localVarPath = "/namespaces/mosaic/names";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<MosaicsNamesDTO> localVarReturnType = new GenericType<MosaicsNamesDTO>(){};
        return this.apiClient.invokeAPI("NamespaceRoutesApi.getMosaicsNames", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public NamespaceInfoDTO getNamespace(String namespaceId) throws ApiException {
        return this.getNamespaceWithHttpInfo(namespaceId).getData();
    }

    public ApiResponse<NamespaceInfoDTO> getNamespaceWithHttpInfo(String namespaceId) throws ApiException {
        Object localVarPostBody = null;
        if (namespaceId == null) {
            throw new ApiException(400, "Missing the required parameter 'namespaceId' when calling getNamespace");
        }
        String localVarPath = "/namespaces/{namespaceId}".replaceAll("\\{namespaceId\\}", this.apiClient.escapeString(namespaceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<NamespaceInfoDTO> localVarReturnType = new GenericType<NamespaceInfoDTO>(){};
        return this.apiClient.invokeAPI("NamespaceRoutesApi.getNamespace", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MerkleStateInfoDTO getNamespaceMerkle(String namespaceId) throws ApiException {
        return this.getNamespaceMerkleWithHttpInfo(namespaceId).getData();
    }

    public ApiResponse<MerkleStateInfoDTO> getNamespaceMerkleWithHttpInfo(String namespaceId) throws ApiException {
        Object localVarPostBody = null;
        if (namespaceId == null) {
            throw new ApiException(400, "Missing the required parameter 'namespaceId' when calling getNamespaceMerkle");
        }
        String localVarPath = "/namespaces/{namespaceId}/merkle".replaceAll("\\{namespaceId\\}", this.apiClient.escapeString(namespaceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<MerkleStateInfoDTO> localVarReturnType = new GenericType<MerkleStateInfoDTO>(){};
        return this.apiClient.invokeAPI("NamespaceRoutesApi.getNamespaceMerkle", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<NamespaceNameDTO> getNamespacesNames(NamespaceIds namespaceIds) throws ApiException {
        return this.getNamespacesNamesWithHttpInfo(namespaceIds).getData();
    }

    public ApiResponse<List<NamespaceNameDTO>> getNamespacesNamesWithHttpInfo(NamespaceIds namespaceIds) throws ApiException {
        NamespaceIds localVarPostBody = namespaceIds;
        if (namespaceIds == null) {
            throw new ApiException(400, "Missing the required parameter 'namespaceIds' when calling getNamespacesNames");
        }
        String localVarPath = "/namespaces/names";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<List<NamespaceNameDTO>> localVarReturnType = new GenericType<List<NamespaceNameDTO>>(){};
        return this.apiClient.invokeAPI("NamespaceRoutesApi.getNamespacesNames", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public NamespacePage searchNamespaces(String ownerAddress, NamespaceRegistrationTypeEnum registrationType, String level0, AliasTypeEnum aliasType, Integer pageSize, Integer pageNumber, String offset, Order order) throws ApiException {
        return this.searchNamespacesWithHttpInfo(ownerAddress, registrationType, level0, aliasType, pageSize, pageNumber, offset, order).getData();
    }

    public ApiResponse<NamespacePage> searchNamespacesWithHttpInfo(String ownerAddress, NamespaceRegistrationTypeEnum registrationType, String level0, AliasTypeEnum aliasType, Integer pageSize, Integer pageNumber, String offset, Order order) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/namespaces";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "ownerAddress", ownerAddress));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "registrationType", (Object)registrationType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "level0", level0));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "aliasType", (Object)aliasType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageNumber", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "order", (Object)order));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<NamespacePage> localVarReturnType = new GenericType<NamespacePage>(){};
        return this.apiClient.invokeAPI("NamespaceRoutesApi.searchNamespaces", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

