/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.jersey2.api;

import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiException;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiResponse;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Configuration;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Pair;
import io.nem.symbol.sdk.openapi.jersey2.model.MerkleStateInfoDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.MosaicIds;
import io.nem.symbol.sdk.openapi.jersey2.model.MosaicInfoDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.MosaicPage;
import io.nem.symbol.sdk.openapi.jersey2.model.Order;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class MosaicRoutesApi {
    private ApiClient apiClient;

    public MosaicRoutesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MosaicRoutesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public MosaicInfoDTO getMosaic(String mosaicId) throws ApiException {
        return this.getMosaicWithHttpInfo(mosaicId).getData();
    }

    public ApiResponse<MosaicInfoDTO> getMosaicWithHttpInfo(String mosaicId) throws ApiException {
        Object localVarPostBody = null;
        if (mosaicId == null) {
            throw new ApiException(400, "Missing the required parameter 'mosaicId' when calling getMosaic");
        }
        String localVarPath = "/mosaics/{mosaicId}".replaceAll("\\{mosaicId\\}", this.apiClient.escapeString(mosaicId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<MosaicInfoDTO> localVarReturnType = new GenericType<MosaicInfoDTO>(){};
        return this.apiClient.invokeAPI("MosaicRoutesApi.getMosaic", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MerkleStateInfoDTO getMosaicMerkle(String mosaicId) throws ApiException {
        return this.getMosaicMerkleWithHttpInfo(mosaicId).getData();
    }

    public ApiResponse<MerkleStateInfoDTO> getMosaicMerkleWithHttpInfo(String mosaicId) throws ApiException {
        Object localVarPostBody = null;
        if (mosaicId == null) {
            throw new ApiException(400, "Missing the required parameter 'mosaicId' when calling getMosaicMerkle");
        }
        String localVarPath = "/mosaics/{mosaicId}/merkle".replaceAll("\\{mosaicId\\}", this.apiClient.escapeString(mosaicId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<MerkleStateInfoDTO> localVarReturnType = new GenericType<MerkleStateInfoDTO>(){};
        return this.apiClient.invokeAPI("MosaicRoutesApi.getMosaicMerkle", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<MosaicInfoDTO> getMosaics(MosaicIds mosaicIds) throws ApiException {
        return this.getMosaicsWithHttpInfo(mosaicIds).getData();
    }

    public ApiResponse<List<MosaicInfoDTO>> getMosaicsWithHttpInfo(MosaicIds mosaicIds) throws ApiException {
        MosaicIds localVarPostBody = mosaicIds;
        if (mosaicIds == null) {
            throw new ApiException(400, "Missing the required parameter 'mosaicIds' when calling getMosaics");
        }
        String localVarPath = "/mosaics";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<List<MosaicInfoDTO>> localVarReturnType = new GenericType<List<MosaicInfoDTO>>(){};
        return this.apiClient.invokeAPI("MosaicRoutesApi.getMosaics", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MosaicPage searchMosaics(String ownerAddress, Integer pageSize, Integer pageNumber, String offset, Order order) throws ApiException {
        return this.searchMosaicsWithHttpInfo(ownerAddress, pageSize, pageNumber, offset, order).getData();
    }

    public ApiResponse<MosaicPage> searchMosaicsWithHttpInfo(String ownerAddress, Integer pageSize, Integer pageNumber, String offset, Order order) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/mosaics";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "ownerAddress", ownerAddress));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageNumber", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "order", (Object)order));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<MosaicPage> localVarReturnType = new GenericType<MosaicPage>(){};
        return this.apiClient.invokeAPI("MosaicRoutesApi.searchMosaics", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

