/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.jersey2.api;

import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiException;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiResponse;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Configuration;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Pair;
import io.nem.symbol.sdk.openapi.jersey2.model.HashLockInfoDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.HashLockPage;
import io.nem.symbol.sdk.openapi.jersey2.model.MerkleStateInfoDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.Order;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class HashLockRoutesApi {
    private ApiClient apiClient;

    public HashLockRoutesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public HashLockRoutesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public HashLockInfoDTO getHashLock(String hash) throws ApiException {
        return this.getHashLockWithHttpInfo(hash).getData();
    }

    public ApiResponse<HashLockInfoDTO> getHashLockWithHttpInfo(String hash) throws ApiException {
        Object localVarPostBody = null;
        if (hash == null) {
            throw new ApiException(400, "Missing the required parameter 'hash' when calling getHashLock");
        }
        String localVarPath = "/lock/hash/{hash}".replaceAll("\\{hash\\}", this.apiClient.escapeString(hash.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<HashLockInfoDTO> localVarReturnType = new GenericType<HashLockInfoDTO>(){};
        return this.apiClient.invokeAPI("HashLockRoutesApi.getHashLock", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MerkleStateInfoDTO getHashLockMerkle(String hash) throws ApiException {
        return this.getHashLockMerkleWithHttpInfo(hash).getData();
    }

    public ApiResponse<MerkleStateInfoDTO> getHashLockMerkleWithHttpInfo(String hash) throws ApiException {
        Object localVarPostBody = null;
        if (hash == null) {
            throw new ApiException(400, "Missing the required parameter 'hash' when calling getHashLockMerkle");
        }
        String localVarPath = "/lock/hash/{hash}/merkle".replaceAll("\\{hash\\}", this.apiClient.escapeString(hash.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<MerkleStateInfoDTO> localVarReturnType = new GenericType<MerkleStateInfoDTO>(){};
        return this.apiClient.invokeAPI("HashLockRoutesApi.getHashLockMerkle", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public HashLockPage searchHashLock(String address, Integer pageSize, Integer pageNumber, String offset, Order order) throws ApiException {
        return this.searchHashLockWithHttpInfo(address, pageSize, pageNumber, offset, order).getData();
    }

    public ApiResponse<HashLockPage> searchHashLockWithHttpInfo(String address, Integer pageSize, Integer pageNumber, String offset, Order order) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/lock/hash";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "address", address));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageNumber", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "order", (Object)order));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<HashLockPage> localVarReturnType = new GenericType<HashLockPage>(){};
        return this.apiClient.invokeAPI("HashLockRoutesApi.searchHashLock", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

