/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.jersey2.api;

import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiException;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiResponse;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Configuration;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Pair;
import io.nem.symbol.sdk.openapi.jersey2.model.BlockInfoDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.BlockOrderByEnum;
import io.nem.symbol.sdk.openapi.jersey2.model.BlockPage;
import io.nem.symbol.sdk.openapi.jersey2.model.MerkleProofInfoDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.Order;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class BlockRoutesApi {
    private ApiClient apiClient;

    public BlockRoutesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public BlockRoutesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public BlockInfoDTO getBlockByHeight(BigInteger height) throws ApiException {
        return this.getBlockByHeightWithHttpInfo(height).getData();
    }

    public ApiResponse<BlockInfoDTO> getBlockByHeightWithHttpInfo(BigInteger height) throws ApiException {
        Object localVarPostBody = null;
        if (height == null) {
            throw new ApiException(400, "Missing the required parameter 'height' when calling getBlockByHeight");
        }
        String localVarPath = "/blocks/{height}".replaceAll("\\{height\\}", this.apiClient.escapeString(height.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<BlockInfoDTO> localVarReturnType = new GenericType<BlockInfoDTO>(){};
        return this.apiClient.invokeAPI("BlockRoutesApi.getBlockByHeight", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MerkleProofInfoDTO getMerkleReceipts(BigInteger height, String hash) throws ApiException {
        return this.getMerkleReceiptsWithHttpInfo(height, hash).getData();
    }

    public ApiResponse<MerkleProofInfoDTO> getMerkleReceiptsWithHttpInfo(BigInteger height, String hash) throws ApiException {
        Object localVarPostBody = null;
        if (height == null) {
            throw new ApiException(400, "Missing the required parameter 'height' when calling getMerkleReceipts");
        }
        if (hash == null) {
            throw new ApiException(400, "Missing the required parameter 'hash' when calling getMerkleReceipts");
        }
        String localVarPath = "/blocks/{height}/statements/{hash}/merkle".replaceAll("\\{height\\}", this.apiClient.escapeString(height.toString())).replaceAll("\\{hash\\}", this.apiClient.escapeString(hash.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<MerkleProofInfoDTO> localVarReturnType = new GenericType<MerkleProofInfoDTO>(){};
        return this.apiClient.invokeAPI("BlockRoutesApi.getMerkleReceipts", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MerkleProofInfoDTO getMerkleTransaction(BigInteger height, String hash) throws ApiException {
        return this.getMerkleTransactionWithHttpInfo(height, hash).getData();
    }

    public ApiResponse<MerkleProofInfoDTO> getMerkleTransactionWithHttpInfo(BigInteger height, String hash) throws ApiException {
        Object localVarPostBody = null;
        if (height == null) {
            throw new ApiException(400, "Missing the required parameter 'height' when calling getMerkleTransaction");
        }
        if (hash == null) {
            throw new ApiException(400, "Missing the required parameter 'hash' when calling getMerkleTransaction");
        }
        String localVarPath = "/blocks/{height}/transactions/{hash}/merkle".replaceAll("\\{height\\}", this.apiClient.escapeString(height.toString())).replaceAll("\\{hash\\}", this.apiClient.escapeString(hash.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<MerkleProofInfoDTO> localVarReturnType = new GenericType<MerkleProofInfoDTO>(){};
        return this.apiClient.invokeAPI("BlockRoutesApi.getMerkleTransaction", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BlockPage searchBlocks(String signerPublicKey, String beneficiaryAddress, Integer pageSize, Integer pageNumber, String offset, Order order, BlockOrderByEnum orderBy) throws ApiException {
        return this.searchBlocksWithHttpInfo(signerPublicKey, beneficiaryAddress, pageSize, pageNumber, offset, order, orderBy).getData();
    }

    public ApiResponse<BlockPage> searchBlocksWithHttpInfo(String signerPublicKey, String beneficiaryAddress, Integer pageSize, Integer pageNumber, String offset, Order order, BlockOrderByEnum orderBy) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/blocks";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "signerPublicKey", signerPublicKey));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "beneficiaryAddress", beneficiaryAddress));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageNumber", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "order", (Object)order));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "orderBy", (Object)orderBy));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<BlockPage> localVarReturnType = new GenericType<BlockPage>(){};
        return this.apiClient.invokeAPI("BlockRoutesApi.searchBlocks", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

