/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest
 *
 * The version of the OpenAPI document: 1.0.2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.symbol.sdk.openapi.jersey2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.nem.symbol.sdk.openapi.jersey2.model.AggregateTransactionBodyExtendedDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.CosignatureDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.EmbeddedTransactionInfoDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.NetworkTypeEnum;
import io.nem.symbol.sdk.openapi.jersey2.model.TransactionDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Transaction to combine multiple transactions together.
 */
@ApiModel(description = "Transaction to combine multiple transactions together.")
@JsonPropertyOrder({
  AggregateTransactionExtendedDTO.JSON_PROPERTY_SIZE,
  AggregateTransactionExtendedDTO.JSON_PROPERTY_SIGNATURE,
  AggregateTransactionExtendedDTO.JSON_PROPERTY_SIGNER_PUBLIC_KEY,
  AggregateTransactionExtendedDTO.JSON_PROPERTY_VERSION,
  AggregateTransactionExtendedDTO.JSON_PROPERTY_NETWORK,
  AggregateTransactionExtendedDTO.JSON_PROPERTY_TYPE,
  AggregateTransactionExtendedDTO.JSON_PROPERTY_MAX_FEE,
  AggregateTransactionExtendedDTO.JSON_PROPERTY_DEADLINE,
  AggregateTransactionExtendedDTO.JSON_PROPERTY_TRANSACTIONS_HASH,
  AggregateTransactionExtendedDTO.JSON_PROPERTY_COSIGNATURES,
  AggregateTransactionExtendedDTO.JSON_PROPERTY_TRANSACTIONS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2021-10-19T21:34:53.510Z[UTC]")
public class AggregateTransactionExtendedDTO {
  public static final String JSON_PROPERTY_SIZE = "size";
  private Long size;

  public static final String JSON_PROPERTY_SIGNATURE = "signature";
  private String signature;

  public static final String JSON_PROPERTY_SIGNER_PUBLIC_KEY = "signerPublicKey";
  private String signerPublicKey;

  public static final String JSON_PROPERTY_VERSION = "version";
  private Integer version;

  public static final String JSON_PROPERTY_NETWORK = "network";
  private NetworkTypeEnum network;

  public static final String JSON_PROPERTY_TYPE = "type";
  private Integer type;

  public static final String JSON_PROPERTY_MAX_FEE = "maxFee";
  private java.math.BigInteger maxFee = null;

  public static final String JSON_PROPERTY_DEADLINE = "deadline";
  private java.math.BigInteger deadline = null;

  public static final String JSON_PROPERTY_TRANSACTIONS_HASH = "transactionsHash";
  private String transactionsHash;

  public static final String JSON_PROPERTY_COSIGNATURES = "cosignatures";
  private List<CosignatureDTO> cosignatures = new ArrayList<>();

  public static final String JSON_PROPERTY_TRANSACTIONS = "transactions";
  private List<EmbeddedTransactionInfoDTO> transactions = new ArrayList<>();


  public AggregateTransactionExtendedDTO size(Long size) {
    
    this.size = size;
    return this;
  }

   /**
   * A number that allows uint 32 values.
   * @return size
  **/
  @ApiModelProperty(example = "2222212828", required = true, value = "A number that allows uint 32 values.")
  @JsonProperty(JSON_PROPERTY_SIZE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Long getSize() {
    return size;
  }


  public void setSize(Long size) {
    this.size = size;
  }


  public AggregateTransactionExtendedDTO signature(String signature) {
    
    this.signature = signature;
    return this;
  }

   /**
   * Entity&#39;s signature generated by the signer.
   * @return signature
  **/
  @ApiModelProperty(example = "4B408BBEDF25F2AC8E0E44A6E51E3CCBA03885902055F75EB9FF50433532CA44BF9175FDA7502EEE2FC1617126E453A2BD692BAFDAAF06BC8EDEBA7961B3730D", required = true, value = "Entity's signature generated by the signer.")
  @JsonProperty(JSON_PROPERTY_SIGNATURE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSignature() {
    return signature;
  }


  public void setSignature(String signature) {
    this.signature = signature;
  }


  public AggregateTransactionExtendedDTO signerPublicKey(String signerPublicKey) {
    
    this.signerPublicKey = signerPublicKey;
    return this;
  }

   /**
   * Public key.
   * @return signerPublicKey
  **/
  @ApiModelProperty(example = "AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required = true, value = "Public key.")
  @JsonProperty(JSON_PROPERTY_SIGNER_PUBLIC_KEY)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSignerPublicKey() {
    return signerPublicKey;
  }


  public void setSignerPublicKey(String signerPublicKey) {
    this.signerPublicKey = signerPublicKey;
  }


  public AggregateTransactionExtendedDTO version(Integer version) {
    
    this.version = version;
    return this;
  }

   /**
   * Entity version.
   * @return version
  **/
  @ApiModelProperty(required = true, value = "Entity version.")
  @JsonProperty(JSON_PROPERTY_VERSION)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getVersion() {
    return version;
  }


  public void setVersion(Integer version) {
    this.version = version;
  }


  public AggregateTransactionExtendedDTO network(NetworkTypeEnum network) {
    
    this.network = network;
    return this;
  }

   /**
   * Get network
   * @return network
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_NETWORK)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public NetworkTypeEnum getNetwork() {
    return network;
  }


  public void setNetwork(NetworkTypeEnum network) {
    this.network = network;
  }


  public AggregateTransactionExtendedDTO type(Integer type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TYPE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getType() {
    return type;
  }


  public void setType(Integer type) {
    this.type = type;
  }


  public AggregateTransactionExtendedDTO maxFee(java.math.BigInteger maxFee) {
    
    this.maxFee = maxFee;
    return this;
  }

   /**
   * Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).
   * @return maxFee
  **/
  @ApiModelProperty(example = "123456", required = true, value = "Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
  @JsonProperty(JSON_PROPERTY_MAX_FEE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getMaxFee() {
    return maxFee;
  }


  public void setMaxFee(java.math.BigInteger maxFee) {
    this.maxFee = maxFee;
  }


  public AggregateTransactionExtendedDTO deadline(java.math.BigInteger deadline) {
    
    this.deadline = deadline;
    return this;
  }

   /**
   * Duration expressed in number of blocks.
   * @return deadline
  **/
  @ApiModelProperty(example = "200", required = true, value = "Duration expressed in number of blocks.")
  @JsonProperty(JSON_PROPERTY_DEADLINE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getDeadline() {
    return deadline;
  }


  public void setDeadline(java.math.BigInteger deadline) {
    this.deadline = deadline;
  }


  public AggregateTransactionExtendedDTO transactionsHash(String transactionsHash) {
    
    this.transactionsHash = transactionsHash;
    return this;
  }

   /**
   * Get transactionsHash
   * @return transactionsHash
  **/
  @ApiModelProperty(example = "C8FC3FB54FDDFBCE0E8C71224990124E4EEC5AD5D30E592EDFA9524669A23810", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TRANSACTIONS_HASH)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTransactionsHash() {
    return transactionsHash;
  }


  public void setTransactionsHash(String transactionsHash) {
    this.transactionsHash = transactionsHash;
  }


  public AggregateTransactionExtendedDTO cosignatures(List<CosignatureDTO> cosignatures) {
    
    this.cosignatures = cosignatures;
    return this;
  }

  public AggregateTransactionExtendedDTO addCosignaturesItem(CosignatureDTO cosignaturesItem) {
    this.cosignatures.add(cosignaturesItem);
    return this;
  }

   /**
   * Array of transaction cosignatures.
   * @return cosignatures
  **/
  @ApiModelProperty(required = true, value = "Array of transaction cosignatures.")
  @JsonProperty(JSON_PROPERTY_COSIGNATURES)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<CosignatureDTO> getCosignatures() {
    return cosignatures;
  }


  public void setCosignatures(List<CosignatureDTO> cosignatures) {
    this.cosignatures = cosignatures;
  }


  public AggregateTransactionExtendedDTO transactions(List<EmbeddedTransactionInfoDTO> transactions) {
    
    this.transactions = transactions;
    return this;
  }

  public AggregateTransactionExtendedDTO addTransactionsItem(EmbeddedTransactionInfoDTO transactionsItem) {
    this.transactions.add(transactionsItem);
    return this;
  }

   /**
   * Array of transactions initiated by different accounts.
   * @return transactions
  **/
  @ApiModelProperty(required = true, value = "Array of transactions initiated by different accounts.")
  @JsonProperty(JSON_PROPERTY_TRANSACTIONS)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<EmbeddedTransactionInfoDTO> getTransactions() {
    return transactions;
  }


  public void setTransactions(List<EmbeddedTransactionInfoDTO> transactions) {
    this.transactions = transactions;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AggregateTransactionExtendedDTO aggregateTransactionExtendedDTO = (AggregateTransactionExtendedDTO) o;
    return Objects.equals(this.size, aggregateTransactionExtendedDTO.size) &&
        Objects.equals(this.signature, aggregateTransactionExtendedDTO.signature) &&
        Objects.equals(this.signerPublicKey, aggregateTransactionExtendedDTO.signerPublicKey) &&
        Objects.equals(this.version, aggregateTransactionExtendedDTO.version) &&
        Objects.equals(this.network, aggregateTransactionExtendedDTO.network) &&
        Objects.equals(this.type, aggregateTransactionExtendedDTO.type) &&
        Objects.equals(this.maxFee, aggregateTransactionExtendedDTO.maxFee) &&
        Objects.equals(this.deadline, aggregateTransactionExtendedDTO.deadline) &&
        Objects.equals(this.transactionsHash, aggregateTransactionExtendedDTO.transactionsHash) &&
        Objects.equals(this.cosignatures, aggregateTransactionExtendedDTO.cosignatures) &&
        Objects.equals(this.transactions, aggregateTransactionExtendedDTO.transactions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(size, signature, signerPublicKey, version, network, type, maxFee, deadline, transactionsHash, cosignatures, transactions);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AggregateTransactionExtendedDTO {\n");
    sb.append("    size: ").append(toIndentedString(size)).append("\n");
    sb.append("    signature: ").append(toIndentedString(signature)).append("\n");
    sb.append("    signerPublicKey: ").append(toIndentedString(signerPublicKey)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    network: ").append(toIndentedString(network)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    maxFee: ").append(toIndentedString(maxFee)).append("\n");
    sb.append("    deadline: ").append(toIndentedString(deadline)).append("\n");
    sb.append("    transactionsHash: ").append(toIndentedString(transactionsHash)).append("\n");
    sb.append("    cosignatures: ").append(toIndentedString(cosignatures)).append("\n");
    sb.append("    transactions: ").append(toIndentedString(transactions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

