/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest 1.2.0
 *
 * The version of the OpenAPI document: 0.9.6
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.symbol.sdk.openapi.jersey2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.nem.symbol.sdk.openapi.jersey2.model.RolesTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * NodeInfoDTO
 */
@JsonPropertyOrder({
  NodeInfoDTO.JSON_PROPERTY_VERSION,
  NodeInfoDTO.JSON_PROPERTY_PUBLIC_KEY,
  NodeInfoDTO.JSON_PROPERTY_NETWORK_GENERATION_HASH_SEED,
  NodeInfoDTO.JSON_PROPERTY_ROLES,
  NodeInfoDTO.JSON_PROPERTY_PORT,
  NodeInfoDTO.JSON_PROPERTY_NETWORK_IDENTIFIER,
  NodeInfoDTO.JSON_PROPERTY_FRIENDLY_NAME,
  NodeInfoDTO.JSON_PROPERTY_HOST
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-08-14T13:43:37.324Z[UTC]")
public class NodeInfoDTO {
  public static final String JSON_PROPERTY_VERSION = "version";
  private Integer version;

  public static final String JSON_PROPERTY_PUBLIC_KEY = "publicKey";
  private String publicKey;

  public static final String JSON_PROPERTY_NETWORK_GENERATION_HASH_SEED = "networkGenerationHashSeed";
  private String networkGenerationHashSeed;

  public static final String JSON_PROPERTY_ROLES = "roles";
  private RolesTypeEnum roles;

  public static final String JSON_PROPERTY_PORT = "port";
  private Integer port;

  public static final String JSON_PROPERTY_NETWORK_IDENTIFIER = "networkIdentifier";
  private Integer networkIdentifier;

  public static final String JSON_PROPERTY_FRIENDLY_NAME = "friendlyName";
  private String friendlyName;

  public static final String JSON_PROPERTY_HOST = "host";
  private String host;


  public NodeInfoDTO version(Integer version) {
    
    this.version = version;
    return this;
  }

   /**
   * Version of the application.
   * @return version
  **/
  @ApiModelProperty(example = "0", required = true, value = "Version of the application.")
  @JsonProperty(JSON_PROPERTY_VERSION)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getVersion() {
    return version;
  }


  public void setVersion(Integer version) {
    this.version = version;
  }


  public NodeInfoDTO publicKey(String publicKey) {
    
    this.publicKey = publicKey;
    return this;
  }

   /**
   * Public key.
   * @return publicKey
  **/
  @ApiModelProperty(example = "AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required = true, value = "Public key.")
  @JsonProperty(JSON_PROPERTY_PUBLIC_KEY)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getPublicKey() {
    return publicKey;
  }


  public void setPublicKey(String publicKey) {
    this.publicKey = publicKey;
  }


  public NodeInfoDTO networkGenerationHashSeed(String networkGenerationHashSeed) {
    
    this.networkGenerationHashSeed = networkGenerationHashSeed;
    return this;
  }

   /**
   * Get networkGenerationHashSeed
   * @return networkGenerationHashSeed
  **/
  @ApiModelProperty(example = "C8FC3FB54FDDFBCE0E8C71224990124E4EEC5AD5D30E592EDFA9524669A23810", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_NETWORK_GENERATION_HASH_SEED)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getNetworkGenerationHashSeed() {
    return networkGenerationHashSeed;
  }


  public void setNetworkGenerationHashSeed(String networkGenerationHashSeed) {
    this.networkGenerationHashSeed = networkGenerationHashSeed;
  }


  public NodeInfoDTO roles(RolesTypeEnum roles) {
    
    this.roles = roles;
    return this;
  }

   /**
   * Get roles
   * @return roles
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_ROLES)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public RolesTypeEnum getRoles() {
    return roles;
  }


  public void setRoles(RolesTypeEnum roles) {
    this.roles = roles;
  }


  public NodeInfoDTO port(Integer port) {
    
    this.port = port;
    return this;
  }

   /**
   * Port used for the communication.
   * @return port
  **/
  @ApiModelProperty(example = "7900", required = true, value = "Port used for the communication.")
  @JsonProperty(JSON_PROPERTY_PORT)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getPort() {
    return port;
  }


  public void setPort(Integer port) {
    this.port = port;
  }


  public NodeInfoDTO networkIdentifier(Integer networkIdentifier) {
    
    this.networkIdentifier = networkIdentifier;
    return this;
  }

   /**
   * Get networkIdentifier
   * @return networkIdentifier
  **/
  @ApiModelProperty(example = "144", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_NETWORK_IDENTIFIER)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getNetworkIdentifier() {
    return networkIdentifier;
  }


  public void setNetworkIdentifier(Integer networkIdentifier) {
    this.networkIdentifier = networkIdentifier;
  }


  public NodeInfoDTO friendlyName(String friendlyName) {
    
    this.friendlyName = friendlyName;
    return this;
  }

   /**
   * Node friendly name.
   * @return friendlyName
  **/
  @ApiModelProperty(example = "api-node-0", required = true, value = "Node friendly name.")
  @JsonProperty(JSON_PROPERTY_FRIENDLY_NAME)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getFriendlyName() {
    return friendlyName;
  }


  public void setFriendlyName(String friendlyName) {
    this.friendlyName = friendlyName;
  }


  public NodeInfoDTO host(String host) {
    
    this.host = host;
    return this;
  }

   /**
   * Node IP address.
   * @return host
  **/
  @ApiModelProperty(example = "127.0.0.1", required = true, value = "Node IP address.")
  @JsonProperty(JSON_PROPERTY_HOST)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getHost() {
    return host;
  }


  public void setHost(String host) {
    this.host = host;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    NodeInfoDTO nodeInfoDTO = (NodeInfoDTO) o;
    return Objects.equals(this.version, nodeInfoDTO.version) &&
        Objects.equals(this.publicKey, nodeInfoDTO.publicKey) &&
        Objects.equals(this.networkGenerationHashSeed, nodeInfoDTO.networkGenerationHashSeed) &&
        Objects.equals(this.roles, nodeInfoDTO.roles) &&
        Objects.equals(this.port, nodeInfoDTO.port) &&
        Objects.equals(this.networkIdentifier, nodeInfoDTO.networkIdentifier) &&
        Objects.equals(this.friendlyName, nodeInfoDTO.friendlyName) &&
        Objects.equals(this.host, nodeInfoDTO.host);
  }

  @Override
  public int hashCode() {
    return Objects.hash(version, publicKey, networkGenerationHashSeed, roles, port, networkIdentifier, friendlyName, host);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class NodeInfoDTO {\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    publicKey: ").append(toIndentedString(publicKey)).append("\n");
    sb.append("    networkGenerationHashSeed: ").append(toIndentedString(networkGenerationHashSeed)).append("\n");
    sb.append("    roles: ").append(toIndentedString(roles)).append("\n");
    sb.append("    port: ").append(toIndentedString(port)).append("\n");
    sb.append("    networkIdentifier: ").append(toIndentedString(networkIdentifier)).append("\n");
    sb.append("    friendlyName: ").append(toIndentedString(friendlyName)).append("\n");
    sb.append("    host: ").append(toIndentedString(host)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

