/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest 1.2.0
 *
 * The version of the OpenAPI document: 0.9.6
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.symbol.sdk.openapi.jersey2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.nem.symbol.sdk.openapi.jersey2.model.NamespaceMetadataTransactionBodyDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.NetworkTypeEnum;
import io.nem.symbol.sdk.openapi.jersey2.model.TransactionDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Transaction to create or modify a multisig account.
 */
@ApiModel(description = "Transaction to create or modify a multisig account.")
@JsonPropertyOrder({
  NamespaceMetadataTransactionDTO.JSON_PROPERTY_SIZE,
  NamespaceMetadataTransactionDTO.JSON_PROPERTY_SIGNATURE,
  NamespaceMetadataTransactionDTO.JSON_PROPERTY_SIGNER_PUBLIC_KEY,
  NamespaceMetadataTransactionDTO.JSON_PROPERTY_VERSION,
  NamespaceMetadataTransactionDTO.JSON_PROPERTY_NETWORK,
  NamespaceMetadataTransactionDTO.JSON_PROPERTY_TYPE,
  NamespaceMetadataTransactionDTO.JSON_PROPERTY_MAX_FEE,
  NamespaceMetadataTransactionDTO.JSON_PROPERTY_DEADLINE,
  NamespaceMetadataTransactionDTO.JSON_PROPERTY_TARGET_ADDRESS,
  NamespaceMetadataTransactionDTO.JSON_PROPERTY_SCOPED_METADATA_KEY,
  NamespaceMetadataTransactionDTO.JSON_PROPERTY_TARGET_NAMESPACE_ID,
  NamespaceMetadataTransactionDTO.JSON_PROPERTY_VALUE_SIZE_DELTA,
  NamespaceMetadataTransactionDTO.JSON_PROPERTY_VALUE_SIZE,
  NamespaceMetadataTransactionDTO.JSON_PROPERTY_VALUE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-08-14T13:43:37.324Z[UTC]")
public class NamespaceMetadataTransactionDTO {
  public static final String JSON_PROPERTY_SIZE = "size";
  private Long size;

  public static final String JSON_PROPERTY_SIGNATURE = "signature";
  private String signature;

  public static final String JSON_PROPERTY_SIGNER_PUBLIC_KEY = "signerPublicKey";
  private String signerPublicKey;

  public static final String JSON_PROPERTY_VERSION = "version";
  private Integer version;

  public static final String JSON_PROPERTY_NETWORK = "network";
  private NetworkTypeEnum network;

  public static final String JSON_PROPERTY_TYPE = "type";
  private Integer type;

  public static final String JSON_PROPERTY_MAX_FEE = "maxFee";
  private java.math.BigInteger maxFee = null;

  public static final String JSON_PROPERTY_DEADLINE = "deadline";
  private java.math.BigInteger deadline = null;

  public static final String JSON_PROPERTY_TARGET_ADDRESS = "targetAddress";
  private String targetAddress;

  public static final String JSON_PROPERTY_SCOPED_METADATA_KEY = "scopedMetadataKey";
  private String scopedMetadataKey;

  public static final String JSON_PROPERTY_TARGET_NAMESPACE_ID = "targetNamespaceId";
  private String targetNamespaceId;

  public static final String JSON_PROPERTY_VALUE_SIZE_DELTA = "valueSizeDelta";
  private Integer valueSizeDelta;

  public static final String JSON_PROPERTY_VALUE_SIZE = "valueSize";
  private Long valueSize;

  public static final String JSON_PROPERTY_VALUE = "value";
  private String value;


  public NamespaceMetadataTransactionDTO size(Long size) {
    
    this.size = size;
    return this;
  }

   /**
   * A number that allows uint 32 values.
   * @return size
  **/
  @ApiModelProperty(example = "2222212828", required = true, value = "A number that allows uint 32 values.")
  @JsonProperty(JSON_PROPERTY_SIZE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Long getSize() {
    return size;
  }


  public void setSize(Long size) {
    this.size = size;
  }


  public NamespaceMetadataTransactionDTO signature(String signature) {
    
    this.signature = signature;
    return this;
  }

   /**
   * Entity&#39;s signature generated by the signer.
   * @return signature
  **/
  @ApiModelProperty(example = "4B408BBEDF25F2AC8E0E44A6E51E3CCBA03885902055F75EB9FF50433532CA44BF9175FDA7502EEE2FC1617126E453A2BD692BAFDAAF06BC8EDEBA7961B3730D", required = true, value = "Entity's signature generated by the signer.")
  @JsonProperty(JSON_PROPERTY_SIGNATURE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSignature() {
    return signature;
  }


  public void setSignature(String signature) {
    this.signature = signature;
  }


  public NamespaceMetadataTransactionDTO signerPublicKey(String signerPublicKey) {
    
    this.signerPublicKey = signerPublicKey;
    return this;
  }

   /**
   * Public key.
   * @return signerPublicKey
  **/
  @ApiModelProperty(example = "AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required = true, value = "Public key.")
  @JsonProperty(JSON_PROPERTY_SIGNER_PUBLIC_KEY)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSignerPublicKey() {
    return signerPublicKey;
  }


  public void setSignerPublicKey(String signerPublicKey) {
    this.signerPublicKey = signerPublicKey;
  }


  public NamespaceMetadataTransactionDTO version(Integer version) {
    
    this.version = version;
    return this;
  }

   /**
   * Entity version.
   * @return version
  **/
  @ApiModelProperty(required = true, value = "Entity version.")
  @JsonProperty(JSON_PROPERTY_VERSION)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getVersion() {
    return version;
  }


  public void setVersion(Integer version) {
    this.version = version;
  }


  public NamespaceMetadataTransactionDTO network(NetworkTypeEnum network) {
    
    this.network = network;
    return this;
  }

   /**
   * Get network
   * @return network
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_NETWORK)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public NetworkTypeEnum getNetwork() {
    return network;
  }


  public void setNetwork(NetworkTypeEnum network) {
    this.network = network;
  }


  public NamespaceMetadataTransactionDTO type(Integer type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TYPE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getType() {
    return type;
  }


  public void setType(Integer type) {
    this.type = type;
  }


  public NamespaceMetadataTransactionDTO maxFee(java.math.BigInteger maxFee) {
    
    this.maxFee = maxFee;
    return this;
  }

   /**
   * Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).
   * @return maxFee
  **/
  @ApiModelProperty(example = "123456", required = true, value = "Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
  @JsonProperty(JSON_PROPERTY_MAX_FEE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getMaxFee() {
    return maxFee;
  }


  public void setMaxFee(java.math.BigInteger maxFee) {
    this.maxFee = maxFee;
  }


  public NamespaceMetadataTransactionDTO deadline(java.math.BigInteger deadline) {
    
    this.deadline = deadline;
    return this;
  }

   /**
   * Duration expressed in number of blocks.
   * @return deadline
  **/
  @ApiModelProperty(example = "200", required = true, value = "Duration expressed in number of blocks.")
  @JsonProperty(JSON_PROPERTY_DEADLINE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getDeadline() {
    return deadline;
  }


  public void setDeadline(java.math.BigInteger deadline) {
    this.deadline = deadline;
  }


  public NamespaceMetadataTransactionDTO targetAddress(String targetAddress) {
    
    this.targetAddress = targetAddress;
    return this;
  }

   /**
   * Address expressed in hexadecimal base. If the bit 0 of byte 0 is not set (like in 0x90), then it is a regular address. Else (e.g. 0x91) it represents a namespace id which starts at byte 1. 
   * @return targetAddress
  **/
  @ApiModelProperty(example = "90340017CFF3DD2BCF3B2670CDCB9FC8C75754E2325F297C", required = true, value = "Address expressed in hexadecimal base. If the bit 0 of byte 0 is not set (like in 0x90), then it is a regular address. Else (e.g. 0x91) it represents a namespace id which starts at byte 1. ")
  @JsonProperty(JSON_PROPERTY_TARGET_ADDRESS)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTargetAddress() {
    return targetAddress;
  }


  public void setTargetAddress(String targetAddress) {
    this.targetAddress = targetAddress;
  }


  public NamespaceMetadataTransactionDTO scopedMetadataKey(String scopedMetadataKey) {
    
    this.scopedMetadataKey = scopedMetadataKey;
    return this;
  }

   /**
   * Metadata key scoped to source, target and type expressed.
   * @return scopedMetadataKey
  **/
  @ApiModelProperty(example = "0DC67FBE1CAD29E3", required = true, value = "Metadata key scoped to source, target and type expressed.")
  @JsonProperty(JSON_PROPERTY_SCOPED_METADATA_KEY)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getScopedMetadataKey() {
    return scopedMetadataKey;
  }


  public void setScopedMetadataKey(String scopedMetadataKey) {
    this.scopedMetadataKey = scopedMetadataKey;
  }


  public NamespaceMetadataTransactionDTO targetNamespaceId(String targetNamespaceId) {
    
    this.targetNamespaceId = targetNamespaceId;
    return this;
  }

   /**
   * Namespace identifier.
   * @return targetNamespaceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "85BBEA6CC462B244", value = "Namespace identifier.")
  @JsonProperty(JSON_PROPERTY_TARGET_NAMESPACE_ID)
  // @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTargetNamespaceId() {
    return targetNamespaceId;
  }


  public void setTargetNamespaceId(String targetNamespaceId) {
    this.targetNamespaceId = targetNamespaceId;
  }


  public NamespaceMetadataTransactionDTO valueSizeDelta(Integer valueSizeDelta) {
    
    this.valueSizeDelta = valueSizeDelta;
    return this;
  }

   /**
   * Change in value size in bytes.
   * @return valueSizeDelta
  **/
  @ApiModelProperty(required = true, value = "Change in value size in bytes.")
  @JsonProperty(JSON_PROPERTY_VALUE_SIZE_DELTA)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getValueSizeDelta() {
    return valueSizeDelta;
  }


  public void setValueSizeDelta(Integer valueSizeDelta) {
    this.valueSizeDelta = valueSizeDelta;
  }


  public NamespaceMetadataTransactionDTO valueSize(Long valueSize) {
    
    this.valueSize = valueSize;
    return this;
  }

   /**
   * A number that allows uint 32 values.
   * @return valueSize
  **/
  @ApiModelProperty(example = "2222212828", required = true, value = "A number that allows uint 32 values.")
  @JsonProperty(JSON_PROPERTY_VALUE_SIZE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Long getValueSize() {
    return valueSize;
  }


  public void setValueSize(Long valueSize) {
    this.valueSize = valueSize;
  }


  public NamespaceMetadataTransactionDTO value(String value) {
    
    this.value = value;
    return this;
  }

   /**
   * Metadata value. If embedded in a transaction, this is calculated as xor(previous-value, value).
   * @return value
  **/
  @ApiModelProperty(required = true, value = "Metadata value. If embedded in a transaction, this is calculated as xor(previous-value, value).")
  @JsonProperty(JSON_PROPERTY_VALUE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getValue() {
    return value;
  }


  public void setValue(String value) {
    this.value = value;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    NamespaceMetadataTransactionDTO namespaceMetadataTransactionDTO = (NamespaceMetadataTransactionDTO) o;
    return Objects.equals(this.size, namespaceMetadataTransactionDTO.size) &&
        Objects.equals(this.signature, namespaceMetadataTransactionDTO.signature) &&
        Objects.equals(this.signerPublicKey, namespaceMetadataTransactionDTO.signerPublicKey) &&
        Objects.equals(this.version, namespaceMetadataTransactionDTO.version) &&
        Objects.equals(this.network, namespaceMetadataTransactionDTO.network) &&
        Objects.equals(this.type, namespaceMetadataTransactionDTO.type) &&
        Objects.equals(this.maxFee, namespaceMetadataTransactionDTO.maxFee) &&
        Objects.equals(this.deadline, namespaceMetadataTransactionDTO.deadline) &&
        Objects.equals(this.targetAddress, namespaceMetadataTransactionDTO.targetAddress) &&
        Objects.equals(this.scopedMetadataKey, namespaceMetadataTransactionDTO.scopedMetadataKey) &&
        Objects.equals(this.targetNamespaceId, namespaceMetadataTransactionDTO.targetNamespaceId) &&
        Objects.equals(this.valueSizeDelta, namespaceMetadataTransactionDTO.valueSizeDelta) &&
        Objects.equals(this.valueSize, namespaceMetadataTransactionDTO.valueSize) &&
        Objects.equals(this.value, namespaceMetadataTransactionDTO.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(size, signature, signerPublicKey, version, network, type, maxFee, deadline, targetAddress, scopedMetadataKey, targetNamespaceId, valueSizeDelta, valueSize, value);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class NamespaceMetadataTransactionDTO {\n");
    sb.append("    size: ").append(toIndentedString(size)).append("\n");
    sb.append("    signature: ").append(toIndentedString(signature)).append("\n");
    sb.append("    signerPublicKey: ").append(toIndentedString(signerPublicKey)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    network: ").append(toIndentedString(network)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    maxFee: ").append(toIndentedString(maxFee)).append("\n");
    sb.append("    deadline: ").append(toIndentedString(deadline)).append("\n");
    sb.append("    targetAddress: ").append(toIndentedString(targetAddress)).append("\n");
    sb.append("    scopedMetadataKey: ").append(toIndentedString(scopedMetadataKey)).append("\n");
    sb.append("    targetNamespaceId: ").append(toIndentedString(targetNamespaceId)).append("\n");
    sb.append("    valueSizeDelta: ").append(toIndentedString(valueSizeDelta)).append("\n");
    sb.append("    valueSize: ").append(toIndentedString(valueSize)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

