/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest 1.2.0
 *
 * The version of the OpenAPI document: 0.9.6
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.symbol.sdk.openapi.jersey2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * MosaicDTO
 */
@JsonPropertyOrder({
  MosaicDTO.JSON_PROPERTY_ID,
  MosaicDTO.JSON_PROPERTY_SUPPLY,
  MosaicDTO.JSON_PROPERTY_START_HEIGHT,
  MosaicDTO.JSON_PROPERTY_OWNER_ADDRESS,
  MosaicDTO.JSON_PROPERTY_REVISION,
  MosaicDTO.JSON_PROPERTY_FLAGS,
  MosaicDTO.JSON_PROPERTY_DIVISIBILITY,
  MosaicDTO.JSON_PROPERTY_DURATION
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-08-14T13:43:37.324Z[UTC]")
public class MosaicDTO {
  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_SUPPLY = "supply";
  private java.math.BigInteger supply = null;

  public static final String JSON_PROPERTY_START_HEIGHT = "startHeight";
  private java.math.BigInteger startHeight = null;

  public static final String JSON_PROPERTY_OWNER_ADDRESS = "ownerAddress";
  private String ownerAddress;

  public static final String JSON_PROPERTY_REVISION = "revision";
  private Long revision;

  public static final String JSON_PROPERTY_FLAGS = "flags";
  private Integer flags;

  public static final String JSON_PROPERTY_DIVISIBILITY = "divisibility";
  private Integer divisibility;

  public static final String JSON_PROPERTY_DURATION = "duration";
  private java.math.BigInteger duration = null;


  public MosaicDTO id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Mosaic identifier.
   * @return id
  **/
  @ApiModelProperty(example = "0DC67FBE1CAD29E3", required = true, value = "Mosaic identifier.")
  @JsonProperty(JSON_PROPERTY_ID)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getId() {
    return id;
  }


  public void setId(String id) {
    this.id = id;
  }


  public MosaicDTO supply(java.math.BigInteger supply) {
    
    this.supply = supply;
    return this;
  }

   /**
   * Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).
   * @return supply
  **/
  @ApiModelProperty(example = "123456", required = true, value = "Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
  @JsonProperty(JSON_PROPERTY_SUPPLY)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getSupply() {
    return supply;
  }


  public void setSupply(java.math.BigInteger supply) {
    this.supply = supply;
  }


  public MosaicDTO startHeight(java.math.BigInteger startHeight) {
    
    this.startHeight = startHeight;
    return this;
  }

   /**
   * Height of the blockchain.
   * @return startHeight
  **/
  @ApiModelProperty(example = "1", required = true, value = "Height of the blockchain.")
  @JsonProperty(JSON_PROPERTY_START_HEIGHT)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getStartHeight() {
    return startHeight;
  }


  public void setStartHeight(java.math.BigInteger startHeight) {
    this.startHeight = startHeight;
  }


  public MosaicDTO ownerAddress(String ownerAddress) {
    
    this.ownerAddress = ownerAddress;
    return this;
  }

   /**
   * Address expressed in hexadecimal base.
   * @return ownerAddress
  **/
  @ApiModelProperty(example = "9081FCCB41F8C8409A9B99E485E0E28D23BD6304EF7215E0", required = true, value = "Address expressed in hexadecimal base.")
  @JsonProperty(JSON_PROPERTY_OWNER_ADDRESS)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getOwnerAddress() {
    return ownerAddress;
  }


  public void setOwnerAddress(String ownerAddress) {
    this.ownerAddress = ownerAddress;
  }


  public MosaicDTO revision(Long revision) {
    
    this.revision = revision;
    return this;
  }

   /**
   * A number that allows uint 32 values.
   * @return revision
  **/
  @ApiModelProperty(example = "2222212828", required = true, value = "A number that allows uint 32 values.")
  @JsonProperty(JSON_PROPERTY_REVISION)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Long getRevision() {
    return revision;
  }


  public void setRevision(Long revision) {
    this.revision = revision;
  }


  public MosaicDTO flags(Integer flags) {
    
    this.flags = flags;
    return this;
  }

   /**
   * - 0x00 (none) - No flags present. - 0x01 (supplyMutable) - Mosaic supports supply changes even when mosaic owner owns partial supply. - 0x02 (transferable) - Mosaic supports transfers between arbitrary accounts. When not set, mosaic can only be transferred to and from mosaic owner. - 0x04 (restrictable) - Mosaic supports custom restrictions configured by mosaic owner. 
   * @return flags
  **/
  @ApiModelProperty(required = true, value = "- 0x00 (none) - No flags present. - 0x01 (supplyMutable) - Mosaic supports supply changes even when mosaic owner owns partial supply. - 0x02 (transferable) - Mosaic supports transfers between arbitrary accounts. When not set, mosaic can only be transferred to and from mosaic owner. - 0x04 (restrictable) - Mosaic supports custom restrictions configured by mosaic owner. ")
  @JsonProperty(JSON_PROPERTY_FLAGS)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getFlags() {
    return flags;
  }


  public void setFlags(Integer flags) {
    this.flags = flags;
  }


  public MosaicDTO divisibility(Integer divisibility) {
    
    this.divisibility = divisibility;
    return this;
  }

   /**
   * Determines up to what decimal place the mosaic can be divided. Divisibility of 3 means that a mosaic can be divided into smallest parts of 0.001 mosaics. The divisibility must be in the range of 0 and 6. 
   * @return divisibility
  **/
  @ApiModelProperty(required = true, value = "Determines up to what decimal place the mosaic can be divided. Divisibility of 3 means that a mosaic can be divided into smallest parts of 0.001 mosaics. The divisibility must be in the range of 0 and 6. ")
  @JsonProperty(JSON_PROPERTY_DIVISIBILITY)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getDivisibility() {
    return divisibility;
  }


  public void setDivisibility(Integer divisibility) {
    this.divisibility = divisibility;
  }


  public MosaicDTO duration(java.math.BigInteger duration) {
    
    this.duration = duration;
    return this;
  }

   /**
   * Duration expressed in number of blocks.
   * @return duration
  **/
  @ApiModelProperty(example = "200", required = true, value = "Duration expressed in number of blocks.")
  @JsonProperty(JSON_PROPERTY_DURATION)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getDuration() {
    return duration;
  }


  public void setDuration(java.math.BigInteger duration) {
    this.duration = duration;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MosaicDTO mosaicDTO = (MosaicDTO) o;
    return Objects.equals(this.id, mosaicDTO.id) &&
        Objects.equals(this.supply, mosaicDTO.supply) &&
        Objects.equals(this.startHeight, mosaicDTO.startHeight) &&
        Objects.equals(this.ownerAddress, mosaicDTO.ownerAddress) &&
        Objects.equals(this.revision, mosaicDTO.revision) &&
        Objects.equals(this.flags, mosaicDTO.flags) &&
        Objects.equals(this.divisibility, mosaicDTO.divisibility) &&
        Objects.equals(this.duration, mosaicDTO.duration);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, supply, startHeight, ownerAddress, revision, flags, divisibility, duration);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MosaicDTO {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    supply: ").append(toIndentedString(supply)).append("\n");
    sb.append("    startHeight: ").append(toIndentedString(startHeight)).append("\n");
    sb.append("    ownerAddress: ").append(toIndentedString(ownerAddress)).append("\n");
    sb.append("    revision: ").append(toIndentedString(revision)).append("\n");
    sb.append("    flags: ").append(toIndentedString(flags)).append("\n");
    sb.append("    divisibility: ").append(toIndentedString(divisibility)).append("\n");
    sb.append("    duration: ").append(toIndentedString(duration)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

