/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest 1.2.0
 *
 * The version of the OpenAPI document: 0.9.6
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.symbol.sdk.openapi.jersey2.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.nem.symbol.sdk.openapi.jersey2.model.AccountTypeEnum;
import io.nem.symbol.sdk.openapi.jersey2.model.ActivityBucketDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.Mosaic;
import io.nem.symbol.sdk.openapi.jersey2.model.SupplementalPublicKeysDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * AccountDTO
 */
@JsonPropertyOrder({
  AccountDTO.JSON_PROPERTY_ADDRESS,
  AccountDTO.JSON_PROPERTY_ADDRESS_HEIGHT,
  AccountDTO.JSON_PROPERTY_PUBLIC_KEY,
  AccountDTO.JSON_PROPERTY_PUBLIC_KEY_HEIGHT,
  AccountDTO.JSON_PROPERTY_ACCOUNT_TYPE,
  AccountDTO.JSON_PROPERTY_SUPPLEMENTAL_PUBLIC_KEYS,
  AccountDTO.JSON_PROPERTY_ACTIVITY_BUCKETS,
  AccountDTO.JSON_PROPERTY_MOSAICS,
  AccountDTO.JSON_PROPERTY_IMPORTANCE,
  AccountDTO.JSON_PROPERTY_IMPORTANCE_HEIGHT
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-08-14T13:43:37.324Z[UTC]")
public class AccountDTO {
  public static final String JSON_PROPERTY_ADDRESS = "address";
  private String address;

  public static final String JSON_PROPERTY_ADDRESS_HEIGHT = "addressHeight";
  private java.math.BigInteger addressHeight = null;

  public static final String JSON_PROPERTY_PUBLIC_KEY = "publicKey";
  private String publicKey;

  public static final String JSON_PROPERTY_PUBLIC_KEY_HEIGHT = "publicKeyHeight";
  private java.math.BigInteger publicKeyHeight = null;

  public static final String JSON_PROPERTY_ACCOUNT_TYPE = "accountType";
  private AccountTypeEnum accountType;

  public static final String JSON_PROPERTY_SUPPLEMENTAL_PUBLIC_KEYS = "supplementalPublicKeys";
  private SupplementalPublicKeysDTO supplementalPublicKeys;

  public static final String JSON_PROPERTY_ACTIVITY_BUCKETS = "activityBuckets";
  private List<ActivityBucketDTO> activityBuckets = new ArrayList<>();

  public static final String JSON_PROPERTY_MOSAICS = "mosaics";
  private List<Mosaic> mosaics = new ArrayList<>();

  public static final String JSON_PROPERTY_IMPORTANCE = "importance";
  private java.math.BigInteger importance = null;

  public static final String JSON_PROPERTY_IMPORTANCE_HEIGHT = "importanceHeight";
  private java.math.BigInteger importanceHeight = null;


  public AccountDTO address(String address) {
    
    this.address = address;
    return this;
  }

   /**
   * Address expressed in hexadecimal base.
   * @return address
  **/
  @ApiModelProperty(example = "9081FCCB41F8C8409A9B99E485E0E28D23BD6304EF7215E0", required = true, value = "Address expressed in hexadecimal base.")
  @JsonProperty(JSON_PROPERTY_ADDRESS)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAddress() {
    return address;
  }


  public void setAddress(String address) {
    this.address = address;
  }


  public AccountDTO addressHeight(java.math.BigInteger addressHeight) {
    
    this.addressHeight = addressHeight;
    return this;
  }

   /**
   * Height of the blockchain.
   * @return addressHeight
  **/
  @ApiModelProperty(example = "1", required = true, value = "Height of the blockchain.")
  @JsonProperty(JSON_PROPERTY_ADDRESS_HEIGHT)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getAddressHeight() {
    return addressHeight;
  }


  public void setAddressHeight(java.math.BigInteger addressHeight) {
    this.addressHeight = addressHeight;
  }


  public AccountDTO publicKey(String publicKey) {
    
    this.publicKey = publicKey;
    return this;
  }

   /**
   * Public key.
   * @return publicKey
  **/
  @ApiModelProperty(example = "AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required = true, value = "Public key.")
  @JsonProperty(JSON_PROPERTY_PUBLIC_KEY)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getPublicKey() {
    return publicKey;
  }


  public void setPublicKey(String publicKey) {
    this.publicKey = publicKey;
  }


  public AccountDTO publicKeyHeight(java.math.BigInteger publicKeyHeight) {
    
    this.publicKeyHeight = publicKeyHeight;
    return this;
  }

   /**
   * Height of the blockchain.
   * @return publicKeyHeight
  **/
  @ApiModelProperty(example = "1", required = true, value = "Height of the blockchain.")
  @JsonProperty(JSON_PROPERTY_PUBLIC_KEY_HEIGHT)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getPublicKeyHeight() {
    return publicKeyHeight;
  }


  public void setPublicKeyHeight(java.math.BigInteger publicKeyHeight) {
    this.publicKeyHeight = publicKeyHeight;
  }


  public AccountDTO accountType(AccountTypeEnum accountType) {
    
    this.accountType = accountType;
    return this;
  }

   /**
   * Get accountType
   * @return accountType
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_TYPE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public AccountTypeEnum getAccountType() {
    return accountType;
  }


  public void setAccountType(AccountTypeEnum accountType) {
    this.accountType = accountType;
  }


  public AccountDTO supplementalPublicKeys(SupplementalPublicKeysDTO supplementalPublicKeys) {
    
    this.supplementalPublicKeys = supplementalPublicKeys;
    return this;
  }

   /**
   * Get supplementalPublicKeys
   * @return supplementalPublicKeys
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_SUPPLEMENTAL_PUBLIC_KEYS)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public SupplementalPublicKeysDTO getSupplementalPublicKeys() {
    return supplementalPublicKeys;
  }


  public void setSupplementalPublicKeys(SupplementalPublicKeysDTO supplementalPublicKeys) {
    this.supplementalPublicKeys = supplementalPublicKeys;
  }


  public AccountDTO activityBuckets(List<ActivityBucketDTO> activityBuckets) {
    
    this.activityBuckets = activityBuckets;
    return this;
  }

  public AccountDTO addActivityBucketsItem(ActivityBucketDTO activityBucketsItem) {
    this.activityBuckets.add(activityBucketsItem);
    return this;
  }

   /**
   * Get activityBuckets
   * @return activityBuckets
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_ACTIVITY_BUCKETS)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<ActivityBucketDTO> getActivityBuckets() {
    return activityBuckets;
  }


  public void setActivityBuckets(List<ActivityBucketDTO> activityBuckets) {
    this.activityBuckets = activityBuckets;
  }


  public AccountDTO mosaics(List<Mosaic> mosaics) {
    
    this.mosaics = mosaics;
    return this;
  }

  public AccountDTO addMosaicsItem(Mosaic mosaicsItem) {
    this.mosaics.add(mosaicsItem);
    return this;
  }

   /**
   * Mosaic units owned.
   * @return mosaics
  **/
  @ApiModelProperty(required = true, value = "Mosaic units owned.")
  @JsonProperty(JSON_PROPERTY_MOSAICS)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<Mosaic> getMosaics() {
    return mosaics;
  }


  public void setMosaics(List<Mosaic> mosaics) {
    this.mosaics = mosaics;
  }


  public AccountDTO importance(java.math.BigInteger importance) {
    
    this.importance = importance;
    return this;
  }

   /**
   * Probability of an account to harvest the next block.
   * @return importance
  **/
  @ApiModelProperty(example = "0", required = true, value = "Probability of an account to harvest the next block.")
  @JsonProperty(JSON_PROPERTY_IMPORTANCE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getImportance() {
    return importance;
  }


  public void setImportance(java.math.BigInteger importance) {
    this.importance = importance;
  }


  public AccountDTO importanceHeight(java.math.BigInteger importanceHeight) {
    
    this.importanceHeight = importanceHeight;
    return this;
  }

   /**
   * Height of the blockchain.
   * @return importanceHeight
  **/
  @ApiModelProperty(example = "1", required = true, value = "Height of the blockchain.")
  @JsonProperty(JSON_PROPERTY_IMPORTANCE_HEIGHT)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getImportanceHeight() {
    return importanceHeight;
  }


  public void setImportanceHeight(java.math.BigInteger importanceHeight) {
    this.importanceHeight = importanceHeight;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AccountDTO accountDTO = (AccountDTO) o;
    return Objects.equals(this.address, accountDTO.address) &&
        Objects.equals(this.addressHeight, accountDTO.addressHeight) &&
        Objects.equals(this.publicKey, accountDTO.publicKey) &&
        Objects.equals(this.publicKeyHeight, accountDTO.publicKeyHeight) &&
        Objects.equals(this.accountType, accountDTO.accountType) &&
        Objects.equals(this.supplementalPublicKeys, accountDTO.supplementalPublicKeys) &&
        Objects.equals(this.activityBuckets, accountDTO.activityBuckets) &&
        Objects.equals(this.mosaics, accountDTO.mosaics) &&
        Objects.equals(this.importance, accountDTO.importance) &&
        Objects.equals(this.importanceHeight, accountDTO.importanceHeight);
  }

  @Override
  public int hashCode() {
    return Objects.hash(address, addressHeight, publicKey, publicKeyHeight, accountType, supplementalPublicKeys, activityBuckets, mosaics, importance, importanceHeight);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AccountDTO {\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    addressHeight: ").append(toIndentedString(addressHeight)).append("\n");
    sb.append("    publicKey: ").append(toIndentedString(publicKey)).append("\n");
    sb.append("    publicKeyHeight: ").append(toIndentedString(publicKeyHeight)).append("\n");
    sb.append("    accountType: ").append(toIndentedString(accountType)).append("\n");
    sb.append("    supplementalPublicKeys: ").append(toIndentedString(supplementalPublicKeys)).append("\n");
    sb.append("    activityBuckets: ").append(toIndentedString(activityBuckets)).append("\n");
    sb.append("    mosaics: ").append(toIndentedString(mosaics)).append("\n");
    sb.append("    importance: ").append(toIndentedString(importance)).append("\n");
    sb.append("    importanceHeight: ").append(toIndentedString(importanceHeight)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

