package io.nem.symbol.sdk.openapi.jersey2.api;

import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiException;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiResponse;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Configuration;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Pair;

import javax.ws.rs.core.GenericType;

import io.nem.symbol.sdk.openapi.jersey2.model.ModelError;
import io.nem.symbol.sdk.openapi.jersey2.model.TransactionHashes;
import io.nem.symbol.sdk.openapi.jersey2.model.TransactionStatusDTO;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-08-14T13:43:37.324Z[UTC]")
public class TransactionStatusRoutesApi {
  private ApiClient apiClient;

  public TransactionStatusRoutesApi() {
    this(Configuration.getDefaultApiClient());
  }

  public TransactionStatusRoutesApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }
  /**
   * Get transaction status
   * Returns the transaction status for a given hash.
   * @param hash Transaction hash. (required)
   * @return TransactionStatusDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public TransactionStatusDTO getTransactionStatus(String hash) throws ApiException {
    return getTransactionStatusWithHttpInfo(hash).getData();
  }

  /**
   * Get transaction status
   * Returns the transaction status for a given hash.
   * @param hash Transaction hash. (required)
   * @return ApiResponse&lt;TransactionStatusDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<TransactionStatusDTO> getTransactionStatusWithHttpInfo(String hash) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'hash' is set
    if (hash == null) {
      throw new ApiException(400, "Missing the required parameter 'hash' when calling getTransactionStatus");
    }
    
    // create path and map variables
    String localVarPath = "/transactionStatus/{hash}"
      .replaceAll("\\{" + "hash" + "\\}", apiClient.escapeString(hash.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<TransactionStatusDTO> localVarReturnType = new GenericType<TransactionStatusDTO>() {};
    return apiClient.invokeAPI("TransactionStatusRoutesApi.getTransactionStatus", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get transaction statuses
   * Returns an array of transaction statuses for a given array of transaction hashes.
   * @param transactionHashes  (required)
   * @return List&lt;TransactionStatusDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public List<TransactionStatusDTO> getTransactionStatuses(TransactionHashes transactionHashes) throws ApiException {
    return getTransactionStatusesWithHttpInfo(transactionHashes).getData();
  }

  /**
   * Get transaction statuses
   * Returns an array of transaction statuses for a given array of transaction hashes.
   * @param transactionHashes  (required)
   * @return ApiResponse&lt;List&lt;TransactionStatusDTO&gt;&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<List<TransactionStatusDTO>> getTransactionStatusesWithHttpInfo(TransactionHashes transactionHashes) throws ApiException {
    Object localVarPostBody = transactionHashes;
    
    // verify the required parameter 'transactionHashes' is set
    if (transactionHashes == null) {
      throw new ApiException(400, "Missing the required parameter 'transactionHashes' when calling getTransactionStatuses");
    }
    
    // create path and map variables
    String localVarPath = "/transactionStatus";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<List<TransactionStatusDTO>> localVarReturnType = new GenericType<List<TransactionStatusDTO>>() {};
    return apiClient.invokeAPI("TransactionStatusRoutesApi.getTransactionStatuses", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
}
