package io.nem.symbol.sdk.openapi.jersey2.api;

import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiException;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiResponse;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Configuration;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Pair;

import javax.ws.rs.core.GenericType;

import io.nem.symbol.sdk.openapi.jersey2.model.AnnounceTransactionInfoDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.Cosignature;
import io.nem.symbol.sdk.openapi.jersey2.model.ModelError;
import io.nem.symbol.sdk.openapi.jersey2.model.Order;
import io.nem.symbol.sdk.openapi.jersey2.model.TransactionIds;
import io.nem.symbol.sdk.openapi.jersey2.model.TransactionInfoDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.TransactionPage;
import io.nem.symbol.sdk.openapi.jersey2.model.TransactionPayload;
import io.nem.symbol.sdk.openapi.jersey2.model.TransactionTypeEnum;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-08-14T13:43:37.324Z[UTC]")
public class TransactionRoutesApi {
  private ApiClient apiClient;

  public TransactionRoutesApi() {
    this(Configuration.getDefaultApiClient());
  }

  public TransactionRoutesApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }
  /**
   * Announce a cosignature transaction
   * Announces a cosignature transaction to the network.
   * @param cosignature  (required)
   * @return AnnounceTransactionInfoDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 202 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public AnnounceTransactionInfoDTO announceCosignatureTransaction(Cosignature cosignature) throws ApiException {
    return announceCosignatureTransactionWithHttpInfo(cosignature).getData();
  }

  /**
   * Announce a cosignature transaction
   * Announces a cosignature transaction to the network.
   * @param cosignature  (required)
   * @return ApiResponse&lt;AnnounceTransactionInfoDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 202 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<AnnounceTransactionInfoDTO> announceCosignatureTransactionWithHttpInfo(Cosignature cosignature) throws ApiException {
    Object localVarPostBody = cosignature;
    
    // verify the required parameter 'cosignature' is set
    if (cosignature == null) {
      throw new ApiException(400, "Missing the required parameter 'cosignature' when calling announceCosignatureTransaction");
    }
    
    // create path and map variables
    String localVarPath = "/transactions/cosignature";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<AnnounceTransactionInfoDTO> localVarReturnType = new GenericType<AnnounceTransactionInfoDTO>() {};
    return apiClient.invokeAPI("TransactionRoutesApi.announceCosignatureTransaction", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Announce an aggregate bonded transaction
   * Announces an aggregate bonded transaction to the network.
   * @param transactionPayload  (required)
   * @return AnnounceTransactionInfoDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 202 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public AnnounceTransactionInfoDTO announcePartialTransaction(TransactionPayload transactionPayload) throws ApiException {
    return announcePartialTransactionWithHttpInfo(transactionPayload).getData();
  }

  /**
   * Announce an aggregate bonded transaction
   * Announces an aggregate bonded transaction to the network.
   * @param transactionPayload  (required)
   * @return ApiResponse&lt;AnnounceTransactionInfoDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 202 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<AnnounceTransactionInfoDTO> announcePartialTransactionWithHttpInfo(TransactionPayload transactionPayload) throws ApiException {
    Object localVarPostBody = transactionPayload;
    
    // verify the required parameter 'transactionPayload' is set
    if (transactionPayload == null) {
      throw new ApiException(400, "Missing the required parameter 'transactionPayload' when calling announcePartialTransaction");
    }
    
    // create path and map variables
    String localVarPath = "/transactions/partial";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<AnnounceTransactionInfoDTO> localVarReturnType = new GenericType<AnnounceTransactionInfoDTO>() {};
    return apiClient.invokeAPI("TransactionRoutesApi.announcePartialTransaction", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Announce a new transaction
   * Announces a transaction to the network. The [catbuffer library](https://github.com/nemtech/catbuffer) defines the protocol to serialize and deserialize Symbol entities. Catbuffers are integrated into [Symbol SDKs](https://nemtech.github.io/sdk.html).  It&#39;s recommended to use SDKs instead of calling the API endpoint directly to announce transactions. 
   * @param transactionPayload  (required)
   * @return AnnounceTransactionInfoDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 202 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public AnnounceTransactionInfoDTO announceTransaction(TransactionPayload transactionPayload) throws ApiException {
    return announceTransactionWithHttpInfo(transactionPayload).getData();
  }

  /**
   * Announce a new transaction
   * Announces a transaction to the network. The [catbuffer library](https://github.com/nemtech/catbuffer) defines the protocol to serialize and deserialize Symbol entities. Catbuffers are integrated into [Symbol SDKs](https://nemtech.github.io/sdk.html).  It&#39;s recommended to use SDKs instead of calling the API endpoint directly to announce transactions. 
   * @param transactionPayload  (required)
   * @return ApiResponse&lt;AnnounceTransactionInfoDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 202 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<AnnounceTransactionInfoDTO> announceTransactionWithHttpInfo(TransactionPayload transactionPayload) throws ApiException {
    Object localVarPostBody = transactionPayload;
    
    // verify the required parameter 'transactionPayload' is set
    if (transactionPayload == null) {
      throw new ApiException(400, "Missing the required parameter 'transactionPayload' when calling announceTransaction");
    }
    
    // create path and map variables
    String localVarPath = "/transactions";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<AnnounceTransactionInfoDTO> localVarReturnType = new GenericType<AnnounceTransactionInfoDTO>() {};
    return apiClient.invokeAPI("TransactionRoutesApi.announceTransaction", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get confirmed transaction information
   * Returns confirmed transaction information given a transactionId or hash.
   * @param transactionId Transaction id or hash. (required)
   * @return TransactionInfoDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public TransactionInfoDTO getConfirmedTransaction(String transactionId) throws ApiException {
    return getConfirmedTransactionWithHttpInfo(transactionId).getData();
  }

  /**
   * Get confirmed transaction information
   * Returns confirmed transaction information given a transactionId or hash.
   * @param transactionId Transaction id or hash. (required)
   * @return ApiResponse&lt;TransactionInfoDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<TransactionInfoDTO> getConfirmedTransactionWithHttpInfo(String transactionId) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'transactionId' is set
    if (transactionId == null) {
      throw new ApiException(400, "Missing the required parameter 'transactionId' when calling getConfirmedTransaction");
    }
    
    // create path and map variables
    String localVarPath = "/transactions/confirmed/{transactionId}"
      .replaceAll("\\{" + "transactionId" + "\\}", apiClient.escapeString(transactionId.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<TransactionInfoDTO> localVarReturnType = new GenericType<TransactionInfoDTO>() {};
    return apiClient.invokeAPI("TransactionRoutesApi.getConfirmedTransaction", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get confirmed trasactions information
   * Returns confirmed transactions information for a given array of transactionIds.
   * @param transactionIds  (required)
   * @return List&lt;TransactionInfoDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public List<TransactionInfoDTO> getConfirmedTransactions(TransactionIds transactionIds) throws ApiException {
    return getConfirmedTransactionsWithHttpInfo(transactionIds).getData();
  }

  /**
   * Get confirmed trasactions information
   * Returns confirmed transactions information for a given array of transactionIds.
   * @param transactionIds  (required)
   * @return ApiResponse&lt;List&lt;TransactionInfoDTO&gt;&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<List<TransactionInfoDTO>> getConfirmedTransactionsWithHttpInfo(TransactionIds transactionIds) throws ApiException {
    Object localVarPostBody = transactionIds;
    
    // verify the required parameter 'transactionIds' is set
    if (transactionIds == null) {
      throw new ApiException(400, "Missing the required parameter 'transactionIds' when calling getConfirmedTransactions");
    }
    
    // create path and map variables
    String localVarPath = "/transactions/confirmed";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<List<TransactionInfoDTO>> localVarReturnType = new GenericType<List<TransactionInfoDTO>>() {};
    return apiClient.invokeAPI("TransactionRoutesApi.getConfirmedTransactions", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get partial transaction information
   * Returns partial transaction information given a transactionId or hash.
   * @param transactionId Transaction id or hash. (required)
   * @return TransactionInfoDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public TransactionInfoDTO getPartialTransaction(String transactionId) throws ApiException {
    return getPartialTransactionWithHttpInfo(transactionId).getData();
  }

  /**
   * Get partial transaction information
   * Returns partial transaction information given a transactionId or hash.
   * @param transactionId Transaction id or hash. (required)
   * @return ApiResponse&lt;TransactionInfoDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<TransactionInfoDTO> getPartialTransactionWithHttpInfo(String transactionId) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'transactionId' is set
    if (transactionId == null) {
      throw new ApiException(400, "Missing the required parameter 'transactionId' when calling getPartialTransaction");
    }
    
    // create path and map variables
    String localVarPath = "/transactions/partial/{transactionId}"
      .replaceAll("\\{" + "transactionId" + "\\}", apiClient.escapeString(transactionId.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<TransactionInfoDTO> localVarReturnType = new GenericType<TransactionInfoDTO>() {};
    return apiClient.invokeAPI("TransactionRoutesApi.getPartialTransaction", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get partial trasactions information
   * Returns partial transactions information for a given array of transactionIds.
   * @param transactionIds  (required)
   * @return List&lt;TransactionInfoDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public List<TransactionInfoDTO> getPartialTransactions(TransactionIds transactionIds) throws ApiException {
    return getPartialTransactionsWithHttpInfo(transactionIds).getData();
  }

  /**
   * Get partial trasactions information
   * Returns partial transactions information for a given array of transactionIds.
   * @param transactionIds  (required)
   * @return ApiResponse&lt;List&lt;TransactionInfoDTO&gt;&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<List<TransactionInfoDTO>> getPartialTransactionsWithHttpInfo(TransactionIds transactionIds) throws ApiException {
    Object localVarPostBody = transactionIds;
    
    // verify the required parameter 'transactionIds' is set
    if (transactionIds == null) {
      throw new ApiException(400, "Missing the required parameter 'transactionIds' when calling getPartialTransactions");
    }
    
    // create path and map variables
    String localVarPath = "/transactions/partial";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<List<TransactionInfoDTO>> localVarReturnType = new GenericType<List<TransactionInfoDTO>>() {};
    return apiClient.invokeAPI("TransactionRoutesApi.getPartialTransactions", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get unconfirmed transaction information
   * Returns unconfirmed transaction information given a transactionId or hash.
   * @param transactionId Transaction id or hash. (required)
   * @return TransactionInfoDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public TransactionInfoDTO getUnconfirmedTransaction(String transactionId) throws ApiException {
    return getUnconfirmedTransactionWithHttpInfo(transactionId).getData();
  }

  /**
   * Get unconfirmed transaction information
   * Returns unconfirmed transaction information given a transactionId or hash.
   * @param transactionId Transaction id or hash. (required)
   * @return ApiResponse&lt;TransactionInfoDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<TransactionInfoDTO> getUnconfirmedTransactionWithHttpInfo(String transactionId) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'transactionId' is set
    if (transactionId == null) {
      throw new ApiException(400, "Missing the required parameter 'transactionId' when calling getUnconfirmedTransaction");
    }
    
    // create path and map variables
    String localVarPath = "/transactions/unconfirmed/{transactionId}"
      .replaceAll("\\{" + "transactionId" + "\\}", apiClient.escapeString(transactionId.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<TransactionInfoDTO> localVarReturnType = new GenericType<TransactionInfoDTO>() {};
    return apiClient.invokeAPI("TransactionRoutesApi.getUnconfirmedTransaction", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get unconfirmed trasactions information
   * Returns unconfirmed transactions information for a given array of transactionIds.
   * @param transactionIds  (required)
   * @return List&lt;TransactionInfoDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public List<TransactionInfoDTO> getUnconfirmedTransactions(TransactionIds transactionIds) throws ApiException {
    return getUnconfirmedTransactionsWithHttpInfo(transactionIds).getData();
  }

  /**
   * Get unconfirmed trasactions information
   * Returns unconfirmed transactions information for a given array of transactionIds.
   * @param transactionIds  (required)
   * @return ApiResponse&lt;List&lt;TransactionInfoDTO&gt;&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<List<TransactionInfoDTO>> getUnconfirmedTransactionsWithHttpInfo(TransactionIds transactionIds) throws ApiException {
    Object localVarPostBody = transactionIds;
    
    // verify the required parameter 'transactionIds' is set
    if (transactionIds == null) {
      throw new ApiException(400, "Missing the required parameter 'transactionIds' when calling getUnconfirmedTransactions");
    }
    
    // create path and map variables
    String localVarPath = "/transactions/unconfirmed";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<List<TransactionInfoDTO>> localVarReturnType = new GenericType<List<TransactionInfoDTO>>() {};
    return apiClient.invokeAPI("TransactionRoutesApi.getUnconfirmedTransactions", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Search confirmed transactions
   * Returns an array of confirmed transactions.
   * @param address Filter by address involved in the transaction.  An account&#39;s address is consider to be involved in the transaction when the account is the sender, recipient, or it is required to cosign the transaction. This filter cannot be combined with &#x60;&#x60;recipientAddress&#x60;&#x60; and &#x60;&#x60;signerPublicKey&#x60;&#x60; query params.  (optional)
   * @param recipientAddress Filter by address of the account receiving the transaction. (optional)
   * @param signerPublicKey Filter by public key of the account signing the entity. (optional)
   * @param height Filter by block height. (optional, default to null)
   * @param type Filter by transaction type. To filter by multiple transaction types, add more filter query params like: &#x60;&#x60;type&#x3D;16974&amp;type&#x3D;16718&#x60;&#x60;.  (optional, default to new ArrayList&lt;&gt;())
   * @param embedded When true, the endpoint also returns all the embedded aggregate transactions. Otherwise, only top-level transactions used to calcualate the block transactionsHash are returned.  (optional, default to false)
   * @param pageSize Select the number of entries to return. (optional, default to 10)
   * @param pageNumber Filter by page number. (optional, default to 1)
   * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
   * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
   * @return TransactionPage
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public TransactionPage searchConfirmedTransactions(String address, String recipientAddress, String signerPublicKey, java.math.BigInteger height, List<TransactionTypeEnum> type, Boolean embedded, Integer pageSize, Integer pageNumber, String offset, Order order) throws ApiException {
    return searchConfirmedTransactionsWithHttpInfo(address, recipientAddress, signerPublicKey, height, type, embedded, pageSize, pageNumber, offset, order).getData();
  }

  /**
   * Search confirmed transactions
   * Returns an array of confirmed transactions.
   * @param address Filter by address involved in the transaction.  An account&#39;s address is consider to be involved in the transaction when the account is the sender, recipient, or it is required to cosign the transaction. This filter cannot be combined with &#x60;&#x60;recipientAddress&#x60;&#x60; and &#x60;&#x60;signerPublicKey&#x60;&#x60; query params.  (optional)
   * @param recipientAddress Filter by address of the account receiving the transaction. (optional)
   * @param signerPublicKey Filter by public key of the account signing the entity. (optional)
   * @param height Filter by block height. (optional, default to null)
   * @param type Filter by transaction type. To filter by multiple transaction types, add more filter query params like: &#x60;&#x60;type&#x3D;16974&amp;type&#x3D;16718&#x60;&#x60;.  (optional, default to new ArrayList&lt;&gt;())
   * @param embedded When true, the endpoint also returns all the embedded aggregate transactions. Otherwise, only top-level transactions used to calcualate the block transactionsHash are returned.  (optional, default to false)
   * @param pageSize Select the number of entries to return. (optional, default to 10)
   * @param pageNumber Filter by page number. (optional, default to 1)
   * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
   * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
   * @return ApiResponse&lt;TransactionPage&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<TransactionPage> searchConfirmedTransactionsWithHttpInfo(String address, String recipientAddress, String signerPublicKey, java.math.BigInteger height, List<TransactionTypeEnum> type, Boolean embedded, Integer pageSize, Integer pageNumber, String offset, Order order) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/transactions/confirmed";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "address", address));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "recipientAddress", recipientAddress));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "signerPublicKey", signerPublicKey));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "height", height));
    localVarQueryParams.addAll(apiClient.parameterToPairs("multi", "type", type));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "embedded", embedded));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageSize", pageSize));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageNumber", pageNumber));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "offset", offset));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "order", order));

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<TransactionPage> localVarReturnType = new GenericType<TransactionPage>() {};
    return apiClient.invokeAPI("TransactionRoutesApi.searchConfirmedTransactions", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Search partial transactions
   * Returns an array of partial transactions.
   * @param address Filter by address involved in the transaction.  An account&#39;s address is consider to be involved in the transaction when the account is the sender, recipient, or it is required to cosign the transaction. This filter cannot be combined with &#x60;&#x60;recipientAddress&#x60;&#x60; and &#x60;&#x60;signerPublicKey&#x60;&#x60; query params.  (optional)
   * @param recipientAddress Filter by address of the account receiving the transaction. (optional)
   * @param signerPublicKey Filter by public key of the account signing the entity. (optional)
   * @param height Filter by block height. (optional, default to null)
   * @param type Filter by transaction type. To filter by multiple transaction types, add more filter query params like: &#x60;&#x60;type&#x3D;16974&amp;type&#x3D;16718&#x60;&#x60;.  (optional, default to new ArrayList&lt;&gt;())
   * @param embedded When true, the endpoint also returns all the embedded aggregate transactions. Otherwise, only top-level transactions used to calcualate the block transactionsHash are returned.  (optional, default to false)
   * @param pageSize Select the number of entries to return. (optional, default to 10)
   * @param pageNumber Filter by page number. (optional, default to 1)
   * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
   * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
   * @return TransactionPage
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public TransactionPage searchPartialTransactions(String address, String recipientAddress, String signerPublicKey, java.math.BigInteger height, List<TransactionTypeEnum> type, Boolean embedded, Integer pageSize, Integer pageNumber, String offset, Order order) throws ApiException {
    return searchPartialTransactionsWithHttpInfo(address, recipientAddress, signerPublicKey, height, type, embedded, pageSize, pageNumber, offset, order).getData();
  }

  /**
   * Search partial transactions
   * Returns an array of partial transactions.
   * @param address Filter by address involved in the transaction.  An account&#39;s address is consider to be involved in the transaction when the account is the sender, recipient, or it is required to cosign the transaction. This filter cannot be combined with &#x60;&#x60;recipientAddress&#x60;&#x60; and &#x60;&#x60;signerPublicKey&#x60;&#x60; query params.  (optional)
   * @param recipientAddress Filter by address of the account receiving the transaction. (optional)
   * @param signerPublicKey Filter by public key of the account signing the entity. (optional)
   * @param height Filter by block height. (optional, default to null)
   * @param type Filter by transaction type. To filter by multiple transaction types, add more filter query params like: &#x60;&#x60;type&#x3D;16974&amp;type&#x3D;16718&#x60;&#x60;.  (optional, default to new ArrayList&lt;&gt;())
   * @param embedded When true, the endpoint also returns all the embedded aggregate transactions. Otherwise, only top-level transactions used to calcualate the block transactionsHash are returned.  (optional, default to false)
   * @param pageSize Select the number of entries to return. (optional, default to 10)
   * @param pageNumber Filter by page number. (optional, default to 1)
   * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
   * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
   * @return ApiResponse&lt;TransactionPage&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<TransactionPage> searchPartialTransactionsWithHttpInfo(String address, String recipientAddress, String signerPublicKey, java.math.BigInteger height, List<TransactionTypeEnum> type, Boolean embedded, Integer pageSize, Integer pageNumber, String offset, Order order) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/transactions/partial";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "address", address));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "recipientAddress", recipientAddress));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "signerPublicKey", signerPublicKey));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "height", height));
    localVarQueryParams.addAll(apiClient.parameterToPairs("multi", "type", type));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "embedded", embedded));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageSize", pageSize));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageNumber", pageNumber));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "offset", offset));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "order", order));

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<TransactionPage> localVarReturnType = new GenericType<TransactionPage>() {};
    return apiClient.invokeAPI("TransactionRoutesApi.searchPartialTransactions", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Search unconfirmed transactions
   * Returns an array of unconfirmed transactions.
   * @param address Filter by address involved in the transaction.  An account&#39;s address is consider to be involved in the transaction when the account is the sender, recipient, or it is required to cosign the transaction. This filter cannot be combined with &#x60;&#x60;recipientAddress&#x60;&#x60; and &#x60;&#x60;signerPublicKey&#x60;&#x60; query params.  (optional)
   * @param recipientAddress Filter by address of the account receiving the transaction. (optional)
   * @param signerPublicKey Filter by public key of the account signing the entity. (optional)
   * @param height Filter by block height. (optional, default to null)
   * @param type Filter by transaction type. To filter by multiple transaction types, add more filter query params like: &#x60;&#x60;type&#x3D;16974&amp;type&#x3D;16718&#x60;&#x60;.  (optional, default to new ArrayList&lt;&gt;())
   * @param embedded When true, the endpoint also returns all the embedded aggregate transactions. Otherwise, only top-level transactions used to calcualate the block transactionsHash are returned.  (optional, default to false)
   * @param pageSize Select the number of entries to return. (optional, default to 10)
   * @param pageNumber Filter by page number. (optional, default to 1)
   * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
   * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
   * @return TransactionPage
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public TransactionPage searchUnconfirmedTransactions(String address, String recipientAddress, String signerPublicKey, java.math.BigInteger height, List<TransactionTypeEnum> type, Boolean embedded, Integer pageSize, Integer pageNumber, String offset, Order order) throws ApiException {
    return searchUnconfirmedTransactionsWithHttpInfo(address, recipientAddress, signerPublicKey, height, type, embedded, pageSize, pageNumber, offset, order).getData();
  }

  /**
   * Search unconfirmed transactions
   * Returns an array of unconfirmed transactions.
   * @param address Filter by address involved in the transaction.  An account&#39;s address is consider to be involved in the transaction when the account is the sender, recipient, or it is required to cosign the transaction. This filter cannot be combined with &#x60;&#x60;recipientAddress&#x60;&#x60; and &#x60;&#x60;signerPublicKey&#x60;&#x60; query params.  (optional)
   * @param recipientAddress Filter by address of the account receiving the transaction. (optional)
   * @param signerPublicKey Filter by public key of the account signing the entity. (optional)
   * @param height Filter by block height. (optional, default to null)
   * @param type Filter by transaction type. To filter by multiple transaction types, add more filter query params like: &#x60;&#x60;type&#x3D;16974&amp;type&#x3D;16718&#x60;&#x60;.  (optional, default to new ArrayList&lt;&gt;())
   * @param embedded When true, the endpoint also returns all the embedded aggregate transactions. Otherwise, only top-level transactions used to calcualate the block transactionsHash are returned.  (optional, default to false)
   * @param pageSize Select the number of entries to return. (optional, default to 10)
   * @param pageNumber Filter by page number. (optional, default to 1)
   * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
   * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
   * @return ApiResponse&lt;TransactionPage&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<TransactionPage> searchUnconfirmedTransactionsWithHttpInfo(String address, String recipientAddress, String signerPublicKey, java.math.BigInteger height, List<TransactionTypeEnum> type, Boolean embedded, Integer pageSize, Integer pageNumber, String offset, Order order) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/transactions/unconfirmed";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "address", address));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "recipientAddress", recipientAddress));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "signerPublicKey", signerPublicKey));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "height", height));
    localVarQueryParams.addAll(apiClient.parameterToPairs("multi", "type", type));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "embedded", embedded));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageSize", pageSize));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageNumber", pageNumber));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "offset", offset));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "order", order));

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<TransactionPage> localVarReturnType = new GenericType<TransactionPage>() {};
    return apiClient.invokeAPI("TransactionRoutesApi.searchUnconfirmedTransactions", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
}
