package io.nem.symbol.sdk.openapi.jersey2.api;

import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiException;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiResponse;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Configuration;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Pair;

import javax.ws.rs.core.GenericType;

import io.nem.symbol.sdk.openapi.jersey2.model.ModelError;
import io.nem.symbol.sdk.openapi.jersey2.model.Order;
import io.nem.symbol.sdk.openapi.jersey2.model.ReceiptTypeEnum;
import io.nem.symbol.sdk.openapi.jersey2.model.ResolutionStatementPage;
import io.nem.symbol.sdk.openapi.jersey2.model.TransactionStatementPage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-08-14T13:43:37.324Z[UTC]")
public class ReceiptRoutesApi {
  private ApiClient apiClient;

  public ReceiptRoutesApi() {
    this(Configuration.getDefaultApiClient());
  }

  public ReceiptRoutesApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }
  /**
   * Get receipts address resolution statements
   * Gets an array of address resolution statements.
   * @param height Filter by block height. (optional, default to null)
   * @param pageSize Select the number of entries to return. (optional, default to 10)
   * @param pageNumber Filter by page number. (optional, default to 1)
   * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
   * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
   * @return ResolutionStatementPage
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ResolutionStatementPage searchAddressResolutionStatements(java.math.BigInteger height, Integer pageSize, Integer pageNumber, String offset, Order order) throws ApiException {
    return searchAddressResolutionStatementsWithHttpInfo(height, pageSize, pageNumber, offset, order).getData();
  }

  /**
   * Get receipts address resolution statements
   * Gets an array of address resolution statements.
   * @param height Filter by block height. (optional, default to null)
   * @param pageSize Select the number of entries to return. (optional, default to 10)
   * @param pageNumber Filter by page number. (optional, default to 1)
   * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
   * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
   * @return ApiResponse&lt;ResolutionStatementPage&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<ResolutionStatementPage> searchAddressResolutionStatementsWithHttpInfo(java.math.BigInteger height, Integer pageSize, Integer pageNumber, String offset, Order order) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/statements/resolutions/address";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "height", height));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageSize", pageSize));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageNumber", pageNumber));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "offset", offset));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "order", order));

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<ResolutionStatementPage> localVarReturnType = new GenericType<ResolutionStatementPage>() {};
    return apiClient.invokeAPI("ReceiptRoutesApi.searchAddressResolutionStatements", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Get receipts mosaic resolution statements
   * Gets an array of mosaic resolution statements.
   * @param height Filter by block height. (optional, default to null)
   * @param pageSize Select the number of entries to return. (optional, default to 10)
   * @param pageNumber Filter by page number. (optional, default to 1)
   * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
   * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
   * @return ResolutionStatementPage
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ResolutionStatementPage searchMosaicResolutionStatements(java.math.BigInteger height, Integer pageSize, Integer pageNumber, String offset, Order order) throws ApiException {
    return searchMosaicResolutionStatementsWithHttpInfo(height, pageSize, pageNumber, offset, order).getData();
  }

  /**
   * Get receipts mosaic resolution statements
   * Gets an array of mosaic resolution statements.
   * @param height Filter by block height. (optional, default to null)
   * @param pageSize Select the number of entries to return. (optional, default to 10)
   * @param pageNumber Filter by page number. (optional, default to 1)
   * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
   * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
   * @return ApiResponse&lt;ResolutionStatementPage&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<ResolutionStatementPage> searchMosaicResolutionStatementsWithHttpInfo(java.math.BigInteger height, Integer pageSize, Integer pageNumber, String offset, Order order) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/statements/resolutions/mosaic";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "height", height));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageSize", pageSize));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageNumber", pageNumber));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "offset", offset));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "order", order));

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<ResolutionStatementPage> localVarReturnType = new GenericType<ResolutionStatementPage>() {};
    return apiClient.invokeAPI("ReceiptRoutesApi.searchMosaicResolutionStatements", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
  /**
   * Search transaction statements
   * Gets an array of transaction statements.
   * @param height Filter by block height. (optional, default to null)
   * @param receiptType Filter by receipt type. To filter by multiple receipt types, add more filter query params like: &#x60;&#x60;receiptType&#x3D;8515&amp;receiptType&#x3D;20803&#x60;&#x60;.  (optional, default to new ArrayList&lt;&gt;())
   * @param recipientAddress Filter by address of the account receiving the transaction. (optional)
   * @param senderAddress Filter by address sending mosaics. (optional)
   * @param targetAddress Filter by target address. (optional)
   * @param artifactId Mosaic or namespace identifier (optional)
   * @param pageSize Select the number of entries to return. (optional, default to 10)
   * @param pageNumber Filter by page number. (optional, default to 1)
   * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
   * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
   * @return TransactionStatementPage
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public TransactionStatementPage searchReceipts(java.math.BigInteger height, List<ReceiptTypeEnum> receiptType, String recipientAddress, String senderAddress, String targetAddress, String artifactId, Integer pageSize, Integer pageNumber, String offset, Order order) throws ApiException {
    return searchReceiptsWithHttpInfo(height, receiptType, recipientAddress, senderAddress, targetAddress, artifactId, pageSize, pageNumber, offset, order).getData();
  }

  /**
   * Search transaction statements
   * Gets an array of transaction statements.
   * @param height Filter by block height. (optional, default to null)
   * @param receiptType Filter by receipt type. To filter by multiple receipt types, add more filter query params like: &#x60;&#x60;receiptType&#x3D;8515&amp;receiptType&#x3D;20803&#x60;&#x60;.  (optional, default to new ArrayList&lt;&gt;())
   * @param recipientAddress Filter by address of the account receiving the transaction. (optional)
   * @param senderAddress Filter by address sending mosaics. (optional)
   * @param targetAddress Filter by target address. (optional)
   * @param artifactId Mosaic or namespace identifier (optional)
   * @param pageSize Select the number of entries to return. (optional, default to 10)
   * @param pageNumber Filter by page number. (optional, default to 1)
   * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
   * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
   * @return ApiResponse&lt;TransactionStatementPage&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<TransactionStatementPage> searchReceiptsWithHttpInfo(java.math.BigInteger height, List<ReceiptTypeEnum> receiptType, String recipientAddress, String senderAddress, String targetAddress, String artifactId, Integer pageSize, Integer pageNumber, String offset, Order order) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/statements/transaction";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "height", height));
    localVarQueryParams.addAll(apiClient.parameterToPairs("multi", "receiptType", receiptType));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "recipientAddress", recipientAddress));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "senderAddress", senderAddress));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "targetAddress", targetAddress));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "artifactId", artifactId));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageSize", pageSize));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageNumber", pageNumber));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "offset", offset));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "order", order));

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<TransactionStatementPage> localVarReturnType = new GenericType<TransactionStatementPage>() {};
    return apiClient.invokeAPI("ReceiptRoutesApi.searchReceipts", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
}
