package io.nem.symbol.sdk.openapi.jersey2.api;

import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiException;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.jersey2.invoker.ApiResponse;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Configuration;
import io.nem.symbol.sdk.openapi.jersey2.invoker.Pair;

import javax.ws.rs.core.GenericType;

import io.nem.symbol.sdk.openapi.jersey2.model.MetadataPage;
import io.nem.symbol.sdk.openapi.jersey2.model.MetadataTypeEnum;
import io.nem.symbol.sdk.openapi.jersey2.model.ModelError;
import io.nem.symbol.sdk.openapi.jersey2.model.Order;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-08-14T13:43:37.324Z[UTC]")
public class MetadataRoutesApi {
  private ApiClient apiClient;

  public MetadataRoutesApi() {
    this(Configuration.getDefaultApiClient());
  }

  public MetadataRoutesApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }
  /**
   * Search metadata entries
   * Returns an array of metadata.
   * @param sourceAddress Filter by address sending the metadata entry. (optional)
   * @param targetAddress Filter by target address. (optional)
   * @param scopedMetadataKey Filter by metadata key. (optional)
   * @param targetId Filter by namespace or mosaic id. (optional)
   * @param metadataType Filter by metadata type. (optional)
   * @param pageSize Select the number of entries to return. (optional, default to 10)
   * @param pageNumber Filter by page number. (optional, default to 1)
   * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
   * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
   * @return MetadataPage
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public MetadataPage searchMetadataEntries(String sourceAddress, String targetAddress, String scopedMetadataKey, String targetId, MetadataTypeEnum metadataType, Integer pageSize, Integer pageNumber, String offset, Order order) throws ApiException {
    return searchMetadataEntriesWithHttpInfo(sourceAddress, targetAddress, scopedMetadataKey, targetId, metadataType, pageSize, pageNumber, offset, order).getData();
  }

  /**
   * Search metadata entries
   * Returns an array of metadata.
   * @param sourceAddress Filter by address sending the metadata entry. (optional)
   * @param targetAddress Filter by target address. (optional)
   * @param scopedMetadataKey Filter by metadata key. (optional)
   * @param targetId Filter by namespace or mosaic id. (optional)
   * @param metadataType Filter by metadata type. (optional)
   * @param pageSize Select the number of entries to return. (optional, default to 10)
   * @param pageNumber Filter by page number. (optional, default to 1)
   * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
   * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
   * @return ApiResponse&lt;MetadataPage&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
       <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
       <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<MetadataPage> searchMetadataEntriesWithHttpInfo(String sourceAddress, String targetAddress, String scopedMetadataKey, String targetId, MetadataTypeEnum metadataType, Integer pageSize, Integer pageNumber, String offset, Order order) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/metadata";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "sourceAddress", sourceAddress));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "targetAddress", targetAddress));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "scopedMetadataKey", scopedMetadataKey));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "targetId", targetId));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "metadataType", metadataType));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageSize", pageSize));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageNumber", pageNumber));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "offset", offset));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "order", order));

    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<MetadataPage> localVarReturnType = new GenericType<MetadataPage>() {};
    return apiClient.invokeAPI("MetadataRoutesApi.searchMetadataEntries", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
  }
}
