/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.jersey2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.nem.symbol.sdk.openapi.jersey2.model.MessageDTO;
import io.nem.symbol.sdk.openapi.jersey2.model.NetworkTypeEnum;
import io.nem.symbol.sdk.openapi.jersey2.model.UnresolvedMosaic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Transaction to transfer mosaics and a message to another account.")
@JsonPropertyOrder(value={"size", "signature", "signerPublicKey", "version", "network", "type", "maxFee", "deadline", "recipientAddress", "mosaics", "message"})
public class TransferTransactionDTO {
    public static final String JSON_PROPERTY_SIZE = "size";
    private Long size;
    public static final String JSON_PROPERTY_SIGNATURE = "signature";
    private String signature;
    public static final String JSON_PROPERTY_SIGNER_PUBLIC_KEY = "signerPublicKey";
    private String signerPublicKey;
    public static final String JSON_PROPERTY_VERSION = "version";
    private Integer version;
    public static final String JSON_PROPERTY_NETWORK = "network";
    private NetworkTypeEnum network;
    public static final String JSON_PROPERTY_TYPE = "type";
    private Integer type;
    public static final String JSON_PROPERTY_MAX_FEE = "maxFee";
    private BigInteger maxFee = null;
    public static final String JSON_PROPERTY_DEADLINE = "deadline";
    private BigInteger deadline = null;
    public static final String JSON_PROPERTY_RECIPIENT_ADDRESS = "recipientAddress";
    private String recipientAddress;
    public static final String JSON_PROPERTY_MOSAICS = "mosaics";
    private List<UnresolvedMosaic> mosaics = new ArrayList<UnresolvedMosaic>();
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private MessageDTO message;

    public TransferTransactionDTO size(Long size) {
        this.size = size;
        return this;
    }

    @ApiModelProperty(example="2222212828", required=true, value="A number that allows uint 32 values.")
    @JsonProperty(value="size")
    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public TransferTransactionDTO signature(String signature) {
        this.signature = signature;
        return this;
    }

    @ApiModelProperty(example="4B408BBEDF25F2AC8E0E44A6E51E3CCBA03885902055F75EB9FF50433532CA44BF9175FDA7502EEE2FC1617126E453A2BD692BAFDAAF06BC8EDEBA7961B3730D", required=true, value="Entity's signature generated by the signer.")
    @JsonProperty(value="signature")
    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public TransferTransactionDTO signerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
        return this;
    }

    @ApiModelProperty(example="AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required=true, value="Public key.")
    @JsonProperty(value="signerPublicKey")
    public String getSignerPublicKey() {
        return this.signerPublicKey;
    }

    public void setSignerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
    }

    public TransferTransactionDTO version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(required=true, value="Entity version.")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public TransferTransactionDTO network(NetworkTypeEnum network) {
        this.network = network;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="network")
    public NetworkTypeEnum getNetwork() {
        return this.network;
    }

    public void setNetwork(NetworkTypeEnum network) {
        this.network = network;
    }

    public TransferTransactionDTO type(Integer type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public TransferTransactionDTO maxFee(BigInteger maxFee) {
        this.maxFee = maxFee;
        return this;
    }

    @ApiModelProperty(example="123456", required=true, value="Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
    @JsonProperty(value="maxFee")
    public BigInteger getMaxFee() {
        return this.maxFee;
    }

    public void setMaxFee(BigInteger maxFee) {
        this.maxFee = maxFee;
    }

    public TransferTransactionDTO deadline(BigInteger deadline) {
        this.deadline = deadline;
        return this;
    }

    @ApiModelProperty(example="200", required=true, value="Duration expressed in number of blocks.")
    @JsonProperty(value="deadline")
    public BigInteger getDeadline() {
        return this.deadline;
    }

    public void setDeadline(BigInteger deadline) {
        this.deadline = deadline;
    }

    public TransferTransactionDTO recipientAddress(String recipientAddress) {
        this.recipientAddress = recipientAddress;
        return this;
    }

    @ApiModelProperty(example="90340017CFF3DD2BCF3B2670CDCB9FC8C75754E2325F297C", required=true, value="Address expressed in hexadecimal base. If the bit 0 of byte 0 is not set (like in 0x90), then it is a regular address. Else (e.g. 0x91) it represents a namespace id which starts at byte 1. ")
    @JsonProperty(value="recipientAddress")
    public String getRecipientAddress() {
        return this.recipientAddress;
    }

    public void setRecipientAddress(String recipientAddress) {
        this.recipientAddress = recipientAddress;
    }

    public TransferTransactionDTO mosaics(List<UnresolvedMosaic> mosaics) {
        this.mosaics = mosaics;
        return this;
    }

    public TransferTransactionDTO addMosaicsItem(UnresolvedMosaic mosaicsItem) {
        this.mosaics.add(mosaicsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Array of mosaics sent to the recipient. ")
    @JsonProperty(value="mosaics")
    public List<UnresolvedMosaic> getMosaics() {
        return this.mosaics;
    }

    public void setMosaics(List<UnresolvedMosaic> mosaics) {
        this.mosaics = mosaics;
    }

    public TransferTransactionDTO message(MessageDTO message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="message")
    public MessageDTO getMessage() {
        return this.message;
    }

    public void setMessage(MessageDTO message) {
        this.message = message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferTransactionDTO transferTransactionDTO = (TransferTransactionDTO)o;
        return Objects.equals(this.size, transferTransactionDTO.size) && Objects.equals(this.signature, transferTransactionDTO.signature) && Objects.equals(this.signerPublicKey, transferTransactionDTO.signerPublicKey) && Objects.equals(this.version, transferTransactionDTO.version) && Objects.equals((Object)this.network, (Object)transferTransactionDTO.network) && Objects.equals(this.type, transferTransactionDTO.type) && Objects.equals(this.maxFee, transferTransactionDTO.maxFee) && Objects.equals(this.deadline, transferTransactionDTO.deadline) && Objects.equals(this.recipientAddress, transferTransactionDTO.recipientAddress) && Objects.equals(this.mosaics, transferTransactionDTO.mosaics) && Objects.equals(this.message, transferTransactionDTO.message);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.size, this.signature, this.signerPublicKey, this.version, this.network, this.type, this.maxFee, this.deadline, this.recipientAddress, this.mosaics, this.message});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferTransactionDTO {\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    signature: ").append(this.toIndentedString(this.signature)).append("\n");
        sb.append("    signerPublicKey: ").append(this.toIndentedString(this.signerPublicKey)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    network: ").append(this.toIndentedString((Object)this.network)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    maxFee: ").append(this.toIndentedString(this.maxFee)).append("\n");
        sb.append("    deadline: ").append(this.toIndentedString(this.deadline)).append("\n");
        sb.append("    recipientAddress: ").append(this.toIndentedString(this.recipientAddress)).append("\n");
        sb.append("    mosaics: ").append(this.toIndentedString(this.mosaics)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

